/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.bindings.pdc;

import java.security.PrivateKey;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.bindings.pdc.InvalidSignatureException;
import tech.relaycorp.relaynet.crypto.SignedData;
import tech.relaycorp.relaynet.crypto.SignedDataException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0017"}, d2={"Ltech/relaycorp/relaynet/bindings/pdc/DetachedSignatureType;", "", "oid", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "<init>", "(Ljava/lang/String;ILorg/bouncycastle/asn1/ASN1ObjectIdentifier;)V", "getOid$awala", "()Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "PARCEL_DELIVERY", "NONCE", "sign", "", "plaintext", "privateKey", "Ljava/security/PrivateKey;", "signerCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "verify", "signatureSerialized", "expectedPlaintext", "trustedCertificates", "", "makePlaintextSafe", "awala"})
@SourceDebugExtension(value={"SMAP\nDetachedSignatureType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetachedSignatureType.kt\ntech/relaycorp/relaynet/bindings/pdc/DetachedSignatureType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class DetachedSignatureType
extends Enum<DetachedSignatureType> {
    @NotNull
    private final ASN1ObjectIdentifier oid;
    public static final /* enum */ DetachedSignatureType PARCEL_DELIVERY;
    public static final /* enum */ DetachedSignatureType NONCE;
    private static final /* synthetic */ DetachedSignatureType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private DetachedSignatureType(ASN1ObjectIdentifier oid) {
        this.oid = oid;
    }

    @NotNull
    public final ASN1ObjectIdentifier getOid$awala() {
        return this.oid;
    }

    @NotNull
    public final byte[] sign(@NotNull byte[] plaintext, @NotNull PrivateKey privateKey, @NotNull Certificate signerCertificate) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)signerCertificate, (String)"signerCertificate");
        byte[] safePlaintext = this.makePlaintextSafe(plaintext);
        SignedData signedData = SignedData.Companion.sign$default(SignedData.Companion, safePlaintext, privateKey, signerCertificate, SetsKt.setOf((Object)signerCertificate), null, false, 16, null);
        return signedData.serialize();
    }

    @NotNull
    public final Certificate verify(@NotNull byte[] signatureSerialized, @NotNull byte[] expectedPlaintext, @NotNull List<Certificate> trustedCertificates) throws InvalidSignatureException {
        SignedData signedData;
        Intrinsics.checkNotNullParameter((Object)signatureSerialized, (String)"signatureSerialized");
        Intrinsics.checkNotNullParameter((Object)expectedPlaintext, (String)"expectedPlaintext");
        Intrinsics.checkNotNullParameter(trustedCertificates, (String)"trustedCertificates");
        byte[] safePlaintext = this.makePlaintextSafe(expectedPlaintext);
        try {
            SignedData it = signedData = SignedData.Companion.deserialize(signatureSerialized);
            boolean bl = false;
            it.verify(safePlaintext);
        }
        catch (SignedDataException exc) {
            throw new InvalidSignatureException("SignedData value is invalid", exc);
        }
        SignedData signedData2 = signedData;
        Certificate certificate = signedData2.getSignerCertificate();
        Intrinsics.checkNotNull((Object)certificate);
        Certificate signerCertificate = certificate;
        try {
            signerCertificate.getCertificationPath(CollectionsKt.emptyList(), (Collection<Certificate>)trustedCertificates);
        }
        catch (CertificateException exc) {
            throw new InvalidSignatureException("Signer is not trusted", exc);
        }
        return signerCertificate;
    }

    private final byte[] makePlaintextSafe(byte[] plaintext) {
        Object[] objectArray = new ASN1Primitive[]{this.oid, new DEROctetString(plaintext)};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    public static DetachedSignatureType[] values() {
        return (DetachedSignatureType[])$VALUES.clone();
    }

    public static DetachedSignatureType valueOf(String value) {
        return Enum.valueOf(DetachedSignatureType.class, value);
    }

    @NotNull
    public static EnumEntries<DetachedSignatureType> getEntries() {
        return $ENTRIES;
    }

    static {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = OIDs.INSTANCE.getDETACHED_SIGNATURE().branch("0").intern();
        Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier, (String)"intern(...)");
        PARCEL_DELIVERY = new DetachedSignatureType(aSN1ObjectIdentifier);
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = OIDs.INSTANCE.getDETACHED_SIGNATURE().branch("1").intern();
        Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier2, (String)"intern(...)");
        NONCE = new DetachedSignatureType(aSN1ObjectIdentifier2);
        $VALUES = detachedSignatureTypeArray = new DetachedSignatureType[]{DetachedSignatureType.PARCEL_DELIVERY, DetachedSignatureType.NONCE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

