/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.crypto;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.crypto.SignedDataException;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\tJ\u0012\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Ltech/relaycorp/relaynet/crypto/SignedData;", "", "bcSignedData", "Lorg/bouncycastle/cms/CMSSignedData;", "<init>", "(Lorg/bouncycastle/cms/CMSSignedData;)V", "getBcSignedData$awala", "()Lorg/bouncycastle/cms/CMSSignedData;", "plaintext", "", "getPlaintext", "()[B", "plaintext$delegate", "Lkotlin/Lazy;", "signerCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getSignerCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "signerCertificate$delegate", "certificates", "", "getCertificates", "()Ljava/util/Set;", "certificates$delegate", "serialize", "verify", "", "expectedPlaintext", "Companion", "awala"})
@SourceDebugExtension(value={"SMAP\nSignedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignedData.kt\ntech/relaycorp/relaynet/crypto/SignedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1557#2:208\n1628#2,3:209\n*S KotlinDebug\n*F\n+ 1 SignedData.kt\ntech/relaycorp/relaynet/crypto/SignedData\n*L\n63#1:208\n63#1:209,3\n*E\n"})
public final class SignedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMSSignedData bcSignedData;
    @NotNull
    private final Lazy plaintext$delegate;
    @NotNull
    private final Lazy signerCertificate$delegate;
    @NotNull
    private final Lazy certificates$delegate;
    @NotNull
    private static final Map<HashingAlgorithm, String> signatureAlgorithmMap;

    public SignedData(@NotNull CMSSignedData bcSignedData) {
        Intrinsics.checkNotNullParameter((Object)bcSignedData, (String)"bcSignedData");
        this.bcSignedData = bcSignedData;
        this.plaintext$delegate = LazyKt.lazy(() -> SignedData.plaintext_delegate$lambda$0(this));
        this.signerCertificate$delegate = LazyKt.lazy(() -> SignedData.signerCertificate_delegate$lambda$1(this));
        this.certificates$delegate = LazyKt.lazy(() -> SignedData.certificates_delegate$lambda$3(this));
    }

    @NotNull
    public final CMSSignedData getBcSignedData$awala() {
        return this.bcSignedData;
    }

    @Nullable
    public final byte[] getPlaintext() {
        Lazy lazy = this.plaintext$delegate;
        return (byte[])lazy.getValue();
    }

    @Nullable
    public final Certificate getSignerCertificate() {
        Lazy lazy = this.signerCertificate$delegate;
        return (Certificate)lazy.getValue();
    }

    @NotNull
    public final Set<Certificate> getCertificates() {
        Lazy lazy = this.certificates$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.bcSignedData.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    public final void verify(@Nullable byte[] expectedPlaintext) throws SignedDataException {
        boolean bl;
        if (this.getPlaintext() != null && expectedPlaintext != null) {
            throw new SignedDataException("No specific plaintext should be expected because one is already encapsulated", null, 2, null);
        }
        byte[] byArray = this.getPlaintext();
        if (byArray == null) {
            byArray = expectedPlaintext;
            if (expectedPlaintext == null) {
                throw new SignedDataException("Plaintext should be encapsulated or explicitly set", null, 2, null);
            }
        }
        byte[] signedPlaintext = byArray;
        if (this.getSignerCertificate() == null) {
            throw new SignedDataException("Signer certificate should be encapsulated", null, 2, null);
        }
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(signedPlaintext), this.bcSignedData.toASN1Structure());
        SignerInformation signerInfo = SignedData.Companion.getSignerInfo(signedData);
        JcaSimpleSignerInfoVerifierBuilder verifierBuilder = new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)CryptoUtils.getBC_PROVIDER());
        Certificate certificate = this.getSignerCertificate();
        Intrinsics.checkNotNull((Object)certificate);
        SignerInformationVerifier verifier = verifierBuilder.build(certificate.getCertificateHolder$awala());
        try {
            bl = signerInfo.verify(verifier);
        }
        catch (CMSException exc) {
            throw new SignedDataException("Could not verify signature", exc);
        }
        boolean isValid = bl;
        if (!isValid) {
            throw new SignedDataException("Invalid signature", null, 2, null);
        }
    }

    public static /* synthetic */ void verify$default(SignedData signedData, byte[] byArray, int n, Object object) throws SignedDataException {
        if ((n & 1) != 0) {
            byArray = null;
        }
        signedData.verify(byArray);
    }

    private static final byte[] plaintext_delegate$lambda$0(SignedData this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CMSTypedData cMSTypedData = this$0.bcSignedData.getSignedContent();
        return (byte[])(cMSTypedData != null ? cMSTypedData.getContent() : null);
    }

    private static final Certificate signerCertificate_delegate$lambda$1(SignedData this$0) {
        Certificate certificate;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SignerInformation signerInfo = SignedData.Companion.getSignerInfo(this$0.bcSignedData);
        Selector signerCertSelector = (Selector)new X509CertificateHolderSelector(signerInfo.getSID().getIssuer(), signerInfo.getSID().getSerialNumber());
        Collection signerCertMatches = this$0.bcSignedData.getCertificates().getMatches(signerCertSelector);
        try {
            Intrinsics.checkNotNull((Object)signerCertMatches);
            Object object = CollectionsKt.first((Iterable)signerCertMatches);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            certificate = new Certificate((X509CertificateHolder)object);
        }
        catch (NoSuchElementException noSuchElementException) {
            certificate = null;
        }
        return certificate;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set certificates_delegate$lambda$3(SignedData this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Store store = this$0.bcSignedData.getCertificates();
        Intrinsics.checkNotNull((Object)store, (String)"null cannot be cast to non-null type org.bouncycastle.util.CollectionStore<@[FlexibleNullability] org.bouncycastle.cert.X509CertificateHolder?>");
        Iterable $this$map$iv = (Iterable)((CollectionStore)store);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new Certificate((X509CertificateHolder)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    @NotNull
    public static final SignedData sign(@NotNull byte[] plaintext, @NotNull PrivateKey signerPrivateKey, @NotNull Certificate signerCertificate, @NotNull Set<Certificate> encapsulatedCertificates, @Nullable HashingAlgorithm hashingAlgorithm, boolean encapsulatePlaintext) {
        return Companion.sign(plaintext, signerPrivateKey, signerCertificate, encapsulatedCertificates, hashingAlgorithm, encapsulatePlaintext);
    }

    @JvmStatic
    @NotNull
    public static final SignedData deserialize(@NotNull byte[] serialization) {
        return Companion.deserialize(serialization);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)HashingAlgorithm.SHA256), (Object)"SHA256WITHRSAANDMGF1"), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA384), (Object)"SHA384WITHRSAANDMGF1"), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA512), (Object)"SHA512WITHRSAANDMGF1")};
        signatureAlgorithmMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ltech/relaycorp/relaynet/crypto/SignedData$Companion;", "", "<init>", "()V", "signatureAlgorithmMap", "", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "", "sign", "Ltech/relaycorp/relaynet/crypto/SignedData;", "plaintext", "", "signerPrivateKey", "Ljava/security/PrivateKey;", "signerCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "encapsulatedCertificates", "", "hashingAlgorithm", "encapsulatePlaintext", "", "makeSignerInfoGeneratorBuilder", "Lorg/bouncycastle/cms/jcajce/JcaSignerInfoGeneratorBuilder;", "makeContentSigner", "Lorg/bouncycastle/operator/ContentSigner;", "deserialize", "serialization", "getSignerInfo", "Lorg/bouncycastle/cms/SignerInformation;", "bcSignedData", "Lorg/bouncycastle/cms/CMSSignedData;", "awala"})
    @SourceDebugExtension(value={"SMAP\nSignedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignedData.kt\ntech/relaycorp/relaynet/crypto/SignedData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1557#2:208\n1628#2,3:209\n*S KotlinDebug\n*F\n+ 1 SignedData.kt\ntech/relaycorp/relaynet/crypto/SignedData$Companion\n*L\n135#1:208\n135#1:209,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SignedData sign(@NotNull byte[] plaintext, @NotNull PrivateKey signerPrivateKey, @NotNull Certificate signerCertificate, @NotNull Set<Certificate> encapsulatedCertificates, @Nullable HashingAlgorithm hashingAlgorithm, boolean encapsulatePlaintext) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)signerPrivateKey, (String)"signerPrivateKey");
            Intrinsics.checkNotNullParameter((Object)signerCertificate, (String)"signerCertificate");
            Intrinsics.checkNotNullParameter(encapsulatedCertificates, (String)"encapsulatedCertificates");
            ContentSigner contentSigner = this.makeContentSigner(signerPrivateKey, hashingAlgorithm);
            SignerInfoGenerator signerInfoGenerator = this.makeSignerInfoGeneratorBuilder().build(contentSigner, signerCertificate.getCertificateHolder$awala());
            CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
            signedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            Iterable $this$map$iv = encapsulatedCertificates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Certificate certificate = (Certificate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCertificateHolder$awala());
            }
            Collection collection = (List)destination$iv$iv;
            JcaCertStore certs = new JcaCertStore(collection);
            signedDataGenerator.addCertificates((Store)certs);
            CMSTypedData plaintextCms = (CMSTypedData)new CMSProcessableByteArray(plaintext);
            CMSSignedData bcSignedData = signedDataGenerator.generate(plaintextCms, encapsulatePlaintext);
            iterable = encapsulatePlaintext ? bcSignedData : new CMSSignedData(bcSignedData.toASN1Structure());
            Intrinsics.checkNotNull((Object)iterable);
            return new SignedData((CMSSignedData)iterable);
        }

        public static /* synthetic */ SignedData sign$default(Companion companion, byte[] byArray, PrivateKey privateKey, Certificate certificate, Set set, HashingAlgorithm hashingAlgorithm, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 0x10) != 0) {
                hashingAlgorithm = null;
            }
            if ((n & 0x20) != 0) {
                bl = true;
            }
            return companion.sign(byArray, privateKey, certificate, set, hashingAlgorithm, bl);
        }

        private final JcaSignerInfoGeneratorBuilder makeSignerInfoGeneratorBuilder() {
            return new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build());
        }

        private final ContentSigner makeContentSigner(PrivateKey signerPrivateKey, HashingAlgorithm hashingAlgorithm) {
            HashingAlgorithm hashingAlgorithm2 = hashingAlgorithm;
            if (hashingAlgorithm2 == null) {
                hashingAlgorithm2 = HashingAlgorithm.SHA256;
            }
            HashingAlgorithm algorithm = hashingAlgorithm2;
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder((String)signatureAlgorithmMap.get((Object)algorithm)).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            ContentSigner contentSigner = signerBuilder.build(signerPrivateKey);
            Intrinsics.checkNotNullExpressionValue((Object)contentSigner, (String)"build(...)");
            return contentSigner;
        }

        @JvmStatic
        @NotNull
        public final SignedData deserialize(@NotNull byte[] serialization) {
            CMSSignedData cMSSignedData;
            ASN1Primitive aSN1Primitive;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            if (serialization.length == 0) {
                throw new SignedDataException("Value cannot be empty", null, 2, null);
            }
            ASN1InputStream asn1Stream = new ASN1InputStream(serialization);
            try {
                aSN1Primitive = asn1Stream.readObject();
            }
            catch (IOException iOException) {
                throw new SignedDataException("Value is not DER-encoded", null, 2, null);
            }
            ASN1Primitive asn1Sequence = aSN1Primitive;
            try {
                ContentInfo iOException = ContentInfo.getInstance((Object)asn1Sequence);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SignedDataException("SignedData value is not wrapped in ContentInfo", null, 2, null);
            }
            ContentInfo contentInfo = iOException;
            try {
                cMSSignedData = new CMSSignedData(contentInfo);
            }
            catch (CMSException cMSException) {
                throw new SignedDataException("ContentInfo wraps invalid SignedData value", null, 2, null);
            }
            CMSSignedData bcSignedData = cMSSignedData;
            return new SignedData(bcSignedData);
        }

        private final SignerInformation getSignerInfo(CMSSignedData bcSignedData) {
            int signersCount = bcSignedData.getSignerInfos().size();
            if (signersCount != 1) {
                throw new SignedDataException("SignedData should contain exactly one SignerInfo (got " + signersCount + ")", null, 2, null);
            }
            SignerInformationStore signerInformationStore = bcSignedData.getSignerInfos();
            Intrinsics.checkNotNullExpressionValue((Object)signerInformationStore, (String)"getSignerInfos(...)");
            Object object = CollectionsKt.first((Iterable)((Iterable)signerInformationStore));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            return (SignerInformation)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

