/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.ByteSpreadBuilder;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1VisibleString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.crypto.SignedData;
import tech.relaycorp.relaynet.crypto.SignedDataException;
import tech.relaycorp.relaynet.messages.Recipient;
import tech.relaycorp.relaynet.ramf.FieldSet;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFMessage;
import tech.relaycorp.relaynet.ramf.RAMFSerializerKt;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005Ji\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102N\u0010\u0011\u001aJ\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0018\u0012\u0004\u0012\u0002H\u000e0\u0012j\b\u0012\u0004\u0012\u0002H\u000e`\u0019\u00a2\u0006\u0002\u0010\u001aJi\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u001b\u001a\u00020\n2N\u0010\u0011\u001aJ\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0018\u0012\u0004\u0012\u0002H\u000e0\u0012j\b\u0012\u0004\u0012\u0002H\u000e`\u0019\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\nH\u0002J&\u0010\u001f\u001a\u00020\n2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%J\u0014\u0010&\u001a\u00020\n2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFSerializer;", "", "concreteMessageType", "", "concreteMessageVersion", "(BB)V", "getConcreteMessageType", "()B", "getConcreteMessageVersion", "formatSignature", "", "getFormatSignature", "()[B", "deserialize", "T", "serializationStream", "Ljava/io/InputStream;", "messageClazz", "Lkotlin/Function7;", "Ltech/relaycorp/relaynet/messages/Recipient;", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "", "Ljava/time/ZonedDateTime;", "", "", "Ltech/relaycorp/relaynet/ramf/RAMFMessageConstructor;", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function7;)Ljava/lang/Object;", "serialization", "([BLkotlin/jvm/functions/Function7;)Ljava/lang/Object;", "deserializeFields", "Ltech/relaycorp/relaynet/ramf/FieldSet;", "serialize", "message", "Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "signerPrivateKey", "Ljava/security/PrivateKey;", "hashingAlgorithm", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "serializeMessage", "awala"})
@SourceDebugExtension(value={"SMAP\nRAMFSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RAMFSerializer.kt\ntech/relaycorp/relaynet/ramf/RAMFSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1#2:190\n766#3:191\n857#3,2:192\n*S KotlinDebug\n*F\n+ 1 RAMFSerializer.kt\ntech/relaycorp/relaynet/ramf/RAMFSerializer\n*L\n130#1:191\n130#1:192,2\n*E\n"})
public final class RAMFSerializer {
    private final byte concreteMessageType;
    private final byte concreteMessageVersion;
    @NotNull
    private final byte[] formatSignature;

    public RAMFSerializer(byte concreteMessageType, byte concreteMessageVersion) {
        this.concreteMessageType = concreteMessageType;
        this.concreteMessageVersion = concreteMessageVersion;
        ByteSpreadBuilder byteSpreadBuilder = new ByteSpreadBuilder(3);
        String string = "Awala";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byteSpreadBuilder.addSpread((Object)byArray);
        byteSpreadBuilder.add(this.concreteMessageType);
        byteSpreadBuilder.add(this.concreteMessageVersion);
        this.formatSignature = byteSpreadBuilder.toArray();
    }

    public final byte getConcreteMessageType() {
        return this.concreteMessageType;
    }

    public final byte getConcreteMessageVersion() {
        return this.concreteMessageVersion;
    }

    @NotNull
    public final byte[] getFormatSignature() {
        return this.formatSignature;
    }

    @NotNull
    public final byte[] serialize(@NotNull RAMFMessage<?> message, @NotNull PrivateKey signerPrivateKey, @Nullable HashingAlgorithm hashingAlgorithm) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)signerPrivateKey, (String)"signerPrivateKey");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(this.formatSignature);
        byte[] fieldSetSerialized = this.serializeMessage(message);
        SignedData signedData = SignedData.Companion.sign$default(SignedData.Companion, fieldSetSerialized, signerPrivateKey, message.getSenderCertificate(), SetsKt.plus((Set)SetsKt.setOf((Object)message.getSenderCertificate()), (Iterable)message.getSenderCertificateChain()), hashingAlgorithm, false, 32, null);
        output.write(signedData.serialize());
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] serialize$default(RAMFSerializer rAMFSerializer, RAMFMessage rAMFMessage, PrivateKey privateKey, HashingAlgorithm hashingAlgorithm, int n, Object object) {
        if ((n & 4) != 0) {
            hashingAlgorithm = null;
        }
        return rAMFSerializer.serialize(rAMFMessage, privateKey, hashingAlgorithm);
    }

    private final byte[] serializeMessage(RAMFMessage<?> message) throws IOException {
        ZonedDateTime creationTimeUtc = message.getCreationDate().withZoneSameInstant(RAMFSerializerKt.access$getUTC_ZONE_ID$p());
        String creationTimeUtcString = creationTimeUtc.format(ASN1Utils.INSTANCE.getBER_DATETIME_FORMATTER());
        Object[] objectArray = new ASN1Primitive[]{message.getRecipient().serialize$awala(), new DERVisibleString(message.getId()), new DERGeneralizedTime(creationTimeUtcString), new ASN1Integer((long)message.getTtl()), new DEROctetString(message.getPayload())};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    public final <T> T deserialize(@NotNull byte[] serialization, @NotNull Function7<? super Recipient, ? super byte[], ? super Certificate, ? super String, ? super ZonedDateTime, ? super Integer, ? super Set<Certificate>, ? extends T> messageClazz) throws RAMFException {
        Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
        Intrinsics.checkNotNullParameter(messageClazz, (String)"messageClazz");
        return this.deserialize(new ByteArrayInputStream(serialization), messageClazz);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T deserialize(@NotNull InputStream serializationStream, @NotNull Function7<? super Recipient, ? super byte[], ? super Certificate, ? super String, ? super ZonedDateTime, ? super Integer, ? super Set<Certificate>, ? extends T> messageClazz) throws RAMFException {
        void $this$filterTo$iv$iv;
        SignedData signedData;
        Intrinsics.checkNotNullParameter((Object)serializationStream, (String)"serializationStream");
        Intrinsics.checkNotNullParameter(messageClazz, (String)"messageClazz");
        int serializationSize = serializationStream.available();
        if (0x900000 < serializationSize) {
            throw new RAMFException("Message should not be larger than 9 MiB", null, 2, null);
        }
        if (serializationSize < 7) {
            throw new RAMFException("Serialization is too short to contain format signature", null, 2, null);
        }
        byte[] magicConstant = new byte[5];
        serializationStream.read(magicConstant, 0, magicConstant.length);
        byte[] byArray = magicConstant;
        Charset charset = Charset.forName("ASCII");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        if (!Intrinsics.areEqual((Object)new String(byArray, charset2), (Object)"Awala")) {
            throw new RAMFException("Format signature should start with magic constant 'Awala'", null, 2, null);
        }
        int messageType = serializationStream.read();
        if (messageType != this.concreteMessageType) {
            throw new RAMFException("Message type should be " + this.concreteMessageType + " (got " + messageType + ")", null, 2, null);
        }
        int messageVersion = serializationStream.read();
        if (messageVersion != this.concreteMessageVersion) {
            throw new RAMFException("Message version should be " + this.concreteMessageVersion + " (got " + messageVersion + ")", null, 2, null);
        }
        try {
            SignedData it = signedData = SignedData.Companion.deserialize(ByteStreamsKt.readBytes((InputStream)serializationStream));
            boolean bl = false;
            SignedData.verify$default(it, null, 1, null);
        }
        catch (SignedDataException exc) {
            throw new RAMFException("Invalid CMS SignedData value", exc);
        }
        SignedData cmsSignedData = signedData;
        byte[] byArray2 = cmsSignedData.getPlaintext();
        Intrinsics.checkNotNull((Object)byArray2);
        FieldSet fields = this.deserializeFields(byArray2);
        Iterable $this$filter$iv = cmsSignedData.getCertificates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Certificate it = (Certificate)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)cmsSignedData.getSignerCertificate()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set intermediateCACerts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Recipient recipient = fields.getRecipient();
        byte[] byArray3 = fields.getPayload();
        Certificate certificate = cmsSignedData.getSignerCertificate();
        Intrinsics.checkNotNull((Object)certificate);
        return (T)messageClazz.invoke((Object)recipient, (Object)byArray3, (Object)certificate, (Object)fields.getMessageId(), (Object)fields.getCreationDate(), (Object)fields.getTtl(), (Object)intermediateCACerts);
    }

    private final FieldSet deserializeFields(byte[] serialization) throws RAMFException {
        LocalDateTime localDateTime;
        ASN1TaggedObject[] aSN1TaggedObjectArray;
        try {
            aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
        }
        catch (ASN1Exception exc) {
            throw new RAMFException("Invalid RAMF message", exc);
        }
        ASN1TaggedObject[] fields = aSN1TaggedObjectArray;
        if (fields.length != 5) {
            throw new RAMFException("Field sequence should contain 5 items (got " + fields.length + ")", null, 2, null);
        }
        Recipient recipient = Recipient.Companion.deserialize$awala(fields[0]);
        ASN1VisibleString messageId = ASN1Utils.INSTANCE.getVisibleString(fields[1]);
        ASN1VisibleString creationTimeDer = ASN1Utils.INSTANCE.getVisibleString(fields[2]);
        try {
            localDateTime = LocalDateTime.parse(creationTimeDer.getString(), ASN1Utils.INSTANCE.getBER_DATETIME_FORMATTER());
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new RAMFException("Creation time should be an ASN.1 DATE-TIME value", null, 2, null);
        }
        LocalDateTime creationTime = localDateTime;
        ASN1Integer ttlDer = ASN1Integer.getInstance((ASN1TaggedObject)fields[3], (boolean)false);
        ASN1OctetString payloadDer = ASN1Utils.INSTANCE.getOctetString(fields[4]);
        String string = messageId.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        ZonedDateTime zonedDateTime = ZonedDateTime.of(creationTime, RAMFSerializerKt.access$getUTC_ZONE_ID$p());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(...)");
        int n = ttlDer.intPositiveValueExact();
        byte[] byArray = payloadDer.getOctets();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOctets(...)");
        return new FieldSet(recipient, string, zonedDateTime, n, byArray);
    }
}

