/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.messages.control.HandshakeResponse;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ltech/relaycorp/relaynet/messages/control/HandshakeResponse;", "", "nonceSignatures", "", "", "(Ljava/util/List;)V", "getNonceSignatures", "()Ljava/util/List;", "serialize", "Companion", "awala"})
@SourceDebugExtension(value={"SMAP\nHandshakeResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandshakeResponse.kt\ntech/relaycorp/relaynet/messages/control/HandshakeResponse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1855#2,2:37\n*S KotlinDebug\n*F\n+ 1 HandshakeResponse.kt\ntech/relaycorp/relaynet/messages/control/HandshakeResponse\n*L\n13#1:37,2\n*E\n"})
public final class HandshakeResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<byte[]> nonceSignatures;

    public HandshakeResponse(@NotNull List<byte[]> nonceSignatures2) {
        Intrinsics.checkNotNullParameter(nonceSignatures2, (String)"nonceSignatures");
        this.nonceSignatures = nonceSignatures2;
    }

    @NotNull
    public final List<byte[]> getNonceSignatures() {
        return this.nonceSignatures;
    }

    @NotNull
    public final byte[] serialize() {
        ASN1EncodableVector nonceSignaturesASN1 = new ASN1EncodableVector(this.nonceSignatures.size());
        Iterable $this$forEach$iv = this.nonceSignatures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] it = (byte[])element$iv;
            boolean bl = false;
            nonceSignaturesASN1.add((ASN1Encodable)new DEROctetString(it));
        }
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object)new DERSequence(nonceSignaturesASN1)), false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/messages/control/HandshakeResponse$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/HandshakeResponse;", "serialization", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HandshakeResponse deserialize(@NotNull byte[] serialization) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                objectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new InvalidMessageException("Handshake response is not a DER sequence", exc);
            }
            Object[] sequence = objectArray;
            if (sequence.length == 0) {
                throw new InvalidMessageException("Handshake response sequence should have at least 1 item", null, 2, null);
            }
            ASN1Sequence nonceSignaturesASN1 = DERSequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)ArraysKt.first((Object[])sequence)), (boolean)false);
            Enumeration enumeration = nonceSignaturesASN1.getObjects();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getObjects(...)");
            List nonceSignatures2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration)), (Function1)deserialize.nonceSignatures.1.INSTANCE));
            return new HandshakeResponse(nonceSignatures2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

