/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.ECDHCurve;
import tech.relaycorp.relaynet.SessionKey;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.PRNGKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Ltech/relaycorp/relaynet/SessionKeyPair;", "", "sessionKey", "Ltech/relaycorp/relaynet/SessionKey;", "privateKey", "Ljava/security/PrivateKey;", "(Ltech/relaycorp/relaynet/SessionKey;Ljava/security/PrivateKey;)V", "getPrivateKey", "()Ljava/security/PrivateKey;", "getSessionKey", "()Ltech/relaycorp/relaynet/SessionKey;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "awala"})
public final class SessionKeyPair {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionKey sessionKey;
    @NotNull
    private final PrivateKey privateKey;

    public SessionKeyPair(@NotNull SessionKey sessionKey, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this.sessionKey = sessionKey;
        this.privateKey = privateKey;
    }

    @NotNull
    public final SessionKey getSessionKey() {
        return this.sessionKey;
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final SessionKey component1() {
        return this.sessionKey;
    }

    @NotNull
    public final PrivateKey component2() {
        return this.privateKey;
    }

    @NotNull
    public final SessionKeyPair copy(@NotNull SessionKey sessionKey, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return new SessionKeyPair(sessionKey, privateKey);
    }

    public static /* synthetic */ SessionKeyPair copy$default(SessionKeyPair sessionKeyPair, SessionKey sessionKey, PrivateKey privateKey, int n, Object object) {
        if ((n & 1) != 0) {
            sessionKey = sessionKeyPair.sessionKey;
        }
        if ((n & 2) != 0) {
            privateKey = sessionKeyPair.privateKey;
        }
        return sessionKeyPair.copy(sessionKey, privateKey);
    }

    @NotNull
    public String toString() {
        return "SessionKeyPair(sessionKey=" + this.sessionKey + ", privateKey=" + this.privateKey + ')';
    }

    public int hashCode() {
        int result = this.sessionKey.hashCode();
        result = result * 31 + this.privateKey.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionKeyPair)) {
            return false;
        }
        SessionKeyPair sessionKeyPair = (SessionKeyPair)other;
        if (!Intrinsics.areEqual((Object)this.sessionKey, (Object)sessionKeyPair.sessionKey)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.privateKey, (Object)sessionKeyPair.privateKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/SessionKeyPair$Companion;", "", "()V", "generate", "Ltech/relaycorp/relaynet/SessionKeyPair;", "curve", "Ltech/relaycorp/relaynet/ECDHCurve;", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionKeyPair generate(@NotNull ECDHCurve curve) {
            Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
            byte[] keyId = PRNGKt.generateRandomOctets(8);
            KeyPair sessionKeyPair = Keys.generateECDHKeyPair(curve);
            PublicKey publicKey = sessionKeyPair.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
            SessionKey sessionKey = new SessionKey(keyId, publicKey);
            PrivateKey privateKey = sessionKeyPair.getPrivate();
            Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
            return new SessionKeyPair(sessionKey, privateKey);
        }

        public static /* synthetic */ SessionKeyPair generate$default(Companion companion, ECDHCurve eCDHCurve, int n, Object object) {
            if ((n & 1) != 0) {
                eCDHCurve = ECDHCurve.P256;
            }
            return companion.generate(eCDHCurve);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

