/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.pki;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.pki.CertificationPathException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ltech/relaycorp/relaynet/pki/CertificationPath;", "", "leafCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "certificateAuthorities", "", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/util/List;)V", "getCertificateAuthorities", "()Ljava/util/List;", "getLeafCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "encode", "Lorg/bouncycastle/asn1/DERSequence;", "encode$awala", "serialize", "", "validate", "", "Companion", "awala"})
@SourceDebugExtension(value={"SMAP\nCertificationPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath\n*L\n34#1:103\n34#1:104,3\n*E\n"})
public final class CertificationPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Certificate leafCertificate;
    @NotNull
    private final List<Certificate> certificateAuthorities;

    public CertificationPath(@NotNull Certificate leafCertificate, @NotNull List<Certificate> certificateAuthorities) {
        Intrinsics.checkNotNullParameter((Object)leafCertificate, (String)"leafCertificate");
        Intrinsics.checkNotNullParameter(certificateAuthorities, (String)"certificateAuthorities");
        this.leafCertificate = leafCertificate;
        this.certificateAuthorities = certificateAuthorities;
    }

    @NotNull
    public final Certificate getLeafCertificate() {
        return this.leafCertificate;
    }

    @NotNull
    public final List<Certificate> getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public final void validate() throws CertificationPathException {
        if (this.certificateAuthorities.isEmpty()) {
            throw new CertificationPathException("There are no CAs", null, 2, null);
        }
        Certificate rootCA = (Certificate)CollectionsKt.last(this.certificateAuthorities);
        List<Certificate> intermediateCAs = this.certificateAuthorities.subList(0, this.certificateAuthorities.size());
        try {
            this.leafCertificate.getCertificationPath((Collection<Certificate>)intermediateCAs, CollectionsKt.listOf((Object)rootCA));
        }
        catch (CertificateException exc) {
            throw new CertificationPathException("Certification path is invalid", exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DERSequence encode$awala() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DEROctetString leafCertificateASN1 = new DEROctetString(this.leafCertificate.serialize());
        Object[] objectArray = (Object[])this.certificateAuthorities;
        ASN1Utils aSN1Utils = ASN1Utils.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DEROctetString(it.serialize()));
        }
        DERSequence casASN1 = aSN1Utils.makeSequence((List)destination$iv$iv, true);
        objectArray = new ASN1Primitive[]{leafCertificateASN1, casASN1};
        return ASN1Utils.INSTANCE.makeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @NotNull
    public final byte[] serialize() {
        DERSequence sequence = this.encode$awala();
        byte[] byArray = sequence.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/pki/CertificationPath$Companion;", "", "()V", "decode", "Ltech/relaycorp/relaynet/pki/CertificationPath;", "sequence", "Lorg/bouncycastle/asn1/ASN1Sequence;", "encoding", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "decode$awala", "deserialize", "serialization", "", "awala"})
    @SourceDebugExtension(value={"SMAP\nCertificationPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n1549#2:107\n1620#2,3:108\n*S KotlinDebug\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath$Companion\n*L\n90#1:103\n90#1:104,3\n91#1:107\n91#1:108,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CertificationPath deserialize(@NotNull byte[] serialization) throws CertificationPathException {
            ASN1Sequence aSN1Sequence;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1Sequence = ASN1Utils.INSTANCE.deserializeSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new CertificationPathException("Path is not a valid DER sequence", exc);
            }
            ASN1Sequence sequence = aSN1Sequence;
            return this.decode(sequence);
        }

        @NotNull
        public final CertificationPath decode$awala(@NotNull ASN1TaggedObject encoding) throws CertificationPathException {
            ASN1Sequence aSN1Sequence;
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            try {
                aSN1Sequence = DERSequence.getInstance((ASN1TaggedObject)encoding, (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new CertificationPathException("Serialisation is not an implicitly-tagged sequence", exc);
            }
            ASN1Sequence sequence = aSN1Sequence;
            Intrinsics.checkNotNull((Object)sequence);
            return this.decode(sequence);
        }

        private final CertificationPath decode(ASN1Sequence sequence) throws CertificationPathException {
            List list;
            ASN1Sequence exc2;
            Certificate certificate;
            if (sequence.size() < 2) {
                throw new CertificationPathException("Path sequence should have at least 2 items", null, 2, null);
            }
            ASN1Encodable aSN1Encodable = sequence.getObjectAt(0);
            Intrinsics.checkNotNull((Object)aSN1Encodable, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            ASN1OctetString leafCertificateASN1 = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)aSN1Encodable);
            try {
                byte[] byArray = leafCertificateASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOctets(...)");
                certificate = Certificate.Companion.deserialize(byArray);
            }
            catch (CertificateException exc2) {
                throw new CertificationPathException("Leaf certificate is malformed", exc2);
            }
            Certificate leafCertificate = certificate;
            try {
                ASN1Encodable aSN1Encodable2 = sequence.getObjectAt(1);
                Intrinsics.checkNotNull((Object)aSN1Encodable2, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                exc2 = DERSequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable2), (boolean)false);
            }
            catch (IllegalStateException exc3) {
                throw new CertificationPathException("Chain is malformed", exc3);
            }
            ASN1Sequence casSequence = exc2;
            try {
                byte[] it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNull((Object)casSequence);
                Iterable exc3 = CollectionsKt.toList((Iterable)((Iterable)casSequence));
                boolean $i$f$map = false;
                void var8_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ASN1Encodable aSN1Encodable3 = (ASN1Encodable)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(DEROctetString.getInstance((Object)it).getOctets());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (byte[])item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(Certificate.Companion.deserialize(it));
                }
                list = (List)destination$iv$iv;
            }
            catch (CertificateException exc4) {
                throw new CertificationPathException("Chain contains malformed certificate", exc4);
            }
            catch (IllegalArgumentException exc5) {
                throw new CertificationPathException("Chain contains non-OCTET STRING item", exc5);
            }
            List certificateAuthorities = list;
            return new CertificationPath(leafCertificate, certificateAuthorities);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

