/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1VisibleString;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Ltech/relaycorp/relaynet/messages/control/HandshakeChallenge;", "", "nonce", "", "([B)V", "getNonce", "()[B", "serialize", "Companion", "awala"})
public final class HandshakeChallenge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] nonce;

    public HandshakeChallenge(@NotNull byte[] nonce) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        this.nonce = nonce;
    }

    @NotNull
    public final byte[] getNonce() {
        return this.nonce;
    }

    @NotNull
    public final byte[] serialize() {
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object)new DEROctetString(this.nonce)), false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/messages/control/HandshakeChallenge$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/HandshakeChallenge;", "serialization", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HandshakeChallenge deserialize(@NotNull byte[] serialization) {
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new InvalidMessageException("Handshake challenge is not a DER sequence", exc);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length == 0) {
                throw new InvalidMessageException("Handshake challenge sequence should have at least 1 item", null, 2, null);
            }
            ASN1VisibleString nonceASN1 = ASN1Utils.INSTANCE.getVisibleString(sequence[0]);
            byte[] byArray = nonceASN1.getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"nonceASN1.octets");
            return new HandshakeChallenge(byArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

