/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.crypto.RSASigning;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistrationAuthorization;", "", "expiryDate", "Ljava/time/ZonedDateTime;", "gatewayData", "", "(Ljava/time/ZonedDateTime;[B)V", "getExpiryDate", "()Ljava/time/ZonedDateTime;", "getGatewayData", "()[B", "serialize", "gatewayPrivateKey", "Ljava/security/PrivateKey;", "Companion", "awala"})
public final class PrivateNodeRegistrationAuthorization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZonedDateTime expiryDate;
    @NotNull
    private final byte[] gatewayData;

    public PrivateNodeRegistrationAuthorization(@NotNull ZonedDateTime expiryDate, @NotNull byte[] gatewayData) {
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)gatewayData, (String)"gatewayData");
        this.expiryDate = expiryDate;
        this.gatewayData = gatewayData;
    }

    @NotNull
    public final ZonedDateTime getExpiryDate() {
        return this.expiryDate;
    }

    @NotNull
    public final byte[] getGatewayData() {
        return this.gatewayData;
    }

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey gatewayPrivateKey) {
        Intrinsics.checkNotNullParameter((Object)gatewayPrivateKey, (String)"gatewayPrivateKey");
        DERGeneralizedTime expiryDateASN1 = ASN1Utils.INSTANCE.derEncodeUTCDate(this.expiryDate);
        DEROctetString gatewayDataASN1 = new DEROctetString(this.gatewayData);
        byte[] signaturePlaintext = PrivateNodeRegistrationAuthorization.Companion.makeSignaturePlaintext((ASN1GeneralizedTime)expiryDateASN1, (ASN1OctetString)gatewayDataASN1);
        byte[] signature = RSASigning.INSTANCE.sign(signaturePlaintext, gatewayPrivateKey);
        Object[] objectArray = new ASN1Primitive[]{(ASN1Primitive)expiryDateASN1, (ASN1Primitive)gatewayDataASN1, (ASN1Primitive)new DEROctetString(signature)};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistrationAuthorization$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistrationAuthorization;", "serialization", "", "gatewayPublicKey", "Ljava/security/PublicKey;", "makeSignaturePlaintext", "expiryDateASN1", "Lorg/bouncycastle/asn1/ASN1GeneralizedTime;", "gatewayDataASN1", "Lorg/bouncycastle/asn1/ASN1OctetString;", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivateNodeRegistrationAuthorization deserialize(@NotNull byte[] serialization, @NotNull PublicKey gatewayPublicKey) throws InvalidMessageException {
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            Intrinsics.checkNotNullParameter((Object)gatewayPublicKey, (String)"gatewayPublicKey");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new InvalidMessageException("PNRA is not a valid DER sequence", exc);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 3) {
                throw new InvalidMessageException("PNRA plaintext should have at least 3 items (got " + sequence.length + ')', null, 2, null);
            }
            ASN1GeneralizedTime expiryDateASN1 = DERGeneralizedTime.getInstance((ASN1TaggedObject)sequence[0], (boolean)false);
            ZonedDateTime expiryDate = ZonedDateTime.ofInstant(expiryDateASN1.getDate().toInstant(), ZoneId.systemDefault());
            if (expiryDate.compareTo(ZonedDateTime.now()) < 0) {
                throw new InvalidMessageException("PNRA already expired", null, 2, null);
            }
            ASN1OctetString gatewayDataASN1 = ASN1Utils.INSTANCE.getOctetString(sequence[1]);
            byte[] signature = ASN1Utils.INSTANCE.getOctetString(sequence[2]).getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)expiryDateASN1, (String)"expiryDateASN1");
            byte[] expectedPlaintext = this.makeSignaturePlaintext(expiryDateASN1, gatewayDataASN1);
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"signature");
            if (!RSASigning.INSTANCE.verify(signature, gatewayPublicKey, expectedPlaintext)) {
                throw new InvalidMessageException("PNRA signature is invalid", null, 2, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)expiryDate, (String)"expiryDate");
            byte[] byArray = gatewayDataASN1.getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"gatewayDataASN1.octets");
            return new PrivateNodeRegistrationAuthorization(expiryDate, byArray);
        }

        private final byte[] makeSignaturePlaintext(ASN1GeneralizedTime expiryDateASN1, ASN1OctetString gatewayDataASN1) {
            Object[] objectArray = new ASN1Primitive[]{(ASN1Primitive)OIDs.INSTANCE.getPNRA(), (ASN1Primitive)expiryDateASN1, (ASN1Primitive)gatewayDataASN1};
            return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

