/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.SessionKey;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.DNS;
import tech.relaycorp.relaynet.wrappers.KeyException;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration;", "", "privateNodeCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "gatewayCertificate", "gatewayInternetAddress", "", "gatewaySessionKey", "Ltech/relaycorp/relaynet/SessionKey;", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/lang/String;Ltech/relaycorp/relaynet/SessionKey;)V", "getGatewayCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getGatewayInternetAddress", "()Ljava/lang/String;", "getGatewaySessionKey", "()Ltech/relaycorp/relaynet/SessionKey;", "getPrivateNodeCertificate", "serialize", "", "Companion", "awala"})
public final class PrivateNodeRegistration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Certificate privateNodeCertificate;
    @NotNull
    private final Certificate gatewayCertificate;
    @NotNull
    private final String gatewayInternetAddress;
    @Nullable
    private final SessionKey gatewaySessionKey;

    public PrivateNodeRegistration(@NotNull Certificate privateNodeCertificate, @NotNull Certificate gatewayCertificate, @NotNull String gatewayInternetAddress, @Nullable SessionKey gatewaySessionKey) {
        Intrinsics.checkNotNullParameter((Object)privateNodeCertificate, (String)"privateNodeCertificate");
        Intrinsics.checkNotNullParameter((Object)gatewayCertificate, (String)"gatewayCertificate");
        Intrinsics.checkNotNullParameter((Object)gatewayInternetAddress, (String)"gatewayInternetAddress");
        this.privateNodeCertificate = privateNodeCertificate;
        this.gatewayCertificate = gatewayCertificate;
        this.gatewayInternetAddress = gatewayInternetAddress;
        this.gatewaySessionKey = gatewaySessionKey;
    }

    public /* synthetic */ PrivateNodeRegistration(Certificate certificate, Certificate certificate2, String string, SessionKey sessionKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sessionKey = null;
        }
        this(certificate, certificate2, string, sessionKey);
    }

    @NotNull
    public final Certificate getPrivateNodeCertificate() {
        return this.privateNodeCertificate;
    }

    @NotNull
    public final Certificate getGatewayCertificate() {
        return this.gatewayCertificate;
    }

    @NotNull
    public final String getGatewayInternetAddress() {
        return this.gatewayInternetAddress;
    }

    @Nullable
    public final SessionKey getGatewaySessionKey() {
        return this.gatewaySessionKey;
    }

    @NotNull
    public final byte[] serialize() {
        DERSequence dERSequence;
        DEROctetString nodeCertificateASN1 = new DEROctetString(this.privateNodeCertificate.serialize());
        DEROctetString gatewayCertificateASN1 = new DEROctetString(this.gatewayCertificate.serialize());
        DERVisibleString gatewayInternetAddressASN1 = new DERVisibleString(this.gatewayInternetAddress);
        if (this.gatewaySessionKey != null) {
            Object[] objectArray = new DEROctetString[]{new DEROctetString(this.gatewaySessionKey.getKeyId()), new DEROctetString(this.gatewaySessionKey.getPublicKey().getEncoded())};
            dERSequence = ASN1Utils.INSTANCE.makeSequence(CollectionsKt.listOf((Object[])objectArray), false);
        } else {
            dERSequence = null;
        }
        DERSequence gatewaySessionKeyASN1 = dERSequence;
        Object[] objectArray = new ASN1Primitive[]{(ASN1Primitive)nodeCertificateASN1, (ASN1Primitive)gatewayCertificateASN1, (ASN1Primitive)gatewayInternetAddressASN1};
        List rootSequence = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)CollectionsKt.listOfNotNull(gatewaySessionKeyASN1));
        return ASN1Utils.INSTANCE.serializeSequence(rootSequence, false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration;", "serialization", "", "deserializeCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "asn1Object", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "getSessionKeyFromSequence", "Ltech/relaycorp/relaynet/SessionKey;", "sessionKeyASN1", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivateNodeRegistration deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            Certificate exc3;
            Certificate exc22;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc22) {
                throw new InvalidMessageException("Node registration is not a DER sequence", exc22);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 3) {
                throw new InvalidMessageException("Node registration sequence should have at least three items (got " + sequence.length + ')', null, 2, null);
            }
            try {
                exc22 = this.deserializeCertificate(sequence[0]);
            }
            catch (CertificateException exc3) {
                throw new InvalidMessageException("Node registration contains invalid node certificate", exc3);
            }
            Certificate nodeCertificate = exc22;
            try {
                exc3 = this.deserializeCertificate(sequence[1]);
            }
            catch (CertificateException exc4) {
                throw new InvalidMessageException("Node registration contains invalid gateway certificate", exc4);
            }
            Certificate gatewayCertificate = exc3;
            String gatewayInternetAddress = ASN1Utils.INSTANCE.getVisibleString(sequence[2]).getString();
            Intrinsics.checkNotNullExpressionValue((Object)gatewayInternetAddress, (String)"gatewayInternetAddress");
            if (!DNS.INSTANCE.isValidDomainName(gatewayInternetAddress)) {
                throw new InvalidMessageException("Malformed gateway Internet address (" + gatewayInternetAddress + ')', null, 2, null);
            }
            SessionKey gatewaySessionKey = 4 <= sequence.length ? this.getSessionKeyFromSequence(sequence[3]) : null;
            return new PrivateNodeRegistration(nodeCertificate, gatewayCertificate, gatewayInternetAddress, gatewaySessionKey);
        }

        private final SessionKey getSessionKeyFromSequence(ASN1TaggedObject sessionKeyASN1) {
            PublicKey publicKey;
            ASN1Sequence sessionKeySequence = DERSequence.getInstance((ASN1TaggedObject)sessionKeyASN1, (boolean)false);
            if (sessionKeySequence.size() < 2) {
                throw new InvalidMessageException("Session key SEQUENCE should have at least 2 items (got " + sessionKeySequence.size() + ')', null, 2, null);
            }
            ASN1Encodable aSN1Encodable = sessionKeySequence.getObjectAt(0);
            Intrinsics.checkNotNull((Object)aSN1Encodable, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            byte[] sessionKeyId = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)aSN1Encodable).getOctets();
            ASN1Encodable aSN1Encodable2 = sessionKeySequence.getObjectAt(1);
            Intrinsics.checkNotNull((Object)aSN1Encodable2, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            ASN1OctetString sessionPublicKeyASN1 = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)aSN1Encodable2);
            try {
                byte[] byArray = sessionPublicKeyASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sessionPublicKeyASN1.octets");
                publicKey = Keys.deserializeECPublicKey(byArray);
            }
            catch (KeyException exc) {
                throw new InvalidMessageException("Session key is not a valid ECDH public key", exc);
            }
            PublicKey sessionPublicKey = publicKey;
            Intrinsics.checkNotNullExpressionValue((Object)sessionKeyId, (String)"sessionKeyId");
            return new SessionKey(sessionKeyId, sessionPublicKey);
        }

        private final Certificate deserializeCertificate(ASN1TaggedObject asn1Object) throws CertificateException {
            ASN1OctetString certificateASN1 = ASN1Utils.INSTANCE.getOctetString(asn1Object);
            byte[] byArray = certificateASN1.getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"certificateASN1.octets");
            return Certificate.Companion.deserialize(byArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

