/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.pki;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.pki.CertificationPathException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Ltech/relaycorp/relaynet/pki/CertificationPath;", "", "leafCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "certificateAuthorities", "", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/util/List;)V", "getCertificateAuthorities", "()Ljava/util/List;", "getLeafCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "serialize", "", "validate", "", "Companion", "awala"})
@SourceDebugExtension(value={"SMAP\nCertificationPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n*S KotlinDebug\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath\n*L\n32#1:77\n32#1:78,3\n*E\n"})
public final class CertificationPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Certificate leafCertificate;
    @NotNull
    private final List<Certificate> certificateAuthorities;

    public CertificationPath(@NotNull Certificate leafCertificate, @NotNull List<Certificate> certificateAuthorities) {
        Intrinsics.checkNotNullParameter((Object)leafCertificate, (String)"leafCertificate");
        Intrinsics.checkNotNullParameter(certificateAuthorities, (String)"certificateAuthorities");
        this.leafCertificate = leafCertificate;
        this.certificateAuthorities = certificateAuthorities;
    }

    @NotNull
    public final Certificate getLeafCertificate() {
        return this.leafCertificate;
    }

    @NotNull
    public final List<Certificate> getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public final void validate() throws CertificationPathException {
        if (this.certificateAuthorities.isEmpty()) {
            throw new CertificationPathException("There are no CAs", null, 2, null);
        }
        Certificate rootCA = (Certificate)CollectionsKt.last(this.certificateAuthorities);
        List<Certificate> intermediateCAs = this.certificateAuthorities.subList(0, this.certificateAuthorities.size());
        try {
            this.leafCertificate.getCertificationPath((Collection<Certificate>)intermediateCAs, CollectionsKt.listOf((Object)rootCA));
        }
        catch (CertificateException exc) {
            throw new CertificationPathException("Certification path is invalid", exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serialize() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DEROctetString leafCertificateASN1 = new DEROctetString(this.leafCertificate.serialize());
        Object[] objectArray = (Object[])this.certificateAuthorities;
        ASN1Utils aSN1Utils = ASN1Utils.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DEROctetString(it.serialize()));
        }
        DERSequence casASN1 = aSN1Utils.makeSequence((List)destination$iv$iv, true);
        objectArray = new ASN1Primitive[]{leafCertificateASN1, casASN1};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/pki/CertificationPath$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/pki/CertificationPath;", "serialization", "", "awala"})
    @SourceDebugExtension(value={"SMAP\nCertificationPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath$Companion\n*L\n64#1:77\n64#1:78,3\n65#1:81\n65#1:82,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CertificationPath deserialize(@NotNull byte[] serialization) throws CertificationPathException {
            List list;
            ASN1Sequence exc3;
            Certificate certificate;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                objectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc2) {
                throw new CertificationPathException("Path is not a valid DER sequence", exc2);
            }
            Object[] sequence = objectArray;
            if (sequence.length < 2) {
                throw new CertificationPathException("Path sequence should have at least 2 items", null, 2, null);
            }
            ASN1OctetString leafCertificateASN1 = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)ArraysKt.first((Object[])sequence));
            try {
                byte[] byArray = leafCertificateASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOctets(...)");
                certificate = Certificate.Companion.deserialize(byArray);
            }
            catch (CertificateException exc3) {
                throw new CertificationPathException("Leaf certificate is malformed", exc3);
            }
            Certificate leafCertificate = certificate;
            try {
                exc3 = DERSequence.getInstance((ASN1TaggedObject)sequence[1], (boolean)false);
            }
            catch (IllegalStateException exc4) {
                throw new CertificationPathException("Chain is malformed", exc4);
            }
            ASN1Sequence casSequence = exc3;
            try {
                byte[] it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNull((Object)casSequence);
                Iterable exc4 = CollectionsKt.toList((Iterable)((Iterable)casSequence));
                boolean $i$f$map = false;
                void var9_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(DEROctetString.getInstance((Object)it).getOctets());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (byte[])item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(Certificate.Companion.deserialize(it));
                }
                list = (List)destination$iv$iv;
            }
            catch (CertificateException exc5) {
                throw new CertificationPathException("Chain contains malformed certificate", exc5);
            }
            catch (IllegalArgumentException exc6) {
                throw new CertificationPathException("Chain contains non-OCTET STRING item", exc6);
            }
            List certificateAuthorities = list;
            return new CertificationPath(leafCertificate, certificateAuthorities);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

