/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.asn1;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1VisibleString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\f\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rJ\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!2\b\b\u0002\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!2\b\b\u0002\u0010\"\u001a\u00020#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Ltech/relaycorp/relaynet/wrappers/asn1/ASN1Utils;", "", "()V", "BER_DATETIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getBER_DATETIME_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "derEncodeUTCDate", "Lorg/bouncycastle/asn1/DERGeneralizedTime;", "date", "Ljava/time/ZonedDateTime;", "deserializeHeterogeneousSequence", "", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "serialization", "", "([B)[Lorg/bouncycastle/asn1/ASN1TaggedObject;", "deserializeHomogeneousSequence", "T", "Lorg/bouncycastle/asn1/ASN1Encodable;", "([B)[Lorg/bouncycastle/asn1/ASN1Encodable;", "getOID", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "oidSerialized", "getOctetString", "Lorg/bouncycastle/asn1/ASN1OctetString;", "octetString", "getVisibleString", "Lorg/bouncycastle/asn1/ASN1VisibleString;", "visibleString", "makeSequence", "Lorg/bouncycastle/asn1/DERSequence;", "items", "", "explicitTagging", "", "serializeSequence", "awala"})
@SourceDebugExtension(value={"SMAP\nASN1Utils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASN1Utils.kt\ntech/relaycorp/relaynet/wrappers/asn1/ASN1Utils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,91:1\n41#1,15:105\n56#1,8:123\n64#1:132\n1559#2:92\n1590#2,4:93\n1855#2,2:97\n1549#2:99\n1620#2,3:100\n1549#2:120\n1620#2,2:121\n1622#2:131\n37#3,2:103\n37#3,2:133\n*S KotlinDebug\n*F\n+ 1 ASN1Utils.kt\ntech/relaycorp/relaynet/wrappers/asn1/ASN1Utils\n*L\n69#1:105,15\n69#1:123,8\n69#1:132\n26#1:92\n26#1:93,4\n29#1:97,2\n55#1:99\n55#1:100,3\n69#1:120\n69#1:121,2\n69#1:131\n64#1:103,2\n69#1:133,2\n*E\n"})
public final class ASN1Utils {
    @NotNull
    public static final ASN1Utils INSTANCE = new ASN1Utils();
    @NotNull
    private static final DateTimeFormatter BER_DATETIME_FORMATTER;

    private ASN1Utils() {
    }

    @NotNull
    public final DateTimeFormatter getBER_DATETIME_FORMATTER() {
        return BER_DATETIME_FORMATTER;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DERSequence makeSequence(@NotNull List<? extends ASN1Encodable> items, boolean explicitTagging) {
        List list;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ASN1EncodableVector messagesVector = new ASN1EncodableVector(items.size());
        if (explicitTagging) {
            list = items;
        } else {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = items;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DERTaggedObject(false, (int)index, (ASN1Encodable)item));
            }
            list = (List)destination$iv$iv;
        }
        List finalItems = list;
        Iterable $this$forEach$iv = finalItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASN1Encodable it = (ASN1Encodable)element$iv;
            boolean bl = false;
            messagesVector.add(it);
        }
        return new DERSequence(messagesVector);
    }

    public static /* synthetic */ DERSequence makeSequence$default(ASN1Utils aSN1Utils, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return aSN1Utils.makeSequence(list, bl);
    }

    @NotNull
    public final byte[] serializeSequence(@NotNull List<? extends ASN1Encodable> items, boolean explicitTagging) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        byte[] byArray = this.makeSequence(items, explicitTagging).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"makeSequence(items, explicitTagging).encoded");
        return byArray;
    }

    public static /* synthetic */ byte[] serializeSequence$default(ASN1Utils aSN1Utils, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return aSN1Utils.serializeSequence(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends ASN1Encodable> T[] deserializeHomogeneousSequence(byte[] serialization) throws ASN1Exception {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        ASN1Sequence _2;
        ASN1Primitive aSN1Primitive;
        Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
        boolean $i$f$deserializeHomogeneousSequence = false;
        if (serialization.length == 0) {
            throw new ASN1Exception("Value is empty", null, 2, null);
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException _2) {
            throw new ASN1Exception("Value is not DER-encoded", null, 2, null);
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            _2 = ASN1Sequence.getInstance((Object)asn1Value);
        }
        catch (IllegalArgumentException _3) {
            throw new ASN1Exception("Value is not an ASN.1 sequence", null, 2, null);
        }
        ASN1Sequence sequence = _2;
        Intrinsics.checkNotNullExpressionValue((Object)sequence, (String)"sequence");
        Iterable $this$map$iv = (Iterable)sequence;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(it instanceof ASN1Encodable)) {
                throw new ASN1Exception("Sequence contains an item of an unexpected type (" + it.getClass().getSimpleName() + ')', null, 2, null);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            collection.add((ASN1Encodable)it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = (Collection)$this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        return (ASN1Encodable[])thisCollection$iv.toArray(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ASN1TaggedObject[] deserializeHeterogeneousSequence(@NotNull byte[] serialization) throws ASN1Exception {
        void $this$toTypedArray$iv$iv;
        void $this$mapTo$iv$iv$iv;
        ASN1Sequence _$iv2;
        ASN1Primitive aSN1Primitive;
        Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
        ASN1Utils this_$iv = this;
        boolean $i$f$deserializeHomogeneousSequence = false;
        if (serialization.length == 0) {
            throw new ASN1Exception("Value is empty", null, 2, null);
        }
        ASN1InputStream asn1InputStream$iv = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream$iv.readObject();
        }
        catch (IOException _$iv2) {
            throw new ASN1Exception("Value is not DER-encoded", null, 2, null);
        }
        ASN1Primitive asn1Value$iv = aSN1Primitive;
        try {
            _$iv2 = ASN1Sequence.getInstance((Object)asn1Value$iv);
        }
        catch (IllegalArgumentException _$iv3) {
            throw new ASN1Exception("Value is not an ASN.1 sequence", null, 2, null);
        }
        ASN1Sequence sequence$iv = _$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)sequence$iv, (String)"sequence");
        Iterable $this$map$iv$iv = (Iterable)sequence$iv;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            if (!(it$iv instanceof ASN1TaggedObject)) {
                throw new ASN1Exception("Sequence contains an item of an unexpected type (" + it$iv.getClass().getSimpleName() + ')', null, 2, null);
            }
            collection.add((ASN1Encodable)((ASN1TaggedObject)it$iv));
        }
        $this$map$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        return (ASN1TaggedObject[])((ASN1Encodable[])thisCollection$iv$iv.toArray(new ASN1TaggedObject[0]));
    }

    @NotNull
    public final DERGeneralizedTime derEncodeUTCDate(@NotNull ZonedDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        ZonedDateTime dateUTC = date.withZoneSameInstant(ZoneOffset.UTC);
        return new DERGeneralizedTime(dateUTC.format(BER_DATETIME_FORMATTER));
    }

    @NotNull
    public final ASN1ObjectIdentifier getOID(@NotNull ASN1TaggedObject oidSerialized) throws ASN1Exception {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Intrinsics.checkNotNullParameter((Object)oidSerialized, (String)"oidSerialized");
        try {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)oidSerialized, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier2, (String)"{\n            ASN1Object\u2026ialized, false)\n        }");
            aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
        }
        catch (IllegalArgumentException exc) {
            throw new ASN1Exception("Value is not an OID", exc);
        }
        return aSN1ObjectIdentifier;
    }

    @NotNull
    public final ASN1VisibleString getVisibleString(@NotNull ASN1TaggedObject visibleString) {
        Intrinsics.checkNotNullParameter((Object)visibleString, (String)"visibleString");
        ASN1VisibleString aSN1VisibleString = ASN1VisibleString.getInstance((ASN1TaggedObject)visibleString, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)aSN1VisibleString, (String)"getInstance(visibleString, false)");
        return aSN1VisibleString;
    }

    @NotNull
    public final ASN1OctetString getOctetString(@NotNull ASN1TaggedObject octetString) {
        Intrinsics.checkNotNullParameter((Object)octetString, (String)"octetString");
        ASN1OctetString aSN1OctetString = DEROctetString.getInstance((ASN1TaggedObject)octetString, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)aSN1OctetString, (String)"getInstance(octetString, false)");
        return aSN1OctetString;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyyMMddHHmmss\")");
        BER_DATETIME_FORMATTER = dateTimeFormatter;
    }
}

