/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import java.security.PrivateKey;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.messages.Recipient;
import tech.relaycorp.relaynet.messages.payloads.Payload;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFSerializer;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 3*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00013BU\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(\u00a2\u0006\u0002\u0010)J\u001a\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.J\u0018\u0010/\u001a\u0002002\u0010\b\u0002\u0010'\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010(J\u0016\u00101\u001a\u0002002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(H\u0002J\b\u00102\u001a\u000200H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00064"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "P", "Ltech/relaycorp/relaynet/messages/payloads/Payload;", "", "serializer", "Ltech/relaycorp/relaynet/ramf/RAMFSerializer;", "recipient", "Ltech/relaycorp/relaynet/messages/Recipient;", "payload", "", "senderCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "id", "", "creationDate", "Ljava/time/ZonedDateTime;", "ttl", "", "senderCertificateChain", "", "(Ltech/relaycorp/relaynet/ramf/RAMFSerializer;Ltech/relaycorp/relaynet/messages/Recipient;[BLtech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/lang/String;Ljava/time/ZonedDateTime;Ljava/lang/Integer;Ljava/util/Set;)V", "getCreationDate", "()Ljava/time/ZonedDateTime;", "expiryDate", "getExpiryDate", "getId", "()Ljava/lang/String;", "getPayload", "()[B", "getRecipient", "()Ltech/relaycorp/relaynet/messages/Recipient;", "getSenderCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getSenderCertificateChain", "()Ljava/util/Set;", "getTtl", "()I", "getSenderCertificationPath", "", "trustedCAs", "", "(Ljava/util/Collection;)[Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "serialize", "senderPrivateKey", "Ljava/security/PrivateKey;", "hashingAlgorithm", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "validate", "", "validateAuthorization", "validateTiming", "Companion", "awala"})
public abstract class RAMFMessage<P extends Payload> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RAMFSerializer serializer;
    @NotNull
    private final Recipient recipient;
    @NotNull
    private final byte[] payload;
    @NotNull
    private final Certificate senderCertificate;
    @NotNull
    private final String id;
    @NotNull
    private final ZonedDateTime creationDate;
    private final int ttl;
    @NotNull
    private final Set<Certificate> senderCertificateChain;
    public static final int MAX_PAYLOAD_LENGTH = 0x800000;

    public RAMFMessage(@NotNull RAMFSerializer serializer, @NotNull Recipient recipient, @NotNull byte[] payload, @NotNull Certificate senderCertificate, @Nullable String id, @Nullable ZonedDateTime creationDate, @Nullable Integer ttl, @Nullable Set<Certificate> senderCertificateChain) {
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)senderCertificate, (String)"senderCertificate");
        this.serializer = serializer;
        this.recipient = recipient;
        this.payload = payload;
        this.senderCertificate = senderCertificate;
        String string = id;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        }
        this.id = string;
        ZonedDateTime zonedDateTime = creationDate;
        if (zonedDateTime == null) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now(ZoneId.of("UTC"));
            zonedDateTime = zonedDateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now(ZoneId.of(\"UTC\"))");
        }
        this.creationDate = zonedDateTime;
        Integer n = ttl;
        this.ttl = n != null ? n : 300;
        Set set = senderCertificateChain;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        this.senderCertificateChain = set;
        if (64 < this.id.length()) {
            throw new RAMFException("Message id cannot span more than 64 octets (got " + this.id.length() + ')', null, 2, null);
        }
        if (this.ttl < 0) {
            throw new RAMFException("TTL cannot be negative (got " + this.ttl + ')', null, 2, null);
        }
        if (15552000 < this.ttl) {
            throw new RAMFException("TTL cannot be greater than 15552000 (got " + this.ttl + ')', null, 2, null);
        }
        if (0x800000 < this.payload.length) {
            throw new RAMFException("Payload cannot span more than 8388608 octets (got " + this.payload.length + ')', null, 2, null);
        }
    }

    @NotNull
    public final Recipient getRecipient() {
        return this.recipient;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    @NotNull
    public final Certificate getSenderCertificate() {
        return this.senderCertificate;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final Set<Certificate> getSenderCertificateChain() {
        return this.senderCertificateChain;
    }

    @NotNull
    public final ZonedDateTime getExpiryDate() {
        ZonedDateTime zonedDateTime = this.creationDate.plusSeconds(this.ttl);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"creationDate.plusSeconds(ttl.toLong())");
        return zonedDateTime;
    }

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey senderPrivateKey, @Nullable HashingAlgorithm hashingAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)senderPrivateKey, (String)"senderPrivateKey");
        return this.serializer.serialize(this, senderPrivateKey, hashingAlgorithm);
    }

    public static /* synthetic */ byte[] serialize$default(RAMFMessage rAMFMessage, PrivateKey privateKey, HashingAlgorithm hashingAlgorithm, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: serialize");
        }
        if ((n & 2) != 0) {
            hashingAlgorithm = null;
        }
        return rAMFMessage.serialize(privateKey, hashingAlgorithm);
    }

    @NotNull
    public final Certificate[] getSenderCertificationPath(@NotNull Collection<Certificate> trustedCAs) throws InvalidMessageException {
        Intrinsics.checkNotNullParameter(trustedCAs, (String)"trustedCAs");
        return this.senderCertificate.getCertificationPath(CollectionsKt.toSet((Iterable)this.senderCertificateChain), trustedCAs);
    }

    public final void validate(@Nullable Collection<Certificate> trustedCAs) throws RAMFException, InvalidMessageException {
        this.validateTiming();
        try {
            this.senderCertificate.validate();
        }
        catch (CertificateException exc) {
            throw new RAMFException("Invalid sender certificate", exc);
        }
        if (trustedCAs != null) {
            this.validateAuthorization(trustedCAs);
        }
    }

    public static /* synthetic */ void validate$default(RAMFMessage rAMFMessage, Collection collection, int n, Object object) throws RAMFException, InvalidMessageException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validate");
        }
        if ((n & 1) != 0) {
            collection = null;
        }
        rAMFMessage.validate(collection);
    }

    private final void validateTiming() {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        if (now.compareTo(this.creationDate) < 0) {
            throw new RAMFException("Creation date is in the future", null, 2, null);
        }
        if (this.getExpiryDate().compareTo(now) < 0) {
            throw new RAMFException("Message already expired", null, 2, null);
        }
    }

    private final void validateAuthorization(Collection<Certificate> trustedCAs) throws InvalidMessageException {
        Certificate[] certificateArray;
        try {
            certificateArray = this.getSenderCertificationPath(trustedCAs);
        }
        catch (CertificateException exc) {
            throw new InvalidMessageException("Sender is not trusted", exc);
        }
        Certificate[] certificationPath = certificateArray;
        Certificate recipientCertificate = certificationPath[1];
        String recipientId = recipientCertificate.getSubjectId();
        if (!Intrinsics.areEqual((Object)recipientId, (Object)this.recipient.getId())) {
            throw new InvalidMessageException("Sender is authorized by the wrong recipient", null, 2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage$Companion;", "", "()V", "MAX_PAYLOAD_LENGTH", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

