/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ByteSpreadBuilder;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1VisibleString;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/messages/ParcelCollectionAck;", "", "senderEndpointPrivateAddress", "", "recipientEndpointAddress", "parcelId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getParcelId", "()Ljava/lang/String;", "getRecipientEndpointAddress", "getSenderEndpointPrivateAddress", "serialize", "", "Companion", "awala"})
public final class ParcelCollectionAck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String senderEndpointPrivateAddress;
    @NotNull
    private final String recipientEndpointAddress;
    @NotNull
    private final String parcelId;
    private static final byte concreteMessageType = 81;
    private static final byte concreteMessageVersion = 0;
    @NotNull
    private static final byte[] FORMAT_SIGNATURE;

    public ParcelCollectionAck(@NotNull String senderEndpointPrivateAddress, @NotNull String recipientEndpointAddress, @NotNull String parcelId) {
        Intrinsics.checkNotNullParameter((Object)senderEndpointPrivateAddress, (String)"senderEndpointPrivateAddress");
        Intrinsics.checkNotNullParameter((Object)recipientEndpointAddress, (String)"recipientEndpointAddress");
        Intrinsics.checkNotNullParameter((Object)parcelId, (String)"parcelId");
        this.senderEndpointPrivateAddress = senderEndpointPrivateAddress;
        this.recipientEndpointAddress = recipientEndpointAddress;
        this.parcelId = parcelId;
    }

    @NotNull
    public final String getSenderEndpointPrivateAddress() {
        return this.senderEndpointPrivateAddress;
    }

    @NotNull
    public final String getRecipientEndpointAddress() {
        return this.recipientEndpointAddress;
    }

    @NotNull
    public final String getParcelId() {
        return this.parcelId;
    }

    @NotNull
    public final byte[] serialize() {
        Object[] objectArray = new DERVisibleString[]{new DERVisibleString(this.senderEndpointPrivateAddress), new DERVisibleString(this.recipientEndpointAddress), new DERVisibleString(this.parcelId)};
        byte[] sequence = ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
        return ArraysKt.plus((byte[])FORMAT_SIGNATURE, (byte[])sequence);
    }

    static {
        ByteSpreadBuilder byteSpreadBuilder = new ByteSpreadBuilder(3);
        String string = "Relaynet";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byteSpreadBuilder.addSpread((Object)byArray);
        byteSpreadBuilder.add((byte)81);
        byteSpreadBuilder.add((byte)0);
        FORMAT_SIGNATURE = byteSpreadBuilder.toArray();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/messages/ParcelCollectionAck$Companion;", "", "()V", "FORMAT_SIGNATURE", "", "getFORMAT_SIGNATURE$awala", "()[B", "concreteMessageType", "", "concreteMessageVersion", "deserialize", "Ltech/relaycorp/relaynet/messages/ParcelCollectionAck;", "serialization", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getFORMAT_SIGNATURE$awala() {
            return FORMAT_SIGNATURE;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ParcelCollectionAck deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            void $this$mapTo$iv$iv;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            if (serialization.length < 10) {
                throw new InvalidMessageException("Message is too short to contain format signature", null, 2, null);
            }
            List formatSignature = ArraysKt.slice((byte[])serialization, (IntRange)new IntRange(0, 9));
            if (!Intrinsics.areEqual((Object)formatSignature, (Object)ArraysKt.asList((byte[])this.getFORMAT_SIGNATURE$awala()))) {
                throw new InvalidMessageException("Format signature is not that of a PCA", null, 2, null);
            }
            byte[] derSequence = ArraysKt.sliceArray((byte[])serialization, (IntRange)RangesKt.until((int)10, (int)serialization.length));
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(derSequence);
            }
            catch (ASN1Exception exc) {
                throw new InvalidMessageException("PCA is not a valid DER sequence", exc);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 3) {
                throw new InvalidMessageException("PCA should have 3 items (got " + sequence.length + ')', null, 2, null);
            }
            ASN1TaggedObject[] $this$map$iv = sequence;
            boolean $i$f$map = false;
            ASN1TaggedObject[] aSN1TaggedObjectArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var14_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ASN1Utils.INSTANCE.getVisibleString((ASN1TaggedObject)it));
            }
            List fields = (List)destination$iv$iv;
            String string = ((ASN1VisibleString)fields.get(0)).getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fields[0].string");
            String string2 = ((ASN1VisibleString)fields.get(1)).getString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fields[1].string");
            String string3 = ((ASN1VisibleString)fields.get(2)).getString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fields[2].string");
            return new ParcelCollectionAck(string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

