/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ByteSpreadBuilder;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/messages/CertificateRotation;", "", "subjectCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "chain", "", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/util/List;)V", "getChain", "()Ljava/util/List;", "getSubjectCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "serialize", "", "Companion", "awala"})
public final class CertificateRotation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Certificate subjectCertificate;
    @NotNull
    private final List<Certificate> chain;
    private static final byte concreteMessageType = 16;
    private static final byte concreteMessageVersion = 0;
    @NotNull
    private static final byte[] FORMAT_SIGNATURE;

    public CertificateRotation(@NotNull Certificate subjectCertificate, @NotNull List<Certificate> chain) {
        Intrinsics.checkNotNullParameter((Object)subjectCertificate, (String)"subjectCertificate");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        this.subjectCertificate = subjectCertificate;
        this.chain = chain;
    }

    @NotNull
    public final Certificate getSubjectCertificate() {
        return this.subjectCertificate;
    }

    @NotNull
    public final List<Certificate> getChain() {
        return this.chain;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serialize() {
        Collection<DEROctetString> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.chain;
        ASN1Utils aSN1Utils = ASN1Utils.INSTANCE;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DEROctetString dEROctetString = new DEROctetString(it.serialize());
            collection.add(dEROctetString);
        }
        collection = (List)destination$iv$iv;
        DERSequence chainSequence = aSN1Utils.makeSequence((List<? extends ASN1Encodable>)collection, false);
        Object[] objectArray = new ASN1Primitive[]{(ASN1Primitive)new DEROctetString(this.subjectCertificate.serialize()), (ASN1Primitive)chainSequence};
        byte[] sequence = ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
        return ArraysKt.plus((byte[])FORMAT_SIGNATURE, (byte[])sequence);
    }

    static {
        ByteSpreadBuilder byteSpreadBuilder = new ByteSpreadBuilder(3);
        String string = "Relaynet";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byteSpreadBuilder.addSpread((Object)byArray);
        byteSpreadBuilder.add((byte)16);
        byteSpreadBuilder.add((byte)0);
        FORMAT_SIGNATURE = byteSpreadBuilder.toArray();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/messages/CertificateRotation$Companion;", "", "()V", "FORMAT_SIGNATURE", "", "getFORMAT_SIGNATURE$awala", "()[B", "concreteMessageType", "", "concreteMessageVersion", "deserialize", "Ltech/relaycorp/relaynet/messages/CertificateRotation;", "serialization", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getFORMAT_SIGNATURE$awala() {
            return FORMAT_SIGNATURE;
        }

        @NotNull
        public final CertificateRotation deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            List list;
            ASN1Sequence exc3;
            Object certificateASN1;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            if (serialization.length < this.getFORMAT_SIGNATURE$awala().length) {
                throw new InvalidMessageException("Message is too short to contain format signature", null, 2, null);
            }
            List formatSignature = ArraysKt.slice((byte[])serialization, (IntRange)ArraysKt.getIndices((byte[])this.getFORMAT_SIGNATURE$awala()));
            if (!Intrinsics.areEqual((Object)formatSignature, (Object)ArraysKt.asList((byte[])this.getFORMAT_SIGNATURE$awala()))) {
                throw new InvalidMessageException("Format signature is not that of a CertificateRotation", null, 2, null);
            }
            byte[] sequenceSerialized = ArraysKt.sliceArray((byte[])serialization, (IntRange)RangesKt.until((int)this.getFORMAT_SIGNATURE$awala().length, (int)serialization.length));
            try {
                objectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(sequenceSerialized);
            }
            catch (ASN1Exception exc2) {
                throw new InvalidMessageException("Serialization does not contain valid DER sequence", exc2);
            }
            Object[] sequence = objectArray;
            if (sequence.length < 2) {
                throw new InvalidMessageException("Sequence should contain at least 2 items", null, 2, null);
            }
            try {
                certificateASN1 = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)ArraysKt.first((Object[])sequence));
                byte[] byArray = certificateASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"certificateASN1.octets");
                certificateASN1 = Certificate.Companion.deserialize(byArray);
            }
            catch (CertificateException exc3) {
                throw new InvalidMessageException("Subject certificate is malformed", exc3);
            }
            Object subjectCertificate = certificateASN1;
            try {
                exc3 = DERSequence.getInstance((ASN1TaggedObject)sequence[1], (boolean)false);
            }
            catch (IllegalArgumentException exc4) {
                throw new InvalidMessageException("Chain is malformed", exc4);
            }
            ASN1Sequence chainSequence = exc3;
            try {
                Object object;
                ASN1OctetString it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Intrinsics.checkNotNullExpressionValue((Object)chainSequence, (String)"chainSequence");
                Iterable $this$map$iv = (Iterable)chainSequence;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    if (it == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                    }
                    object = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)it);
                    collection.add(object);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ASN1OctetString)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    byte[] byArray = it.getOctets();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.octets");
                    object = Certificate.Companion.deserialize(byArray);
                    collection.add(object);
                }
                list = (List)destination$iv$iv;
            }
            catch (CertificateException exc5) {
                throw new InvalidMessageException("Chain contains malformed certificate", exc5);
            }
            List chain = list;
            return new CertificateRotation((Certificate)subjectCertificate, chain);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

