/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.crypto.RSASigning;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.KeyException;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistrationRequest;", "", "privateNodePublicKey", "Ljava/security/PublicKey;", "pnraSerialized", "", "(Ljava/security/PublicKey;[B)V", "getPnraSerialized", "()[B", "getPrivateNodePublicKey", "()Ljava/security/PublicKey;", "serialize", "privateNodePrivateKey", "Ljava/security/PrivateKey;", "Companion", "awala"})
public final class PrivateNodeRegistrationRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicKey privateNodePublicKey;
    @NotNull
    private final byte[] pnraSerialized;

    public PrivateNodeRegistrationRequest(@NotNull PublicKey privateNodePublicKey, @NotNull byte[] pnraSerialized) {
        Intrinsics.checkNotNullParameter((Object)privateNodePublicKey, (String)"privateNodePublicKey");
        Intrinsics.checkNotNullParameter((Object)pnraSerialized, (String)"pnraSerialized");
        this.privateNodePublicKey = privateNodePublicKey;
        this.pnraSerialized = pnraSerialized;
    }

    @NotNull
    public final PublicKey getPrivateNodePublicKey() {
        return this.privateNodePublicKey;
    }

    @NotNull
    public final byte[] getPnraSerialized() {
        return this.pnraSerialized;
    }

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey privateNodePrivateKey) {
        Intrinsics.checkNotNullParameter((Object)privateNodePrivateKey, (String)"privateNodePrivateKey");
        DEROctetString pnraSerializedASN1 = new DEROctetString(this.pnraSerialized);
        byte[] pnraCountersignaturePlaintext = PrivateNodeRegistrationRequest.Companion.makePNRACountersignaturePlaintext((ASN1OctetString)pnraSerializedASN1);
        byte[] pnraCountersignature = RSASigning.INSTANCE.sign(pnraCountersignaturePlaintext, privateNodePrivateKey);
        Object[] objectArray = new DEROctetString[]{new DEROctetString(this.privateNodePublicKey.getEncoded()), pnraSerializedASN1, new DEROctetString(pnraCountersignature)};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistrationRequest$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistrationRequest;", "serialization", "", "makePNRACountersignaturePlaintext", "pnraSerializedASN1", "Lorg/bouncycastle/asn1/ASN1OctetString;", "verifyPNRACountersignature", "", "pnraSerialized", "pnraCountersignature", "privateNodePublicKey", "Ljava/security/PublicKey;", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivateNodeRegistrationRequest deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            Object object;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new InvalidMessageException("PNRR is not a DER sequence", exc);
            }
            ASN1TaggedObject[] pnrrSequence = aSN1TaggedObjectArray;
            if (pnrrSequence.length < 3) {
                throw new InvalidMessageException("PNRR sequence should have at least 3 items (got " + pnrrSequence.length + ')', null, 2, null);
            }
            ASN1OctetString privateNodePublicKeyASN1 = ASN1Utils.INSTANCE.getOctetString(pnrrSequence[0]);
            try {
                object = privateNodePublicKeyASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"privateNodePublicKeyASN1.octets");
                object = Keys.deserializeRSAPublicKey(object);
            }
            catch (KeyException exc) {
                throw new InvalidMessageException("Private node public key is invalid", exc);
            }
            Object privateNodePublicKey = object;
            ASN1OctetString pnraSerialized = ASN1Utils.INSTANCE.getOctetString(pnrrSequence[1]);
            byte[] pnraCounterSignature = ASN1Utils.INSTANCE.getOctetString(pnrrSequence[2]).getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)pnraCounterSignature, (String)"pnraCounterSignature");
            this.verifyPNRACountersignature(pnraSerialized, pnraCounterSignature, (PublicKey)privateNodePublicKey);
            byte[] byArray = pnraSerialized.getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"pnraSerialized.octets");
            return new PrivateNodeRegistrationRequest((PublicKey)privateNodePublicKey, byArray);
        }

        private final void verifyPNRACountersignature(ASN1OctetString pnraSerialized, byte[] pnraCountersignature, PublicKey privateNodePublicKey) throws InvalidMessageException {
            byte[] expectedPlaintext = this.makePNRACountersignaturePlaintext(pnraSerialized);
            if (!RSASigning.INSTANCE.verify(pnraCountersignature, privateNodePublicKey, expectedPlaintext)) {
                throw new InvalidMessageException("PNRA countersignature is invalid", null, 2, null);
            }
        }

        private final byte[] makePNRACountersignaturePlaintext(ASN1OctetString pnraSerializedASN1) {
            Object[] objectArray = new ASN1Primitive[]{(ASN1Primitive)OIDs.INSTANCE.getPNRA_COUNTERSIGNATURE(), (ASN1Primitive)pnraSerializedASN1};
            return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

