/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.KeyAgreeRecipientId;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.SymmetricEncryption;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.PRNGKt;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataKt;
import tech.relaycorp.relaynet.wrappers.cms.OriginatorSessionKey;
import tech.relaycorp.relaynet.wrappers.cms.RecipientIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.RecipientKeyIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.RecipientSerialNumber;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData;", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "getOriginatorKey", "Ltech/relaycorp/relaynet/wrappers/cms/OriginatorSessionKey;", "getRecipientKeyId", "Ltech/relaycorp/relaynet/wrappers/cms/RecipientIdentifier;", "validate", "", "Companion", "awala"})
public final class SessionEnvelopedData
extends EnvelopedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<HashingAlgorithm, ASN1ObjectIdentifier> ecdhAlgorithmByHashingAlgorithm;

    public SessionEnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkNotNullParameter((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        super(bcEnvelopedData);
    }

    @Override
    @NotNull
    public RecipientIdentifier getRecipientKeyId() {
        RecipientIdentifier recipientIdentifier;
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkNotNullExpressionValue((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Object object = ((RecipientInformation)CollectionsKt.first((Iterable)((Iterable)recipientInformationStore))).getRID();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.cms.KeyAgreeRecipientId");
        }
        KeyAgreeRecipientId rid = (KeyAgreeRecipientId)object;
        if (rid.getSerialNumber() == null) {
            object = rid.getSubjectKeyIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rid.subjectKeyIdentifier");
            recipientIdentifier = new RecipientKeyIdentifier((byte[])object);
        } else {
            object = rid.getSerialNumber();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rid.serialNumber");
            recipientIdentifier = new RecipientSerialNumber((BigInteger)object);
        }
        return recipientIdentifier;
    }

    @NotNull
    public final OriginatorSessionKey getOriginatorKey() {
        Attribute originatorKeyIdAttribute = this.getBcEnvelopedData().getUnprotectedAttributes().get(OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER());
        ASN1Encodable aSN1Encodable = originatorKeyIdAttribute.getAttrValues().getObjectAt(0);
        if (aSN1Encodable == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1Integer");
        }
        ASN1Integer keyIdEncoded = (ASN1Integer)aSN1Encodable;
        Object object = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bcEnvelopedData.recipientInfos");
        Object object2 = CollectionsKt.first((Iterable)((Iterable)object));
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.cms.KeyAgreeRecipientInformation");
        }
        KeyAgreeRecipientInformation recipientInfo = (KeyAgreeRecipientInformation)object2;
        OriginatorIdentifierOrKey originator = recipientInfo.getOriginator();
        object = keyIdEncoded.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"keyIdEncoded.value");
        Object object3 = object;
        object = originator.getOriginatorKey().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"originator.originatorKey.encoded");
        return new OriginatorSessionKey((BigInteger)object3, Keys.deserializeECPublicKey((byte[])object));
    }

    @Override
    protected void validate() {
        AttributeTable attributeTable = this.getBcEnvelopedData().getUnprotectedAttributes();
        if (attributeTable == null) {
            throw new EnvelopedDataException("unprotectedAttrs is missing", null, 2, null);
        }
        AttributeTable unprotectedAttrs = attributeTable;
        if (unprotectedAttrs.size() == 0) {
            throw new EnvelopedDataException("unprotectedAttrs is empty", null, 2, null);
        }
        Attribute attribute = unprotectedAttrs.get(OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER());
        if (attribute == null) {
            throw new EnvelopedDataException("Originator key id is missing from unprotectedAttrs", null, 2, null);
        }
        Attribute originatorKeyIdAttributeContainer = attribute;
        if (originatorKeyIdAttributeContainer.getAttrValues().size() == 0) {
            throw new EnvelopedDataException("Originator key id is empty", null, 2, null);
        }
        if (1 < originatorKeyIdAttributeContainer.getAttrValues().size()) {
            throw new EnvelopedDataException("Originator key id has multiple values", null, 2, null);
        }
        ASN1Encodable originatorKeyIdAttribute = originatorKeyIdAttributeContainer.getAttrValues().getObjectAt(0);
        if (!(originatorKeyIdAttribute instanceof ASN1Integer)) {
            throw new EnvelopedDataException("Originator key id is not an INTEGER", null, 2, null);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)HashingAlgorithm.SHA256), (Object)CMSAlgorithm.ECDH_SHA256KDF), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA384), (Object)CMSAlgorithm.ECDH_SHA384KDF), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA512), (Object)CMSAlgorithm.ECDH_SHA512KDF)};
        ecdhAlgorithmByHashingAlgorithm = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JI\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\u0002\b\u0019H\u0002JB\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0005J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0005J \u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R%\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData$Companion;", "", "()V", "ecdhAlgorithmByHashingAlgorithm", "", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "kotlin.jvm.PlatformType", "getEcdhAlgorithmByHashingAlgorithm", "()Ljava/util/Map;", "encrypt", "Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData;", "plaintext", "", "originatorKeyId", "Ljava/math/BigInteger;", "originatorKeyPair", "Ljava/security/KeyPair;", "symmetricEncryptionAlgorithm", "Ltech/relaycorp/relaynet/SymmetricEncryption;", "hashingAlgorithm", "recipientInfoAppender", "Lkotlin/Function1;", "Lorg/bouncycastle/cms/jcajce/JceKeyAgreeRecipientInfoGenerator;", "", "Lkotlin/ExtensionFunctionType;", "recipientKeyId", "recipientKey", "Ljava/security/PublicKey;", "recipientCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "makeRecipientInfoGenerator", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<HashingAlgorithm, ASN1ObjectIdentifier> getEcdhAlgorithmByHashingAlgorithm() {
            return ecdhAlgorithmByHashingAlgorithm;
        }

        @NotNull
        public final SessionEnvelopedData encrypt(@NotNull byte[] plaintext2, @NotNull Certificate recipientCertificate, @NotNull BigInteger originatorKeyId, @NotNull KeyPair originatorKeyPair, @NotNull SymmetricEncryption symmetricEncryptionAlgorithm, @NotNull HashingAlgorithm hashingAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)recipientCertificate, (String)"recipientCertificate");
            Intrinsics.checkNotNullParameter((Object)originatorKeyId, (String)"originatorKeyId");
            Intrinsics.checkNotNullParameter((Object)originatorKeyPair, (String)"originatorKeyPair");
            Intrinsics.checkNotNullParameter((Object)((Object)symmetricEncryptionAlgorithm), (String)"symmetricEncryptionAlgorithm");
            Intrinsics.checkNotNullParameter((Object)((Object)hashingAlgorithm), (String)"hashingAlgorithm");
            X509Certificate recipientX509Certificate = new JcaX509CertificateConverter().getCertificate(recipientCertificate.getCertificateHolder$awala());
            return this.encrypt(plaintext2, originatorKeyId, originatorKeyPair, symmetricEncryptionAlgorithm, hashingAlgorithm, (Function1<? super JceKeyAgreeRecipientInfoGenerator, Unit>)((Function1)new Function1<JceKeyAgreeRecipientInfoGenerator, Unit>(recipientX509Certificate){
                final /* synthetic */ X509Certificate $recipientX509Certificate;
                {
                    this.$recipientX509Certificate = $recipientX509Certificate;
                    super(1);
                }

                public final void invoke(@NotNull JceKeyAgreeRecipientInfoGenerator $this$encrypt) {
                    Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"$this$encrypt");
                    $this$encrypt.addRecipient(this.$recipientX509Certificate);
                }
            }));
        }

        public static /* synthetic */ SessionEnvelopedData encrypt$default(Companion companion, byte[] byArray, Certificate certificate, BigInteger bigInteger, KeyPair keyPair, SymmetricEncryption symmetricEncryption, HashingAlgorithm hashingAlgorithm, int n, Object object) {
            if ((n & 0x10) != 0) {
                symmetricEncryption = SymmetricEncryption.AES_128;
            }
            if ((n & 0x20) != 0) {
                hashingAlgorithm = HashingAlgorithm.SHA256;
            }
            return companion.encrypt(byArray, certificate, bigInteger, keyPair, symmetricEncryption, hashingAlgorithm);
        }

        @NotNull
        public final SessionEnvelopedData encrypt(@NotNull byte[] plaintext2, @NotNull byte[] recipientKeyId, @NotNull PublicKey recipientKey, @NotNull BigInteger originatorKeyId, @NotNull KeyPair originatorKeyPair, @NotNull SymmetricEncryption symmetricEncryptionAlgorithm, @NotNull HashingAlgorithm hashingAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)recipientKeyId, (String)"recipientKeyId");
            Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
            Intrinsics.checkNotNullParameter((Object)originatorKeyId, (String)"originatorKeyId");
            Intrinsics.checkNotNullParameter((Object)originatorKeyPair, (String)"originatorKeyPair");
            Intrinsics.checkNotNullParameter((Object)((Object)symmetricEncryptionAlgorithm), (String)"symmetricEncryptionAlgorithm");
            Intrinsics.checkNotNullParameter((Object)((Object)hashingAlgorithm), (String)"hashingAlgorithm");
            return this.encrypt(plaintext2, originatorKeyId, originatorKeyPair, symmetricEncryptionAlgorithm, hashingAlgorithm, (Function1<? super JceKeyAgreeRecipientInfoGenerator, Unit>)((Function1)new Function1<JceKeyAgreeRecipientInfoGenerator, Unit>(recipientKeyId, recipientKey){
                final /* synthetic */ byte[] $recipientKeyId;
                final /* synthetic */ PublicKey $recipientKey;
                {
                    this.$recipientKeyId = $recipientKeyId;
                    this.$recipientKey = $recipientKey;
                    super(1);
                }

                public final void invoke(@NotNull JceKeyAgreeRecipientInfoGenerator $this$encrypt) {
                    Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"$this$encrypt");
                    $this$encrypt.addRecipient(this.$recipientKeyId, this.$recipientKey);
                }
            }));
        }

        public static /* synthetic */ SessionEnvelopedData encrypt$default(Companion companion, byte[] byArray, byte[] byArray2, PublicKey publicKey, BigInteger bigInteger, KeyPair keyPair, SymmetricEncryption symmetricEncryption, HashingAlgorithm hashingAlgorithm, int n, Object object) {
            if ((n & 0x20) != 0) {
                symmetricEncryption = SymmetricEncryption.AES_128;
            }
            if ((n & 0x40) != 0) {
                hashingAlgorithm = HashingAlgorithm.SHA256;
            }
            return companion.encrypt(byArray, byArray2, publicKey, bigInteger, keyPair, symmetricEncryption, hashingAlgorithm);
        }

        private final SessionEnvelopedData encrypt(byte[] plaintext2, BigInteger originatorKeyId, KeyPair originatorKeyPair, SymmetricEncryption symmetricEncryptionAlgorithm, HashingAlgorithm hashingAlgorithm, Function1<? super JceKeyAgreeRecipientInfoGenerator, Unit> recipientInfoAppender) {
            JceKeyAgreeRecipientInfoGenerator recipientInfoGenerator = this.makeRecipientInfoGenerator(originatorKeyPair, symmetricEncryptionAlgorithm, hashingAlgorithm);
            recipientInfoAppender.invoke((Object)recipientInfoGenerator);
            Hashtable unprotectedAttrs = new Hashtable();
            Map map = unprotectedAttrs;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER();
            Attribute attribute = new Attribute(OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER(), (ASN1Set)new DERSet((ASN1Encodable)new ASN1Integer(originatorKeyId)));
            boolean bl = false;
            map.put(aSN1ObjectIdentifier, attribute);
            CMSEnvelopedData bcEnvelopedData = EnvelopedDataKt.access$bcEncrypt(plaintext2, symmetricEncryptionAlgorithm, (RecipientInfoGenerator)recipientInfoGenerator, new AttributeTable(unprotectedAttrs));
            return new SessionEnvelopedData(bcEnvelopedData);
        }

        private final JceKeyAgreeRecipientInfoGenerator makeRecipientInfoGenerator(KeyPair originatorKeyPair, SymmetricEncryption symmetricEncryptionAlgorithm, HashingAlgorithm hashingAlgorithm) {
            ASN1ObjectIdentifier ecdhAlgorithm = this.getEcdhAlgorithmByHashingAlgorithm().get((Object)hashingAlgorithm);
            ASN1ObjectIdentifier keyWrapCipher = EnvelopedDataKt.getKEY_WRAP_ALGORITHMS().get((Object)symmetricEncryptionAlgorithm);
            JceKeyAgreeRecipientInfoGenerator jceKeyAgreeRecipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(ecdhAlgorithm, originatorKeyPair.getPrivate(), originatorKeyPair.getPublic(), keyWrapCipher).setUserKeyingMaterial(PRNGKt.generateRandomOctets(64)).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            Intrinsics.checkNotNullExpressionValue((Object)jceKeyAgreeRecipientInfoGenerator, (String)"JceKeyAgreeRecipientInfo\u2026.setProvider(BC_PROVIDER)");
            return jceKeyAgreeRecipientInfoGenerator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

