/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration;", "", "privateNodeCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "gatewayCertificate", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ltech/relaycorp/relaynet/wrappers/x509/Certificate;)V", "getGatewayCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getPrivateNodeCertificate", "serialize", "", "Companion", "awala"})
public final class PrivateNodeRegistration {
    @NotNull
    private final Certificate privateNodeCertificate;
    @NotNull
    private final Certificate gatewayCertificate;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize() {
        DEROctetString nodeCertificateASN1 = new DEROctetString(this.privateNodeCertificate.serialize());
        DEROctetString gatewayCertificateASN1 = new DEROctetString(this.gatewayCertificate.serialize());
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)nodeCertificateASN1, (ASN1Encodable)gatewayCertificateASN1}, false);
    }

    @NotNull
    public final Certificate getPrivateNodeCertificate() {
        return this.privateNodeCertificate;
    }

    @NotNull
    public final Certificate getGatewayCertificate() {
        return this.gatewayCertificate;
    }

    public PrivateNodeRegistration(@NotNull Certificate privateNodeCertificate, @NotNull Certificate gatewayCertificate) {
        Intrinsics.checkParameterIsNotNull((Object)privateNodeCertificate, (String)"privateNodeCertificate");
        Intrinsics.checkParameterIsNotNull((Object)gatewayCertificate, (String)"gatewayCertificate");
        this.privateNodeCertificate = privateNodeCertificate;
        this.gatewayCertificate = gatewayCertificate;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration;", "serialization", "", "deserializeCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "asn1Object", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "awala"})
    public static final class Companion {
        @NotNull
        public final PrivateNodeRegistration deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            Certificate certificate;
            Certificate exc2;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc2) {
                throw (Throwable)new InvalidMessageException("Node registration is not a DER sequence", exc2);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 2) {
                throw (Throwable)new InvalidMessageException("Node registration sequence should have at least two items (got " + sequence.length + ')', null, 2, null);
            }
            try {
                exc2 = this.deserializeCertificate(sequence[0]);
            }
            catch (CertificateException exc3) {
                throw (Throwable)new InvalidMessageException("Node registration contains invalid node certificate", exc3);
            }
            Certificate nodeCertificate = exc2;
            try {
                certificate = this.deserializeCertificate(sequence[1]);
            }
            catch (CertificateException exc4) {
                throw (Throwable)new InvalidMessageException("Node registration contains invalid gateway certificate", exc4);
            }
            Certificate gatewayCertificate = certificate;
            return new PrivateNodeRegistration(nodeCertificate, gatewayCertificate);
        }

        private final Certificate deserializeCertificate(ASN1TaggedObject asn1Object) throws CertificateException {
            ASN1OctetString certificateASN1 = ASN1Utils.INSTANCE.getOctetString(asn1Object);
            byte[] byArray = certificateASN1.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificateASN1.octets");
            return Certificate.Companion.deserialize(byArray);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

