/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.payloads;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.payloads.EncryptedPayload;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Ltech/relaycorp/relaynet/messages/payloads/CargoCollectionRequest;", "Ltech/relaycorp/relaynet/messages/payloads/EncryptedPayload;", "cargoDeliveryAuthorization", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;)V", "getCargoDeliveryAuthorization", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "serializePlaintext", "", "Companion", "awala"})
public final class CargoCollectionRequest
extends EncryptedPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Certificate cargoDeliveryAuthorization;

    public CargoCollectionRequest(@NotNull Certificate cargoDeliveryAuthorization) {
        Intrinsics.checkNotNullParameter((Object)cargoDeliveryAuthorization, (String)"cargoDeliveryAuthorization");
        this.cargoDeliveryAuthorization = cargoDeliveryAuthorization;
    }

    @NotNull
    public final Certificate getCargoDeliveryAuthorization() {
        return this.cargoDeliveryAuthorization;
    }

    @Override
    @NotNull
    public byte[] serializePlaintext() {
        DEROctetString cdaASN1 = new DEROctetString(this.cargoDeliveryAuthorization.serialize());
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{(ASN1Encodable)cdaASN1};
        return ASN1Utils.INSTANCE.serializeSequence(aSN1EncodableArray, false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/messages/payloads/CargoCollectionRequest$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/payloads/CargoCollectionRequest;", "serialization", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CargoCollectionRequest deserialize(@NotNull byte[] serialization) throws RAMFException {
            Object object;
            Object[] sequence;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                objectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new RAMFException("CCR is not a valid DER sequence", exc);
            }
            objectArray = sequence = objectArray;
            boolean exc = false;
            if (objectArray.length == 0) {
                throw new RAMFException("CCR should have at least one item", null, 2, null);
            }
            ASN1OctetString cdaASN1 = DEROctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)ArraysKt.first((Object[])sequence)), (boolean)false);
            try {
                object = cdaASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cdaASN1.octets");
                object = Certificate.Companion.deserialize((byte[])object);
            }
            catch (CertificateException exc2) {
                throw new RAMFException("CDA contained in CCR is invalid", exc2);
            }
            Object cda = object;
            return new CargoCollectionRequest((Certificate)cda);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

