/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a4\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a4\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a0\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"MAX_DH_CERT_LENGTH_DAYS", "", "issueDeliveryAuthorization", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "subjectPublicKey", "Ljava/security/PublicKey;", "issuerPrivateKey", "Ljava/security/PrivateKey;", "validityEndDate", "Ljava/time/ZonedDateTime;", "issuerCertificate", "validityStartDate", "issueEndpointCertificate", "issueGatewayCertificate", "issueInitialDHKeyCertificate", "awala"})
@JvmName(name="PKI")
public final class PKI {
    private static final long MAX_DH_CERT_LENGTH_DAYS = 60L;

    @NotNull
    public static final Certificate issueGatewayCertificate(@NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, @NotNull ZonedDateTime validityStartDate) {
        Intrinsics.checkNotNullParameter((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkNotNullParameter((Object)issuerPrivateKey, (String)"issuerPrivateKey");
        Intrinsics.checkNotNullParameter((Object)validityEndDate, (String)"validityEndDate");
        Intrinsics.checkNotNullParameter((Object)validityStartDate, (String)"validityStartDate");
        boolean isSelfIssued = issuerCertificate == null;
        return Certificate.Companion.issue$awala(Keys.getPrivateAddress(subjectPublicKey), subjectPublicKey, issuerPrivateKey, validityEndDate, issuerCertificate, true, isSelfIssued ? 2 : 1, validityStartDate);
    }

    public static /* synthetic */ Certificate issueGatewayCertificate$default(PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 8) != 0) {
            certificate = null;
        }
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now()");
            zonedDateTime2 = zonedDateTime3;
        }
        return PKI.issueGatewayCertificate(publicKey, privateKey, zonedDateTime, certificate, zonedDateTime2);
    }

    @NotNull
    public static final Certificate issueEndpointCertificate(@NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, @NotNull ZonedDateTime validityStartDate) {
        Intrinsics.checkNotNullParameter((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkNotNullParameter((Object)issuerPrivateKey, (String)"issuerPrivateKey");
        Intrinsics.checkNotNullParameter((Object)validityEndDate, (String)"validityEndDate");
        Intrinsics.checkNotNullParameter((Object)validityStartDate, (String)"validityStartDate");
        return Certificate.Companion.issue$awala(Keys.getPrivateAddress(subjectPublicKey), subjectPublicKey, issuerPrivateKey, validityEndDate, issuerCertificate, true, 0, validityStartDate);
    }

    public static /* synthetic */ Certificate issueEndpointCertificate$default(PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 8) != 0) {
            certificate = null;
        }
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now()");
            zonedDateTime2 = zonedDateTime3;
        }
        return PKI.issueEndpointCertificate(publicKey, privateKey, zonedDateTime, certificate, zonedDateTime2);
    }

    @NotNull
    public static final Certificate issueDeliveryAuthorization(@NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @NotNull Certificate issuerCertificate, @NotNull ZonedDateTime validityStartDate) {
        Intrinsics.checkNotNullParameter((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkNotNullParameter((Object)issuerPrivateKey, (String)"issuerPrivateKey");
        Intrinsics.checkNotNullParameter((Object)validityEndDate, (String)"validityEndDate");
        Intrinsics.checkNotNullParameter((Object)issuerCertificate, (String)"issuerCertificate");
        Intrinsics.checkNotNullParameter((Object)validityStartDate, (String)"validityStartDate");
        return Certificate.Companion.issue$awala(Keys.getPrivateAddress(subjectPublicKey), subjectPublicKey, issuerPrivateKey, validityEndDate, issuerCertificate, false, 0, validityStartDate);
    }

    public static /* synthetic */ Certificate issueDeliveryAuthorization$default(PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now()");
            zonedDateTime2 = zonedDateTime3;
        }
        return PKI.issueDeliveryAuthorization(publicKey, privateKey, zonedDateTime, certificate, zonedDateTime2);
    }

    @NotNull
    public static final Certificate issueInitialDHKeyCertificate(@NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull Certificate issuerCertificate, @NotNull ZonedDateTime validityEndDate, @NotNull ZonedDateTime validityStartDate) {
        Intrinsics.checkNotNullParameter((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkNotNullParameter((Object)issuerPrivateKey, (String)"issuerPrivateKey");
        Intrinsics.checkNotNullParameter((Object)issuerCertificate, (String)"issuerCertificate");
        Intrinsics.checkNotNullParameter((Object)validityEndDate, (String)"validityEndDate");
        Intrinsics.checkNotNullParameter((Object)validityStartDate, (String)"validityStartDate");
        ZonedDateTime maxEndDate = validityStartDate.plusDays(60L);
        if (maxEndDate.compareTo(validityEndDate) < 0) {
            throw new CertificateException("DH key may not be valid for more than 60 days", null, 2, null);
        }
        return Certificate.Companion.issue$awala(issuerCertificate.getCommonName(), subjectPublicKey, issuerPrivateKey, validityEndDate, issuerCertificate, false, 0, validityStartDate);
    }

    public static /* synthetic */ Certificate issueInitialDHKeyCertificate$default(PublicKey publicKey, PrivateKey privateKey, Certificate certificate, ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now(ZoneId.of("UTC"));
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now(ZoneId.of(\"UTC\"))");
            zonedDateTime2 = zonedDateTime3;
        }
        return PKI.issueInitialDHKeyCertificate(publicKey, privateKey, certificate, zonedDateTime, zonedDateTime2);
    }
}

