/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.math.BigInteger;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.jcajce.JcaAlgorithmParametersConverter;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.SymmetricEncryption;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataKt;
import tech.relaycorp.relaynet.wrappers.cms.RecipientIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.RecipientSerialNumber;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData;", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "getRecipientKeyId", "Ltech/relaycorp/relaynet/wrappers/cms/RecipientIdentifier;", "validate", "", "Companion", "awala"})
public final class SessionlessEnvelopedData
extends EnvelopedData {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public RecipientIdentifier getRecipientKeyId() {
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Object object = CollectionsKt.first((Iterable)((Iterable)recipientInformationStore));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bcEnvelopedData.recipientInfos.first()");
        RecipientId recipientId = ((RecipientInformation)object).getRID();
        if (recipientId == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.cms.KeyTransRecipientId");
        }
        KeyTransRecipientId rid = (KeyTransRecipientId)recipientId;
        BigInteger bigInteger = rid.getSerialNumber();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"rid.serialNumber");
        return new RecipientSerialNumber(bigInteger);
    }

    @Override
    public void validate() throws EnvelopedDataException {
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Object object = CollectionsKt.first((Iterable)((Iterable)recipientInformationStore));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bcEnvelopedData.recipientInfos.first()");
        RecipientId recipientId = ((RecipientInformation)object).getRID();
        if (recipientId == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.cms.KeyTransRecipientId");
        }
        KeyTransRecipientId rid = (KeyTransRecipientId)recipientId;
        if (rid.getSerialNumber() == null) {
            throw (Throwable)new EnvelopedDataException("Required recipient key id to be IssuerAndSerialNumber (got SubjectKeyIdentifier)", null, 2, null);
        }
    }

    public SessionlessEnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkParameterIsNotNull((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        super(bcEnvelopedData);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData$Companion;", "", "()V", "encrypt", "Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData;", "plaintext", "", "recipientCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "symmetricEncryptionAlgorithm", "Ltech/relaycorp/relaynet/SymmetricEncryption;", "makeRecipientInfoGenerator", "Lorg/bouncycastle/cms/jcajce/JceKeyTransRecipientInfoGenerator;", "awala"})
    public static final class Companion {
        @NotNull
        public final SessionlessEnvelopedData encrypt(@NotNull byte[] plaintext2, @NotNull Certificate recipientCertificate, @NotNull SymmetricEncryption symmetricEncryptionAlgorithm) {
            Intrinsics.checkParameterIsNotNull((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkParameterIsNotNull((Object)recipientCertificate, (String)"recipientCertificate");
            Intrinsics.checkParameterIsNotNull((Object)((Object)symmetricEncryptionAlgorithm), (String)"symmetricEncryptionAlgorithm");
            JceKeyTransRecipientInfoGenerator recipientInfoGenerator = this.makeRecipientInfoGenerator(recipientCertificate);
            CMSEnvelopedData bcEnvelopedData = EnvelopedDataKt.bcEncrypt(plaintext2, symmetricEncryptionAlgorithm, (RecipientInfoGenerator)recipientInfoGenerator);
            return new SessionlessEnvelopedData(bcEnvelopedData);
        }

        public static /* synthetic */ SessionlessEnvelopedData encrypt$default(Companion companion, byte[] byArray, Certificate certificate, SymmetricEncryption symmetricEncryption, int n, Object object) {
            if ((n & 4) != 0) {
                symmetricEncryption = SymmetricEncryption.AES_128;
            }
            return companion.encrypt(byArray, certificate, symmetricEncryption);
        }

        private final JceKeyTransRecipientInfoGenerator makeRecipientInfoGenerator(Certificate recipientCertificate) {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(recipientCertificate.getCertificateHolder$awala());
            AlgorithmIdentifier algorithmIdentifier = new JcaAlgorithmParametersConverter().getAlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (AlgorithmParameterSpec)new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT));
            JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(x509Certificate, algorithmIdentifier).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            Intrinsics.checkExpressionValueIsNotNull((Object)jceKeyTransRecipientInfoGenerator, (String)"JceKeyTransRecipientInfo\u2026.setProvider(BC_PROVIDER)");
            return jceKeyTransRecipientInfoGenerator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

