/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import java.security.PrivateKey;
import java.time.ZonedDateTime;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.messages.payloads.EncryptedPayload;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFMessage;
import tech.relaycorp.relaynet.ramf.RAMFSerializer;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.SessionlessEnvelopedData;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001bBU\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001c"}, d2={"Ltech/relaycorp/relaynet/ramf/EncryptedRAMFMessage;", "P", "Ltech/relaycorp/relaynet/messages/payloads/EncryptedPayload;", "Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "serializer", "Ltech/relaycorp/relaynet/ramf/RAMFSerializer;", "recipientAddress", "", "payload", "", "senderCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "messageId", "creationDate", "Ljava/time/ZonedDateTime;", "ttl", "", "senderCertificateChain", "", "(Ltech/relaycorp/relaynet/ramf/RAMFSerializer;Ljava/lang/String;[BLtech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/lang/String;Ljava/time/ZonedDateTime;Ljava/lang/Integer;Ljava/util/Set;)V", "deserializePayload", "payloadPlaintext", "([B)Ltech/relaycorp/relaynet/messages/payloads/EncryptedPayload;", "unwrapPayload", "privateKey", "Ljava/security/PrivateKey;", "(Ljava/security/PrivateKey;)Ltech/relaycorp/relaynet/messages/payloads/EncryptedPayload;", "Companion", "awala"})
public abstract class EncryptedRAMFMessage<P extends EncryptedPayload>
extends RAMFMessage<P> {
    public static final int MAX_PAYLOAD_PLAINTEXT_LENGTH = 8322048;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final P unwrapPayload(@NotNull PrivateKey privateKey) throws RAMFException, EnvelopedDataException {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        EnvelopedData envelopedData = EnvelopedData.Companion.deserialize(this.getPayload());
        if (envelopedData == null) {
            throw new TypeCastException("null cannot be cast to non-null type tech.relaycorp.relaynet.wrappers.cms.SessionlessEnvelopedData");
        }
        SessionlessEnvelopedData envelopedData2 = (SessionlessEnvelopedData)envelopedData;
        byte[] plaintext2 = envelopedData2.decrypt(privateKey);
        return this.deserializePayload(plaintext2);
    }

    @NotNull
    protected abstract P deserializePayload(@NotNull byte[] var1) throws RAMFException;

    public EncryptedRAMFMessage(@NotNull RAMFSerializer serializer, @NotNull String recipientAddress, @NotNull byte[] payload, @NotNull Certificate senderCertificate, @Nullable String messageId, @Nullable ZonedDateTime creationDate, @Nullable Integer ttl, @Nullable Set<Certificate> senderCertificateChain) {
        Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)recipientAddress, (String)"recipientAddress");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)senderCertificate, (String)"senderCertificate");
        super(serializer, recipientAddress, payload, senderCertificate, messageId, creationDate, ttl, senderCertificateChain);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/relaycorp/relaynet/ramf/EncryptedRAMFMessage$Companion;", "", "()V", "MAX_PAYLOAD_PLAINTEXT_LENGTH", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

