/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.testing.pki;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZonedDateTime;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.PKI;
import tech.relaycorp.relaynet.testing.pki.KeyPairSet;
import tech.relaycorp.relaynet.testing.pki.UtilsKt;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001b\u0010\r\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007R!\u0010\u0010\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\t\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ltech/relaycorp/relaynet/testing/pki/PDACertPath;", "", "<init>", "()V", "INTERNET_GW", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getINTERNET_GW", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "INTERNET_GW$delegate", "Lkotlin/Lazy;", "PRIVATE_GW", "getPRIVATE_GW", "PRIVATE_GW$delegate", "PRIVATE_ENDPOINT", "getPRIVATE_ENDPOINT", "PRIVATE_ENDPOINT$delegate", "PDA", "getPDA$annotations", "getPDA", "PDA$delegate", "awala-testing"})
public final class PDACertPath {
    @NotNull
    public static final PDACertPath INSTANCE = new PDACertPath();
    @NotNull
    private static final Lazy INTERNET_GW$delegate = LazyKt.lazy(PDACertPath::INTERNET_GW_delegate$lambda$0);
    @NotNull
    private static final Lazy PRIVATE_GW$delegate = LazyKt.lazy(PDACertPath::PRIVATE_GW_delegate$lambda$1);
    @NotNull
    private static final Lazy PRIVATE_ENDPOINT$delegate = LazyKt.lazy(PDACertPath::PRIVATE_ENDPOINT_delegate$lambda$2);
    @NotNull
    private static final Lazy PDA$delegate = LazyKt.lazy(PDACertPath::PDA_delegate$lambda$3);

    private PDACertPath() {
    }

    @NotNull
    public final Certificate getINTERNET_GW() {
        Lazy lazy = INTERNET_GW$delegate;
        return (Certificate)lazy.getValue();
    }

    @NotNull
    public final Certificate getPRIVATE_GW() {
        Lazy lazy = PRIVATE_GW$delegate;
        return (Certificate)lazy.getValue();
    }

    @NotNull
    public final Certificate getPRIVATE_ENDPOINT() {
        Lazy lazy = PRIVATE_ENDPOINT$delegate;
        return (Certificate)lazy.getValue();
    }

    @NotNull
    public final Certificate getPDA() {
        Lazy lazy = PDA$delegate;
        return (Certificate)lazy.getValue();
    }

    public static /* synthetic */ void getPDA$annotations() {
    }

    private static final Certificate INTERNET_GW_delegate$lambda$0() {
        PublicKey publicKey = KeyPairSet.INSTANCE.getINTERNET_GW().getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        PrivateKey privateKey = KeyPairSet.INSTANCE.getINTERNET_GW().getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        ZonedDateTime zonedDateTime = UtilsKt.getCERTIFICATE_END_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"<get-CERTIFICATE_END_DATE>(...)");
        ZonedDateTime zonedDateTime2 = UtilsKt.getCERTIFICATE_START_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"<get-CERTIFICATE_START_DATE>(...)");
        return PKI.issueGatewayCertificate$default((PublicKey)publicKey, (PrivateKey)privateKey, (ZonedDateTime)zonedDateTime, null, (ZonedDateTime)zonedDateTime2, (int)8, null);
    }

    private static final Certificate PRIVATE_GW_delegate$lambda$1() {
        PublicKey publicKey = KeyPairSet.INSTANCE.getPRIVATE_GW().getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        PrivateKey privateKey = KeyPairSet.INSTANCE.getINTERNET_GW().getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        ZonedDateTime zonedDateTime = UtilsKt.getCERTIFICATE_END_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"<get-CERTIFICATE_END_DATE>(...)");
        Certificate certificate = INSTANCE.getINTERNET_GW();
        ZonedDateTime zonedDateTime2 = UtilsKt.getCERTIFICATE_START_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"<get-CERTIFICATE_START_DATE>(...)");
        return PKI.issueGatewayCertificate((PublicKey)publicKey, (PrivateKey)privateKey, (ZonedDateTime)zonedDateTime, (Certificate)certificate, (ZonedDateTime)zonedDateTime2);
    }

    private static final Certificate PRIVATE_ENDPOINT_delegate$lambda$2() {
        PublicKey publicKey = KeyPairSet.INSTANCE.getPRIVATE_ENDPOINT().getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        PrivateKey privateKey = KeyPairSet.INSTANCE.getPRIVATE_GW().getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        ZonedDateTime zonedDateTime = UtilsKt.getCERTIFICATE_END_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"<get-CERTIFICATE_END_DATE>(...)");
        Certificate certificate = INSTANCE.getPRIVATE_GW();
        ZonedDateTime zonedDateTime2 = UtilsKt.getCERTIFICATE_START_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"<get-CERTIFICATE_START_DATE>(...)");
        return PKI.issueEndpointCertificate((PublicKey)publicKey, (PrivateKey)privateKey, (ZonedDateTime)zonedDateTime, (Certificate)certificate, (ZonedDateTime)zonedDateTime2);
    }

    private static final Certificate PDA_delegate$lambda$3() {
        PublicKey publicKey = KeyPairSet.INSTANCE.getPDA_GRANTEE().getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        PrivateKey privateKey = KeyPairSet.INSTANCE.getPRIVATE_ENDPOINT().getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        ZonedDateTime zonedDateTime = UtilsKt.getCERTIFICATE_END_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"<get-CERTIFICATE_END_DATE>(...)");
        Certificate certificate = INSTANCE.getPRIVATE_ENDPOINT();
        ZonedDateTime zonedDateTime2 = UtilsKt.getCERTIFICATE_START_DATE();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"<get-CERTIFICATE_START_DATE>(...)");
        return PKI.issueDeliveryAuthorization((PublicKey)publicKey, (PrivateKey)privateKey, (ZonedDateTime)zonedDateTime, (Certificate)certificate, (ZonedDateTime)zonedDateTime2);
    }
}

