/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.testing.keystores;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.keystores.IdentityPrivateKeyData;
import tech.relaycorp.relaynet.keystores.KeyStoreBackendException;
import tech.relaycorp.relaynet.keystores.PrivateKeyStore;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u0019\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\bH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J+\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\tH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ3\u0010 \u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\tJ(\u0010$\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010!\u001a\u00020\rR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\f\u001a&\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u00070\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Ltech/relaycorp/relaynet/testing/keystores/MockPrivateKeyStore;", "Ltech/relaycorp/relaynet/keystores/PrivateKeyStore;", "savingException", "", "retrievalException", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)V", "identityKeys", "", "", "Ltech/relaycorp/relaynet/keystores/IdentityPrivateKeyData;", "getIdentityKeys", "()Ljava/util/Map;", "sessionKeys", "", "getSessionKeys", "clear", "", "deleteKeys", "privateAddress", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteSessionKeysForPeer", "peerPrivateAddress", "retrieveAllIdentityKeyData", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveIdentityKeyData", "retrieveSessionKeySerialized", "keyId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveIdentityKeyData", "keyData", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/IdentityPrivateKeyData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveSessionKeySerialized", "keySerialized", "(Ljava/lang/String;[BLjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setIdentityKey", "setSessionKey", "awala-testing"})
public final class MockPrivateKeyStore
extends PrivateKeyStore {
    @Nullable
    private final Throwable savingException;
    @Nullable
    private final Throwable retrievalException;
    @NotNull
    private final Map<String, IdentityPrivateKeyData> identityKeys;
    @NotNull
    private final Map<String, Map<String, Map<String, byte[]>>> sessionKeys;

    public MockPrivateKeyStore(@Nullable Throwable savingException, @Nullable Throwable retrievalException) {
        this.savingException = savingException;
        this.retrievalException = retrievalException;
        boolean bl = false;
        this.identityKeys = new LinkedHashMap();
        bl = false;
        this.sessionKeys = new LinkedHashMap();
    }

    public /* synthetic */ MockPrivateKeyStore(Throwable throwable, Throwable throwable2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        if ((n & 2) != 0) {
            throwable2 = null;
        }
        this(throwable, throwable2);
    }

    @NotNull
    public final Map<String, IdentityPrivateKeyData> getIdentityKeys() {
        return this.identityKeys;
    }

    @NotNull
    public final Map<String, Map<String, Map<String, byte[]>>> getSessionKeys() {
        return this.sessionKeys;
    }

    public final void clear() {
        this.identityKeys.clear();
        this.sessionKeys.clear();
    }

    @Nullable
    protected Object saveIdentityKeyData(@NotNull String privateAddress, @NotNull IdentityPrivateKeyData keyData, @NotNull Continuation<? super Unit> $completion) {
        if (this.savingException != null) {
            throw new KeyStoreBackendException("Saving identity keys isn't supported", this.savingException);
        }
        this.setIdentityKey(privateAddress, keyData);
        return Unit.INSTANCE;
    }

    public final void setIdentityKey(@NotNull String privateAddress, @NotNull IdentityPrivateKeyData keyData) {
        Intrinsics.checkNotNullParameter((Object)privateAddress, (String)"privateAddress");
        Intrinsics.checkNotNullParameter((Object)keyData, (String)"keyData");
        Map<String, IdentityPrivateKeyData> map = this.identityKeys;
        boolean bl = false;
        map.put(privateAddress, keyData);
    }

    @Nullable
    protected Object retrieveIdentityKeyData(@NotNull String privateAddress, @NotNull Continuation<? super IdentityPrivateKeyData> $completion) {
        if (this.retrievalException != null) {
            throw new KeyStoreBackendException("Retrieving identity keys isn't supported", this.savingException);
        }
        return this.getIdentityKeys().get(privateAddress);
    }

    @Nullable
    protected Object retrieveAllIdentityKeyData(@NotNull Continuation<? super List<IdentityPrivateKeyData>> $completion) {
        return CollectionsKt.toList((Iterable)this.getIdentityKeys().values());
    }

    @Nullable
    protected Object saveSessionKeySerialized(@NotNull String keyId, @NotNull byte[] keySerialized, @NotNull String privateAddress, @Nullable String peerPrivateAddress, @NotNull Continuation<? super Unit> $completion) {
        if (this.savingException != null) {
            throw new KeyStoreBackendException("Saving session keys isn't supported", this.savingException);
        }
        this.setSessionKey(privateAddress, peerPrivateAddress, keyId, keySerialized);
        return Unit.INSTANCE;
    }

    public final void setSessionKey(@NotNull String privateAddress, @Nullable String peerPrivateAddress, @NotNull String keyId, @NotNull byte[] keySerialized) {
        Intrinsics.checkNotNullParameter((Object)privateAddress, (String)"privateAddress");
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)keySerialized, (String)"keySerialized");
        boolean bl = false;
        this.sessionKeys.putIfAbsent(privateAddress, new LinkedHashMap());
        String string = peerPrivateAddress;
        String peerKey = string == null ? "unbound" : string;
        Map<String, Map<String, byte[]>> map = this.sessionKeys.get(privateAddress);
        Intrinsics.checkNotNull(map);
        boolean bl2 = false;
        map.putIfAbsent(peerKey, new LinkedHashMap());
        Map<String, Map<String, byte[]>> map2 = this.sessionKeys.get(privateAddress);
        Intrinsics.checkNotNull(map2);
        Map<String, byte[]> map3 = map2.get(peerKey);
        Intrinsics.checkNotNull(map3);
        Map<String, byte[]> map4 = map3;
        boolean bl3 = false;
        map4.put(keyId, keySerialized);
    }

    @Nullable
    protected Object retrieveSessionKeySerialized(@NotNull String keyId, @NotNull String privateAddress, @NotNull String peerPrivateAddress, @NotNull Continuation<? super byte[]> $completion) {
        Map<String, byte[]> map;
        byte[] byArray;
        if (this.retrievalException != null) {
            throw new KeyStoreBackendException("Retrieving session keys isn't supported", this.savingException);
        }
        Map<String, Map<String, byte[]>> map2 = this.getSessionKeys().get(privateAddress);
        byte[] byArray2 = map2 == null ? null : (byArray = (map = map2.get(peerPrivateAddress)) == null ? null : map.get(keyId));
        return byArray == null ? (Object)((map2 = this.getSessionKeys().get(privateAddress)) == null ? null : (Object)((map = map2.get("unbound")) == null ? null : map.get(keyId))) : byArray;
    }

    @Nullable
    public Object deleteKeys(@NotNull String privateAddress, @NotNull Continuation<? super Unit> $completion) {
        this.getIdentityKeys().remove(privateAddress);
        Map<String, Map<String, byte[]>> map = this.getSessionKeys().remove(privateAddress);
        if (map == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return map;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object deleteSessionKeysForPeer(@NotNull String peerPrivateAddress, @NotNull Continuation<? super Unit> $completion) {
        Iterable $this$forEach$iv = this.getSessionKeys().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            it.remove(peerPrivateAddress);
        }
        return Unit.INSTANCE;
    }

    public MockPrivateKeyStore() {
        this(null, null, 3, null);
    }
}

