/*
 * Decompiled with CFR 0.152.
 */
package tech.pylons.lib.types;

import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bitcoinj.core.AddressFormatException;
import org.jetbrains.annotations.NotNull;
import tech.pylons.lib.types.Bech32CosmosExtensions;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Ltech/pylons/lib/types/Bech32Cosmos;", "", "()V", "Bech32Data", "Companion", "UnencodedBech32Data", "libpylons"})
public final class Bech32Cosmos {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final byte[] CHARSET_REV;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        CHARSET_REV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15, -1, 10, 17, 21, 20, 26, 30, 7, 5, -1, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1};
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ltech/pylons/lib/types/Bech32Cosmos$Bech32Data;", "", "hrp", "", "data", "", "(Ljava/lang/String;[B)V", "getData", "()[B", "getHrp", "()Ljava/lang/String;", "libpylons"})
    public static final class Bech32Data {
        @NotNull
        private final String hrp;
        @NotNull
        private final byte[] data;

        @NotNull
        public final String getHrp() {
            return this.hrp;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public Bech32Data(@NotNull String hrp, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.hrp = hrp;
            this.data = data;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ltech/pylons/lib/types/Bech32Cosmos$UnencodedBech32Data;", "", "hrp", "", "data", "", "(Ljava/lang/String;[B)V", "getData", "()[B", "getHrp", "()Ljava/lang/String;", "libpylons"})
    public static final class UnencodedBech32Data {
        @NotNull
        private final String hrp;
        @NotNull
        private final byte[] data;

        @NotNull
        public final String getHrp() {
            return this.hrp;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public UnencodedBech32Data(@NotNull String hrp, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.hrp = hrp;
            this.data = data;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006J(\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltech/pylons/lib/types/Bech32Cosmos$Companion;", "", "()V", "CHARSET", "", "CHARSET_REV", "", "convertAndEncode", "hrp", "data", "convertBits", "fromBits", "", "toBits", "pad", "", "createChecksum", "values", "decode", "Ltech/pylons/lib/types/Bech32Cosmos$Bech32Data;", "str", "decodeAndConvert", "Ltech/pylons/lib/types/Bech32Cosmos$UnencodedBech32Data;", "bech", "encode", "humanReadablePart", "bech32", "expandHrp", "polymod", "verifyChecksum", "libpylons"})
    @ExperimentalUnsignedTypes
    public static final class Companion {
        private final int polymod(byte[] values) {
            int c = 1;
            for (byte v_i : values) {
                int c0 = c >>> 25 & 0xFF;
                c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
                if ((c0 & 1) != 0) {
                    c ^= 0x3B6A57B2;
                }
                if ((c0 & 2) != 0) {
                    c ^= 0x26508E6D;
                }
                if ((c0 & 4) != 0) {
                    c ^= 0x1EA119FA;
                }
                if ((c0 & 8) != 0) {
                    c ^= 0x3D4233DD;
                }
                if ((c0 & 0x10) == 0) continue;
                c ^= 0x2A1462B3;
            }
            return c;
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] expandHrp(String hrp) {
            int hrpLength = hrp.length();
            byte[] ret = new byte[hrpLength * 2 + 1];
            int n = 0;
            int n2 = hrpLength;
            while (n < n2) {
                void i;
                int c = hrp.charAt((int)i) & 0x7F;
                ret[i] = (byte)(c >>> 5 & 7);
                ret[i + hrpLength + true] = (byte)(c & 0x1F);
                ++i;
            }
            ret[hrpLength] = 0;
            return ret;
        }

        private final boolean verifyChecksum(String hrp, byte[] values) {
            byte[] hrpExpanded = this.expandHrp(hrp);
            byte[] combined = new byte[hrpExpanded.length + values.length];
            ArraysKt.copyInto$default((byte[])hrpExpanded, (byte[])combined, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto$default((byte[])values, (byte[])combined, (int)hrpExpanded.length, (int)0, (int)0, (int)12, null);
            return this.polymod(combined) == 1;
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] createChecksum(String hrp, byte[] values) {
            byte[] hrpExpanded = this.expandHrp(hrp);
            byte[] enc = new byte[hrpExpanded.length + values.length + 6];
            ArraysKt.copyInto$default((byte[])hrpExpanded, (byte[])enc, (int)0, (int)0, (int)0, (int)14, null);
            int n = 0;
            int n2 = hrpExpanded.length;
            int n3 = 0;
            ArraysKt.copyInto$default((byte[])values, (byte[])enc, (int)n2, (int)n3, (int)n, (int)8, null);
            int mod = this.polymod(enc) ^ 1;
            byte[] ret = new byte[6];
            n3 = 0;
            int n4 = 5;
            while (n3 <= n4) {
                void i;
                ret[i] = (byte)(mod >>> 5 * (5 - i) & 0x1F);
                ++i;
            }
            return ret;
        }

        @NotNull
        public final String encode(@NotNull Bech32Data bech32) {
            Intrinsics.checkNotNullParameter((Object)bech32, (String)"bech32");
            return this.encode(bech32.getHrp(), bech32.getData());
        }

        @NotNull
        public final String encode(@NotNull String humanReadablePart, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)humanReadablePart, (String)"humanReadablePart");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String hrp = humanReadablePart;
            CharSequence charSequence = hrp;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            int n = 0;
            if (!bl2) {
                boolean bl3 = false;
                String string = "Human-readable part is too short";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl2 = hrp.length() <= 83;
            bl = false;
            n = 0;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Human-readable part is too long";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String string = hrp;
            bl = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            hrp = string2;
            byte[] checksum = this.createChecksum(hrp, data);
            byte[] combined = new byte[data.length + checksum.length];
            ArraysKt.copyInto$default((byte[])data, (byte[])combined, (int)0, (int)0, (int)0, (int)14, null);
            n = 0;
            int bl4 = data.length;
            int n2 = 0;
            ArraysKt.copyInto$default((byte[])checksum, (byte[])combined, (int)bl4, (int)n2, (int)n, (int)8, null);
            StringBuilder sb = new StringBuilder(hrp.length() + 1 + combined.length);
            sb.append(hrp);
            sb.append('1');
            for (byte b : combined) {
                sb.append(Bech32Cosmos.CHARSET.charAt(b));
            }
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
            return string3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Bech32Data decode(@NotNull String str) {
            char c;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            boolean lower = false;
            boolean upper = false;
            if (str.length() < 8) {
                throw (Throwable)new AddressFormatException.InvalidDataLength("Input too short: " + str.length());
            }
            if (str.length() > 90) {
                throw (Throwable)new AddressFormatException.InvalidDataLength("Input too long: " + str.length());
            }
            int n = 0;
            int n2 = str.length();
            while (n < n2) {
                void i;
                char c2 = str.charAt((int)i);
                if (c2 < '!' || c2 > '~') {
                    throw (Throwable)new AddressFormatException.InvalidCharacter(c2, (int)i);
                }
                c = c2;
                if ('a' <= c && 'z' >= c) {
                    if (upper) {
                        throw (Throwable)new AddressFormatException.InvalidCharacter(c2, (int)i);
                    }
                    lower = true;
                }
                if ('A' <= (c = c2) && 'Z' >= c) {
                    if (lower) {
                        throw (Throwable)new AddressFormatException.InvalidCharacter(c2, (int)i);
                    }
                    upper = true;
                }
                ++i;
            }
            int pos = StringsKt.lastIndexOf$default((CharSequence)str, (char)'1', (int)0, (boolean)false, (int)6, null);
            if (pos < 1) {
                throw (Throwable)new AddressFormatException.InvalidPrefix("Missing human-readable part");
            }
            int dataPartLength = str.length() - 1 - pos;
            if (dataPartLength < 6) {
                throw (Throwable)new AddressFormatException.InvalidDataLength("Data part too short: " + dataPartLength);
            }
            byte[] values = new byte[dataPartLength];
            c = '\u0000';
            int n3 = dataPartLength;
            while (c < n3) {
                void i;
                char c3 = str.charAt((int)(i + pos + true));
                if (CHARSET_REV[c3] == -1) {
                    throw (Throwable)new AddressFormatException.InvalidCharacter(c3, (int)(i + pos + true));
                }
                values[i] = CHARSET_REV[c3];
                ++i;
            }
            Object object = str;
            int n4 = 0;
            int n5 = 0;
            String string = ((String)object).substring(n4, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = string;
            n4 = 0;
            String string2 = object;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String hrp = string3;
            if (!this.verifyChecksum(hrp, values)) {
                throw (Throwable)new AddressFormatException.InvalidChecksum();
            }
            object = values;
            n4 = 0;
            n5 = values.length - 6;
            boolean bl = false;
            return new Bech32Data(hrp, ArraysKt.copyOfRange((byte[])object, (int)n4, (int)n5));
        }

        @ExperimentalUnsignedTypes
        @NotNull
        public final byte[] convertBits(@NotNull byte[] data, int fromBits, int toBits, boolean pad) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            byte[] byArray = Bech32CosmosExtensions.convertBits(data, 0, data.length, fromBits, toBits, pad);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Bech32CosmosExtensions.c\u2026e, fromBits, toBits, pad)");
            return byArray;
        }

        @NotNull
        public final String convertAndEncode(@NotNull String hrp, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            byte[] converted = this.convertBits(data, 8, 5, true);
            return this.encode(hrp, converted);
        }

        @NotNull
        public final UnencodedBech32Data decodeAndConvert(@NotNull String bech) {
            Intrinsics.checkNotNullParameter((Object)bech, (String)"bech");
            Bech32Data data = this.decode(bech);
            byte[] converted = this.convertBits(data.getData(), 5, 8, false);
            return new UnencodedBech32Data(data.getHrp(), converted);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

