/*
 * Decompiled with CFR 0.152.
 */
package tech.pylons.droidwallet;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.pylons.droidwallet.WalletHandler;
import tech.pylons.ipc.IIpcInterface;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001c\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltech/pylons/droidwallet/IpcServiceConnection;", "Landroid/content/ServiceConnection;", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "context", "iIpcService", "Ltech/pylons/ipc/IIpcInterface;", "isServiceBinded", "", "bind", "", "getFromWallet", "", "onServiceConnected", "p0", "Landroid/content/ComponentName;", "service", "Landroid/os/IBinder;", "onServiceDisconnected", "submitToWallet", "json", "unbind", "Companion", "droidwallet_release"})
public final class IpcServiceConnection
implements ServiceConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isServiceBinded;
    @Nullable
    private Context context;
    @Nullable
    private IIpcInterface iIpcService;
    @NotNull
    private static final String TAG = "IpcServiceConnection";

    public IpcServiceConnection(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.context = ctx;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getFromWallet() {
        String string;
        if (this.isServiceBinded) {
            void var1_1;
            IIpcInterface iIpcInterface = this.iIpcService;
            Intrinsics.checkNotNull((Object)iIpcInterface);
            String msg = iIpcInterface.wallet2client();
            String string2 = Intrinsics.stringPlus((String)"getFromWallet ", (Object)msg);
            boolean bl = false;
            System.out.println((Object)string2);
            string = var1_1;
        } else {
            string = null;
        }
        return string;
    }

    public final void submitToWallet(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (this.isServiceBinded) {
            IIpcInterface iIpcInterface = this.iIpcService;
            Intrinsics.checkNotNull((Object)iIpcInterface);
            iIpcInterface.client2wallet(json);
        }
    }

    public void onServiceConnected(@Nullable ComponentName p0, @Nullable IBinder service) {
        this.isServiceBinded = true;
        this.iIpcService = IIpcInterface.Stub.asInterface(service);
        WalletHandler.DroidIpcWireImpl.Companion.initWallet();
    }

    public void onServiceDisconnected(@Nullable ComponentName p0) {
        Log.e((String)TAG, (String)"Service has unexpectedly disconnected");
        this.iIpcService = null;
        this.isServiceBinded = false;
    }

    public final void bind() {
        Log.d((String)TAG, (String)"Bind");
        Intent serviceIntent = new Intent("tech.pylons.wallet.ipc.BIND");
        serviceIntent.setPackage("tech.pylons.wallet");
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        context.bindService(serviceIntent, (ServiceConnection)this, 1);
    }

    public final void unbind() {
        if (this.iIpcService != null) {
            Log.d((String)TAG, (String)"Unbind");
            Context context = this.context;
            Intrinsics.checkNotNull((Object)context);
            context.unbindService((ServiceConnection)this);
            this.iIpcService = null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/pylons/droidwallet/IpcServiceConnection$Companion;", "", "()V", "TAG", "", "droidwallet_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

