/*
 * Decompiled with CFR 0.152.
 */
package com.beust.klaxon;

import com.beust.klaxon.Debug;
import com.beust.klaxon.KlaxonException;
import com.beust.klaxon.token.COLON;
import com.beust.klaxon.token.COMMA;
import com.beust.klaxon.token.EOF;
import com.beust.klaxon.token.LEFT_BRACE;
import com.beust.klaxon.token.LEFT_BRACKET;
import com.beust.klaxon.token.RIGHT_BRACE;
import com.beust.klaxon.token.RIGHT_BRACKET;
import com.beust.klaxon.token.Token;
import com.beust.klaxon.token.Value;
import java.io.BufferedReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010%\u001a\u00020\u0002H\u0002J\t\u0010&\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\nH\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\nH\u0002J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\nJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\t\u0010 \u001a\u00020\u0002H\u0096\u0002J\b\u0010/\u001a\u00020\nH\u0002J\u0006\u00100\u001a\u00020\u0002J\u0006\u00101\u001a\u00020\u0002J\b\u00102\u001a\u00020\nH\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0016\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u0012\u0010 \u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/beust/klaxon/Lexer;", "", "Lcom/beust/klaxon/token/Token;", "passedReader", "Ljava/io/Reader;", "lenient", "", "(Ljava/io/Reader;Z)V", "BOOLEAN_LETTERS", "", "", "getBOOLEAN_LETTERS", "()Ljava/util/Set;", "DOUBLE", "Ljava/util/regex/Pattern;", "NULL_LETTERS", "getNULL_LETTERS", "NUMERIC", "kotlin.jvm.PlatformType", "expectName", "index", "", "getIndex", "()I", "setIndex", "(I)V", "isDone", "()Z", "getLenient", "line", "getLine", "setLine", "next", "Ljava/lang/Character;", "peeked", "reader", "Ljava/io/BufferedReader;", "actualNextToken", "hasNext", "isBooleanLetter", "c", "isSpace", "isValueLetter", "log", "", "s", "", "nextChar", "nextToken", "peek", "peekChar", "klaxon"})
public final class Lexer
implements Iterator<Token>,
KMappedMarker {
    private int index;
    private int line;
    private final Pattern NUMERIC;
    private final Pattern DOUBLE;
    private final BufferedReader reader;
    private Character next;
    @NotNull
    private final Set<Character> BOOLEAN_LETTERS;
    @NotNull
    private final Set<Character> NULL_LETTERS;
    private Token peeked;
    private boolean expectName;
    private final boolean lenient;

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int n) {
        this.line = n;
    }

    private final boolean isSpace(char c) {
        if (c == '\n') {
            int n = this.line;
            this.line = n + 1;
        }
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    private final boolean isDone() {
        return this.next == null;
    }

    /*
     * WARNING - void declaration
     */
    private final char nextChar() {
        void it;
        Character c;
        if (this.isDone()) {
            throw (Throwable)new IllegalStateException("Cannot get next char: EOF reached");
        }
        Character c2 = this.next;
        Intrinsics.checkNotNull((Object)c2);
        char c3 = c2.charValue();
        int n = this.reader.read();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = n;
        Lexer lexer = this;
        boolean bl3 = false;
        lexer.next = c = it == -1 ? null : Character.valueOf((char)it);
        n = this.index;
        this.index = n + 1;
        return c3;
    }

    private final char peekChar() {
        if (this.isDone()) {
            throw (Throwable)new IllegalStateException("Cannot peek next char: EOF reached");
        }
        Character c = this.next;
        Intrinsics.checkNotNull((Object)c);
        return c.charValue();
    }

    @NotNull
    public final Set<Character> getBOOLEAN_LETTERS() {
        return this.BOOLEAN_LETTERS;
    }

    private final boolean isBooleanLetter(char c) {
        return this.BOOLEAN_LETTERS.contains(Character.valueOf(Character.toLowerCase(c)));
    }

    @NotNull
    public final Set<Character> getNULL_LETTERS() {
        return this.NULL_LETTERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValueLetter(char c) {
        if (c == '-') return true;
        if (c == '+') return true;
        if (c == '.') return true;
        char c2 = c;
        boolean bl = false;
        if (Character.isDigit(c2)) return true;
        if (this.isBooleanLetter(c)) return true;
        if (!this.NULL_LETTERS.contains(Character.valueOf(c))) return false;
        return true;
    }

    @NotNull
    public final Token peek() {
        Token token = this.peeked;
        if (token == null) {
            token = this.actualNextToken();
        }
        Token token2 = this.peeked = token;
        Intrinsics.checkNotNull((Object)token2);
        return token2;
    }

    @Override
    @NotNull
    public Token next() {
        return this.nextToken();
    }

    @Override
    public boolean hasNext() {
        return !(this.peek() instanceof EOF);
    }

    @NotNull
    public final Token nextToken() {
        Token token;
        block3: {
            block2: {
                token = this.peeked;
                if (token == null) break block2;
                Token token2 = token;
                boolean bl = false;
                boolean bl2 = false;
                Token it = token2;
                boolean bl3 = false;
                this.peeked = null;
                token = token2;
                if (token != null) break block3;
            }
            token = this.actualNextToken();
        }
        return token;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Token actualNextToken() {
        if (this.isDone()) {
            return EOF.INSTANCE;
        }
        Token token = null;
        char c = this.nextChar();
        StringBuilder currentValue = new StringBuilder();
        while (!this.isDone() && this.isSpace(c)) {
            c = this.nextChar();
        }
        if ('\"' == c || this.lenient && this.expectName) {
            if (this.lenient) {
                currentValue.append(c);
            }
            block19: while (true) {
                if (this.isDone()) {
                    throw (Throwable)new KlaxonException("Unterminated string");
                }
                c = this.lenient ? this.peekChar() : this.nextChar();
                switch (c) {
                    case '\\': {
                        if (this.isDone()) {
                            throw (Throwable)new KlaxonException("Unterminated string");
                        }
                        c = this.nextChar();
                        switch (c) {
                            case '\\': {
                                currentValue.append("\\");
                                continue block19;
                            }
                            case '/': {
                                currentValue.append("/");
                                continue block19;
                            }
                            case 'b': {
                                currentValue.append("\b");
                                continue block19;
                            }
                            case 'f': {
                                currentValue.append("\f");
                                continue block19;
                            }
                            case 'n': {
                                currentValue.append("\n");
                                int n = this.line;
                                this.line = n + 1;
                                continue block19;
                            }
                            case 'r': {
                                currentValue.append("\r");
                                continue block19;
                            }
                            case 't': {
                                currentValue.append("\t");
                                continue block19;
                            }
                            case 'u': {
                                StringBuilder unicodeChar = new StringBuilder(4).append(this.nextChar()).append(this.nextChar()).append(this.nextChar()).append(this.nextChar());
                                int intValue = Integer.parseInt(unicodeChar.toString(), 16);
                                currentValue.append((char)intValue);
                                continue block19;
                            }
                        }
                        currentValue.append(c);
                        continue block19;
                    }
                    case '\"': {
                        return new Value<String>(currentValue.toString());
                    }
                    default: {
                        if (this.lenient) {
                            char unicodeChar = c;
                            boolean bl = false;
                            if (!Character.isJavaIdentifierPart(unicodeChar)) {
                                this.expectName = false;
                                return new Value<String>(currentValue.toString());
                            }
                            currentValue.append(c);
                            this.nextChar();
                            continue block19;
                        }
                        currentValue.append(c);
                        continue block19;
                    }
                }
                break;
            }
        }
        if ('{' == c) {
            token = LEFT_BRACE.INSTANCE;
            this.expectName = true;
            return token;
        }
        if ('}' == c) {
            token = RIGHT_BRACE.INSTANCE;
            this.expectName = false;
            return token;
        }
        if ('[' == c) {
            token = LEFT_BRACKET.INSTANCE;
            this.expectName = false;
            return token;
        }
        if (']' == c) {
            token = RIGHT_BRACKET.INSTANCE;
            this.expectName = false;
            return token;
        }
        if (':' == c) {
            token = COLON.INSTANCE;
            this.expectName = false;
            return token;
        }
        if (',' == c) {
            token = COMMA.INSTANCE;
            this.expectName = true;
            return token;
        }
        if (this.isDone()) return EOF.INSTANCE;
        while (this.isValueLetter(c)) {
            currentValue.append(c);
            if (!this.isValueLetter(this.peekChar())) break;
            c = this.nextChar();
        }
        String string2 = currentValue.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentValue.toString()");
        String v = string2;
        if (this.NUMERIC.matcher(v).matches()) {
            Token token2;
            try {
                token2 = new Value<Integer>(Integer.parseInt(v));
                return token2;
            }
            catch (NumberFormatException e) {
                void var7_14;
                try {
                    Value<Long> value = new Value<Long>(Long.parseLong(v));
                }
                catch (NumberFormatException e2) {
                    Value<BigInteger> value = new Value<BigInteger>(new BigInteger(v));
                }
                token2 = (Token)var7_14;
            }
            return token2;
        }
        if (this.DOUBLE.matcher(v).matches()) {
            return new Value<Double>(Double.parseDouble(v));
        }
        String string3 = v;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        if (Intrinsics.areEqual((Object)"true", (Object)string5)) {
            return new Value<Boolean>(true);
        }
        string3 = v;
        bl = false;
        String string6 = string3;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        if (Intrinsics.areEqual((Object)"false", (Object)string7)) {
            return new Value<Boolean>(false);
        }
        if (!Intrinsics.areEqual((Object)v, (Object)"null")) throw (Throwable)new KlaxonException("Unexpected character at position " + (this.index - 1) + ": '" + c + "' (ASCII: " + c + ")'");
        return new Value<Object>(null);
    }

    private final void log(String s) {
        if (Debug.Companion.getVerbose()) {
            boolean bl = false;
            System.out.println((Object)s);
        }
    }

    public final boolean getLenient() {
        return this.lenient;
    }

    public Lexer(@NotNull Reader passedReader, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)passedReader, (String)"passedReader");
        this.lenient = lenient;
        this.line = 1;
        this.NUMERIC = Pattern.compile("[-]?[0-9]+");
        Pattern pattern = Pattern.compile(this.NUMERIC.toString() + "((\\.[0-9]+)?([eE][-+]?[0-9]+)?)");
        Intrinsics.checkNotNull((Object)pattern);
        this.DOUBLE = pattern;
        Reader reader = passedReader;
        int n = 8192;
        boolean bl = false;
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        int c = this.reader.read();
        this.next = c == -1 ? null : Character.valueOf((char)c);
        this.BOOLEAN_LETTERS = StringsKt.toSet((CharSequence)"falsetrue");
        this.NULL_LETTERS = StringsKt.toSet((CharSequence)"null");
    }

    public /* synthetic */ Lexer(Reader reader, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(reader, bl);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

