/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.tracker.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import tech.powerjob.worker.core.tracker.task.heavy.FrequentTaskTracker;
import tech.powerjob.worker.core.tracker.task.heavy.HeavyTaskTracker;

public class HeavyTaskTrackerManager {
    private static final Map<Long, HeavyTaskTracker> INSTANCE_ID_2_TASK_TRACKER = Maps.newConcurrentMap();

    public static HeavyTaskTracker getTaskTracker(Long instanceId) {
        return INSTANCE_ID_2_TASK_TRACKER.get(instanceId);
    }

    public static HeavyTaskTracker removeTaskTracker(Long instanceId) {
        return INSTANCE_ID_2_TASK_TRACKER.remove(instanceId);
    }

    public static void atomicCreateTaskTracker(Long instanceId, Function<Long, HeavyTaskTracker> creator) {
        INSTANCE_ID_2_TASK_TRACKER.computeIfAbsent(instanceId, creator);
    }

    public static List<Long> getAllFrequentTaskTrackerKeys() {
        LinkedList keys = Lists.newLinkedList();
        INSTANCE_ID_2_TASK_TRACKER.forEach((key, tk) -> {
            if (tk instanceof FrequentTaskTracker) {
                keys.add(key);
            }
        });
        return keys;
    }

    public static int currentTaskTrackerSize() {
        return INSTANCE_ID_2_TASK_TRACKER.size();
    }
}

