/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.SupplierPlus;
import tech.powerjob.worker.common.constants.StoreStrategy;
import tech.powerjob.worker.common.constants.TaskStatus;
import tech.powerjob.worker.core.processor.TaskResult;
import tech.powerjob.worker.persistence.ConnectionFactory;
import tech.powerjob.worker.persistence.SimpleTaskQuery;
import tech.powerjob.worker.persistence.TaskDAO;
import tech.powerjob.worker.persistence.TaskDAOImpl;
import tech.powerjob.worker.persistence.TaskDO;

public class TaskPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(TaskPersistenceService.class);
    private final StoreStrategy strategy;
    private static final int RETRY_TIMES = 3;
    private static final long RETRY_INTERVAL_MS = 100L;
    private TaskDAO taskDAO;

    public TaskPersistenceService(StoreStrategy strategy) {
        this.strategy = strategy;
    }

    public void init() throws Exception {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.initDatasource(this.strategy);
        this.taskDAO = new TaskDAOImpl(connectionFactory);
        this.taskDAO.initTable();
    }

    public boolean save(TaskDO task) {
        try {
            return (Boolean)TaskPersistenceService.execute(() -> this.taskDAO.save(task));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] save task{} failed.", (Object)task, (Object)e);
            return false;
        }
    }

    public boolean batchSave(List<TaskDO> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return true;
        }
        try {
            return (Boolean)TaskPersistenceService.execute(() -> this.taskDAO.batchSave(tasks));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] batchSave tasks({}) failed.", tasks, (Object)e);
            return false;
        }
    }

    public boolean updateTask(Long instanceId, String taskId, TaskDO updateEntity) {
        try {
            updateEntity.setLastModifiedTime(System.currentTimeMillis());
            SimpleTaskQuery query = TaskPersistenceService.genKeyQuery(instanceId, taskId);
            return (Boolean)TaskPersistenceService.execute(() -> this.taskDAO.simpleUpdate(query, updateEntity));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateTask failed.", (Throwable)e);
            return false;
        }
    }

    public boolean updateTaskStatus(Long instanceId, String taskId, int status, long lastReportTime, String result) {
        try {
            return (Boolean)TaskPersistenceService.execute(() -> this.taskDAO.updateTaskStatus(instanceId, taskId, status, lastReportTime, result));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateTaskStatus failed.", (Throwable)e);
            return false;
        }
    }

    public boolean updateLostTasks(Long instanceId, List<String> addressList, boolean retry) {
        TaskDO updateEntity = new TaskDO();
        updateEntity.setLastModifiedTime(System.currentTimeMillis());
        if (retry) {
            updateEntity.setAddress("N/A");
            updateEntity.setStatus(TaskStatus.WAITING_DISPATCH.getValue());
        } else {
            updateEntity.setStatus(TaskStatus.WORKER_PROCESS_FAILED.getValue());
            updateEntity.setResult("maybe worker down");
        }
        SimpleTaskQuery query = new SimpleTaskQuery();
        query.setInstanceId(instanceId);
        String queryConditionFormat = "address in %s and status not in (%d, %d)";
        String queryCondition = String.format(queryConditionFormat, CommonUtils.getInStringCondition(addressList), TaskStatus.WORKER_PROCESS_FAILED.getValue(), TaskStatus.WORKER_PROCESS_SUCCESS.getValue());
        query.setQueryCondition(queryCondition);
        log.debug("[TaskPersistenceService] updateLostTasks-QUERY-SQL: {}", (Object)query.getQueryCondition());
        try {
            return (Boolean)TaskPersistenceService.execute(() -> this.taskDAO.simpleUpdate(query, updateEntity));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateLostTasks failed.", (Throwable)e);
            return false;
        }
    }

    public Optional<TaskDO> getLastTask(Long instanceId, Long subInstanceId) {
        try {
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setSubInstanceId(subInstanceId);
            query.setTaskName("OMS_LAST_TASK");
            return (Optional)TaskPersistenceService.execute(() -> {
                List<TaskDO> taskDOS = this.taskDAO.simpleQuery(query);
                if (CollectionUtils.isEmpty(taskDOS)) {
                    return Optional.empty();
                }
                return Optional.of(taskDOS.get(0));
            });
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] get last task for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Optional.empty();
        }
    }

    public List<TaskDO> getAllTask(Long instanceId, Long subInstanceId) {
        try {
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setSubInstanceId(subInstanceId);
            return (List)TaskPersistenceService.execute(() -> this.taskDAO.simpleQuery(query));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getAllTask for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Lists.newArrayList();
        }
    }

    public List<TaskDO> getAllUnFinishedTaskByAddress(Long instanceId, String address) {
        try {
            String condition = String.format("status not in (%d, %d)", TaskStatus.WORKER_PROCESS_SUCCESS.getValue(), TaskStatus.WORKER_PROCESS_FAILED.getValue());
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setAddress(address);
            query.setQueryCondition(condition);
            return (List)TaskPersistenceService.execute(() -> this.taskDAO.simpleQuery(query));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getAllTaskByAddress for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Lists.newArrayList();
        }
    }

    public List<TaskDO> getTaskByStatus(Long instanceId, TaskStatus status, int limit) {
        try {
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setStatus(status.getValue());
            query.setLimit(limit);
            return (List)TaskPersistenceService.execute(() -> this.taskDAO.simpleQuery(query));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskByStatus failed, params is instanceId={},status={}.", new Object[]{instanceId, status, e});
            return Lists.newArrayList();
        }
    }

    public Map<TaskStatus, Long> getTaskStatusStatistics(Long instanceId, Long subInstanceId) {
        try {
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setSubInstanceId(subInstanceId);
            query.setQueryContent("status, count(*) as num");
            query.setOtherCondition("GROUP BY status");
            return (Map)TaskPersistenceService.execute(() -> {
                List<Map<String, Object>> dbRES = this.taskDAO.simpleQueryPlus(query);
                HashMap result = Maps.newHashMap();
                dbRES.forEach(row -> {
                    int status = Integer.parseInt(String.valueOf(row.get("status")));
                    long num = Long.parseLong(String.valueOf(row.get("num")));
                    result.put(TaskStatus.of(status), num);
                });
                return result;
            });
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskStatusStatistics for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Maps.newHashMap();
        }
    }

    public List<TaskResult> getAllTaskResult(Long instanceId, Long subInstanceId) {
        try {
            return (List)TaskPersistenceService.execute(() -> this.taskDAO.getAllTaskResult(instanceId, subInstanceId));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskId2ResultMap for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Lists.newLinkedList();
        }
    }

    public Optional<TaskStatus> getTaskStatus(Long instanceId, String taskId) {
        try {
            SimpleTaskQuery query = TaskPersistenceService.genKeyQuery(instanceId, taskId);
            query.setQueryContent("status");
            return (Optional)TaskPersistenceService.execute(() -> {
                List<Map<String, Object>> rows = this.taskDAO.simpleQueryPlus(query);
                return Optional.of(TaskStatus.of((Integer)rows.get(0).get("status")));
            });
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskStatus failed, instanceId={},taskId={}.", new Object[]{instanceId, taskId, e});
            return Optional.empty();
        }
    }

    public Optional<TaskDO> getTask(Long instanceId, String taskId) {
        try {
            SimpleTaskQuery query = TaskPersistenceService.genKeyQuery(instanceId, taskId);
            return (Optional)TaskPersistenceService.execute(() -> {
                List<TaskDO> res = this.taskDAO.simpleQuery(query);
                if (CollectionUtils.isEmpty(res)) {
                    return Optional.empty();
                }
                return Optional.of(res.get(0));
            });
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTask failed, instanceId={},taskId={}.", new Object[]{instanceId, taskId, e});
            return Optional.empty();
        }
    }

    public boolean batchUpdateTaskStatus(Long instanceId, List<String> taskIds, TaskStatus status, String result) {
        try {
            return (Boolean)TaskPersistenceService.execute(() -> {
                SimpleTaskQuery query = new SimpleTaskQuery();
                query.setInstanceId(instanceId);
                query.setQueryCondition(String.format(" task_id in %s ", CommonUtils.getInStringCondition((Collection)taskIds)));
                TaskDO updateEntity = new TaskDO();
                updateEntity.setStatus(status.getValue());
                updateEntity.setResult(result);
                return this.taskDAO.simpleUpdate(query, updateEntity);
            });
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateTaskStatus failed, instanceId={},taskIds={},status={},result={}.", new Object[]{instanceId, taskIds, status, result, e});
            return false;
        }
    }

    public boolean deleteAllTasks(Long instanceId) {
        try {
            SimpleTaskQuery condition = new SimpleTaskQuery();
            condition.setInstanceId(instanceId);
            return (Boolean)TaskPersistenceService.execute(() -> this.taskDAO.simpleDelete(condition));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] deleteAllTasks failed, instanceId={}.", (Object)instanceId, (Object)e);
            return false;
        }
    }

    public boolean deleteAllSubInstanceTasks(Long instanceId, Long subInstanceId) {
        try {
            SimpleTaskQuery condition = new SimpleTaskQuery();
            condition.setInstanceId(instanceId);
            condition.setSubInstanceId(subInstanceId);
            return (Boolean)TaskPersistenceService.execute(() -> this.taskDAO.simpleDelete(condition));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] deleteAllTasks failed, instanceId={}.", (Object)instanceId, (Object)e);
            return false;
        }
    }

    public List<TaskDO> listAll() {
        try {
            return (List)TaskPersistenceService.execute(() -> {
                SimpleTaskQuery query = new SimpleTaskQuery();
                query.setQueryCondition("1 = 1");
                return this.taskDAO.simpleQuery(query);
            });
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] listAll failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static SimpleTaskQuery genKeyQuery(Long instanceId, String taskId) {
        SimpleTaskQuery condition = new SimpleTaskQuery();
        condition.setInstanceId(instanceId);
        condition.setTaskId(taskId);
        return condition;
    }

    private static <T> T execute(SupplierPlus<T> executor) throws Exception {
        return (T)CommonUtils.executeWithRetry(executor, (int)3, (long)100L);
    }
}

