/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.log;

import org.apache.commons.lang3.StringUtils;
import tech.powerjob.common.enums.LogType;
import tech.powerjob.common.model.LogConfig;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.log.OmsLogger;
import tech.powerjob.worker.log.impl.OmsLocalLogger;
import tech.powerjob.worker.log.impl.OmsNullLogger;
import tech.powerjob.worker.log.impl.OmsServerLogger;
import tech.powerjob.worker.log.impl.OmsStdOutLogger;

public class OmsLoggerFactory {
    public static OmsLogger build(Long instanceId, String logConfig, WorkerRuntime workerRuntime) {
        LogConfig cfg;
        if (StringUtils.isEmpty((CharSequence)logConfig)) {
            cfg = new LogConfig();
        } else {
            try {
                cfg = (LogConfig)JsonUtils.parseObject((String)logConfig, LogConfig.class);
            }
            catch (Exception ignore) {
                cfg = new LogConfig();
            }
        }
        switch (LogType.of((Integer)cfg.getType())) {
            case LOCAL: {
                return new OmsLocalLogger(cfg);
            }
            case STDOUT: {
                return new OmsStdOutLogger(cfg);
            }
            case NULL: {
                return new OmsNullLogger();
            }
        }
        return new OmsServerLogger(cfg, instanceId, workerRuntime.getOmsLogHandler());
    }
}

