/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.tracker.task.light;

import akka.actor.ActorSelection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.request.ServerScheduleJobReq;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.constants.TaskStatus;
import tech.powerjob.worker.common.utils.AkkaUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.ProcessorInfo;
import tech.powerjob.worker.core.processor.ProcessorLoader;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.WorkflowContext;
import tech.powerjob.worker.core.tracker.manager.LightTaskTrackerManager;
import tech.powerjob.worker.core.tracker.task.TaskTracker;
import tech.powerjob.worker.log.OmsLoggerFactory;

public class LightTaskTracker
extends TaskTracker {
    private static final Logger log = LoggerFactory.getLogger(LightTaskTracker.class);
    private final ScheduledFuture<?> statusReportScheduledFuture;
    private final ScheduledFuture<?> timeoutCheckScheduledFuture;
    private final Future<ProcessResult> processFuture;
    private final AtomicReference<Thread> executeThread;
    private final ProcessorInfo processorInfo;
    private final TaskContext taskContext;
    private TaskStatus status;
    private Long taskStartTime;
    private Long taskEndTime;
    private ProcessResult result;
    private final AtomicBoolean timeoutFlag = new AtomicBoolean(false);
    protected final AtomicBoolean stopFlag = new AtomicBoolean(false);
    protected final AtomicBoolean destroyFlag = new AtomicBoolean(false);

    public LightTaskTracker(ServerScheduleJobReq req, WorkerRuntime workerRuntime) {
        super(req, workerRuntime);
        try {
            this.taskContext = this.constructTaskContext(req, workerRuntime);
            this.status = TaskStatus.WORKER_RECEIVED;
            this.processorInfo = ProcessorLoader.loadProcessor(workerRuntime, req.getProcessorType(), req.getProcessorInfo());
            this.executeThread = new AtomicReference();
            long delay = (long)Integer.parseInt(System.getProperty("powerjob.worker.status-check.normal.period", "15")) * 1000L;
            long initDelay = RandomUtils.nextInt((int)5000, (int)10000);
            this.statusReportScheduledFuture = workerRuntime.getExecutorManager().getLightweightTaskStatusCheckExecutor().scheduleWithFixedDelay(this::checkAndReportStatus, initDelay, delay, TimeUnit.MILLISECONDS);
            this.timeoutCheckScheduledFuture = this.instanceInfo.getInstanceTimeoutMS() != Integer.MAX_VALUE ? (this.instanceInfo.getInstanceTimeoutMS() < 1000L ? workerRuntime.getExecutorManager().getLightweightTaskStatusCheckExecutor().scheduleAtFixedRate(this::timeoutCheck, this.instanceInfo.getInstanceTimeoutMS(), this.instanceInfo.getInstanceTimeoutMS() / 10L, TimeUnit.MILLISECONDS) : workerRuntime.getExecutorManager().getLightweightTaskStatusCheckExecutor().scheduleAtFixedRate(this::timeoutCheck, this.instanceInfo.getInstanceTimeoutMS(), 1000L, TimeUnit.MILLISECONDS)) : null;
            this.processFuture = workerRuntime.getExecutorManager().getLightweightTaskExecutorService().submit(this::processTask);
        }
        catch (Exception e) {
            log.warn("[TaskTracker-{}] fail to create TaskTracker for req:{} ", (Object)this.instanceId, (Object)req);
            this.destroy();
            throw e;
        }
    }

    public static LightTaskTracker create(ServerScheduleJobReq req, WorkerRuntime workerRuntime) {
        try {
            return new LightTaskTracker(req, workerRuntime);
        }
        catch (Exception e) {
            LightTaskTracker.reportCreateErrorToServer(req, workerRuntime, e);
            return null;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyFlag.compareAndSet(false, true)) {
            log.warn("[TaskTracker-{}] This TaskTracker has been destroyed!", (Object)this.instanceId);
            return;
        }
        if (this.statusReportScheduledFuture != null) {
            this.statusReportScheduledFuture.cancel(true);
        }
        if (this.timeoutCheckScheduledFuture != null) {
            this.timeoutCheckScheduledFuture.cancel(true);
        }
        if (this.processFuture != null) {
            this.processFuture.cancel(true);
        }
        LightTaskTrackerManager.removeTaskTracker(this.instanceId);
        log.warn("[TaskTracker-{}] remove TaskTracker,task status {},start time:{},end time:{},real cost:{},total time:{}", new Object[]{this.instanceId, this.status, this.taskStartTime, this.taskEndTime, this.taskEndTime != null ? Long.valueOf(this.taskEndTime - this.taskStartTime) : "unknown", System.currentTimeMillis() - this.createTime});
    }

    @Override
    public void stopTask() {
        if (this.finished.get()) {
            log.warn("[TaskTracker-{}] fail to stop task,task is finished!result:{}", (Object)this.instanceId, (Object)this.result);
            return;
        }
        if (!this.stopFlag.compareAndSet(false, true)) {
            log.warn("[TaskTracker-{}] task has been mark as stopped,ignore this request!", (Object)this.instanceId);
            return;
        }
        if (this.status == TaskStatus.WORKER_RECEIVED) {
            log.warn("[TaskTracker-{}] task is not started,destroy this taskTracker directly!", (Object)this.instanceId);
            this.destroy();
            return;
        }
        if (this.processFuture != null) {
            log.info("[TaskTracker-{}] try to interrupt task!", (Object)this.instanceId);
            this.processFuture.cancel(true);
        }
    }

    @Override
    public InstanceDetail fetchRunningStatus() {
        InstanceDetail detail = new InstanceDetail();
        detail.setActualTriggerTime(Long.valueOf(this.createTime));
        detail.setStatus(Integer.valueOf(InstanceStatus.RUNNING.getV()));
        detail.setTaskTrackerAddress(this.workerRuntime.getWorkerAddress());
        InstanceDetail.TaskDetail taskDetail = new InstanceDetail.TaskDetail();
        taskDetail.setSucceedTaskNum(0L);
        taskDetail.setFailedTaskNum(0L);
        taskDetail.setTotalTaskNum(1L);
        detail.setTaskDetail(taskDetail);
        return detail;
    }

    private ProcessResult processTask() {
        this.executeThread.set(Thread.currentThread());
        this.taskStartTime = System.currentTimeMillis();
        this.status = TaskStatus.WORKER_PROCESSING;
        ProcessResult res = null;
        do {
            Thread.currentThread().setContextClassLoader(this.processorInfo.getClassLoader());
            if (res != null && !res.isSuccess()) {
                this.taskContext.setCurrentRetryTimes(this.taskContext.getCurrentRetryTimes() + 1);
                log.warn("[TaskTracker-{}] process failed, TaskTracker will have a retry,current retryTimes : {}", (Object)this.instanceId, (Object)this.taskContext.getCurrentRetryTimes());
            }
            try {
                res = this.processorInfo.getBasicProcessor().process(this.taskContext);
            }
            catch (InterruptedException e) {
                log.warn("[TaskTracker-{}] task has been interrupted !", (Object)this.instanceId, (Object)e);
                Thread.currentThread().interrupt();
                res = this.timeoutFlag.get() ? new ProcessResult(false, "instance execute timeout,interrupted success") : (this.stopFlag.get() ? new ProcessResult(false, "user stop instance,interrupted success") : new ProcessResult(false, e.toString()));
            }
            catch (Exception e) {
                log.warn("[TaskTracker-{}] process failed !", (Object)this.instanceId, (Object)e);
                res = new ProcessResult(false, e.toString());
            }
            if (res != null) continue;
            log.warn("[TaskTracker-{}] processor return null !", (Object)this.instanceId);
            res = new ProcessResult(false, "Processor return null");
        } while (!res.isSuccess() && this.taskContext.getCurrentRetryTimes() < this.taskContext.getMaxRetryTimes() && !this.timeoutFlag.get() && !this.stopFlag.get());
        this.executeThread.set(null);
        this.taskEndTime = System.currentTimeMillis();
        this.finished.set(true);
        this.result = res;
        TaskStatus taskStatus = this.status = this.result.isSuccess() ? TaskStatus.WORKER_PROCESS_SUCCESS : TaskStatus.WORKER_PROCESS_FAILED;
        if (this.timeoutCheckScheduledFuture != null) {
            this.timeoutCheckScheduledFuture.cancel(true);
        }
        log.info("[TaskTracker-{}] task complete ! create time:{},queue time:{},use time:{},result:{}", new Object[]{this.instanceId, this.createTime, this.taskStartTime - this.createTime, System.currentTimeMillis() - this.taskStartTime, this.result});
        this.checkAndReportStatus();
        return this.result;
    }

    private synchronized void checkAndReportStatus() {
        if (this.destroyFlag.get()) {
            log.info("[TaskTracker-{}] has been destroyed,final status is {},needn't to report status!", (Object)this.instanceId, (Object)this.status);
            return;
        }
        String serverPath = AkkaUtils.getServerActorPath(this.workerRuntime.getServerDiscoveryService().getCurrentServerAddress());
        ActorSelection serverActor = this.workerRuntime.getActorSystem().actorSelection(serverPath);
        TaskTrackerReportInstanceStatusReq reportInstanceStatusReq = new TaskTrackerReportInstanceStatusReq();
        reportInstanceStatusReq.setAppId(this.workerRuntime.getAppId());
        reportInstanceStatusReq.setJobId(this.instanceInfo.getJobId());
        reportInstanceStatusReq.setInstanceId(Long.valueOf(this.instanceId));
        reportInstanceStatusReq.setWfInstanceId(this.instanceInfo.getWfInstanceId());
        reportInstanceStatusReq.setTotalTaskNum(1L);
        reportInstanceStatusReq.setReportTime(System.currentTimeMillis());
        reportInstanceStatusReq.setStartTime(this.createTime);
        reportInstanceStatusReq.setSourceAddress(this.workerRuntime.getWorkerAddress());
        reportInstanceStatusReq.setSucceedTaskNum(0L);
        reportInstanceStatusReq.setFailedTaskNum(0L);
        if (this.stopFlag.get()) {
            if (this.finished.get()) {
                this.destroy();
                return;
            }
            Thread workerThread = this.executeThread.get();
            if (!this.finished.get() && workerThread != null) {
                try {
                    if (this.tryForceStopThread(workerThread)) {
                        this.finished.set(true);
                        this.taskEndTime = System.currentTimeMillis();
                        this.result = new ProcessResult(false, "user stop instance,force stop success");
                        log.warn("[TaskTracker-{}] task need stop, force stop thread {} success!", (Object)this.instanceId, (Object)workerThread.getName());
                        this.destroy();
                        return;
                    }
                }
                catch (Exception e) {
                    log.warn("[TaskTracker-{}] task need stop,fail to stop thread {}", new Object[]{this.instanceId, workerThread.getName(), e});
                }
            }
        }
        if (this.finished.get()) {
            if (this.result.isSuccess()) {
                reportInstanceStatusReq.setSucceedTaskNum(1L);
                reportInstanceStatusReq.setInstanceStatus(InstanceStatus.SUCCEED.getV());
            } else {
                reportInstanceStatusReq.setFailedTaskNum(1L);
                reportInstanceStatusReq.setInstanceStatus(InstanceStatus.FAILED.getV());
            }
            if (this.taskContext.getWorkflowContext().getWfInstanceId() != null) {
                reportInstanceStatusReq.setAppendedWfContext(this.taskContext.getWorkflowContext().getAppendedContextData());
            }
            reportInstanceStatusReq.setResult(this.suit(this.result.getMsg()));
            reportInstanceStatusReq.setEndTime(this.taskEndTime);
            reportInstanceStatusReq.setReportTime(System.currentTimeMillis() + 1L);
            this.reportFinalStatusThenDestroy(serverActor, reportInstanceStatusReq);
            return;
        }
        reportInstanceStatusReq.setInstanceStatus(InstanceStatus.RUNNING.getV());
        log.info("[TaskTracker-{}] report status({}) success,real status is {}", new Object[]{this.instanceId, reportInstanceStatusReq, this.status});
        serverActor.tell((Object)reportInstanceStatusReq, null);
    }

    private void timeoutCheck() {
        if (this.taskStartTime == null || System.currentTimeMillis() - this.taskStartTime < this.instanceInfo.getInstanceTimeoutMS()) {
            return;
        }
        if (this.finished.get() && this.result != null) {
            this.timeoutCheckScheduledFuture.cancel(true);
            return;
        }
        if (this.timeoutFlag.compareAndSet(false, true)) {
            log.warn("[TaskTracker-{}] task timeout,taskStarTime:{},currentTime:{},runningTimeLimit:{}, try to interrupt it.", new Object[]{this.instanceId, this.taskStartTime, System.currentTimeMillis(), this.instanceInfo.getInstanceTimeoutMS()});
            this.processFuture.cancel(true);
            return;
        }
        if (this.finished.get()) {
            log.warn("[TaskTracker-{}] task timeout,taskStarTime:{},endTime:{}, interrupt success.", new Object[]{this.instanceId, this.taskStartTime, this.taskEndTime});
            return;
        }
        Thread workerThread = this.executeThread.get();
        if (workerThread == null) {
            return;
        }
        try {
            if (this.tryForceStopThread(workerThread)) {
                this.finished.set(true);
                this.taskEndTime = System.currentTimeMillis();
                this.result = new ProcessResult(false, "instance execute timeout,force stop success");
                log.warn("[TaskTracker-{}] task timeout, force stop thread {} success!", (Object)this.instanceId, (Object)workerThread.getName());
            }
        }
        catch (Exception e) {
            log.warn("[TaskTracker-{}] task timeout,fail to stop thread {}", new Object[]{this.instanceId, workerThread.getName(), e});
        }
    }

    private TaskContext constructTaskContext(ServerScheduleJobReq req, WorkerRuntime workerRuntime) {
        TaskContext context = new TaskContext();
        context.setTaskId(req.getJobId() + "#" + req.getInstanceId());
        context.setJobId(req.getJobId());
        context.setJobParams(req.getJobParams());
        context.setInstanceId(req.getInstanceId());
        context.setInstanceParams(req.getInstanceParams());
        context.setWorkflowContext(new WorkflowContext(req.getWfInstanceId(), req.getInstanceParams()));
        context.setOmsLogger(OmsLoggerFactory.build(req.getInstanceId(), req.getLogConfig(), workerRuntime));
        context.setTaskName("OMS_ROOT_TASK");
        context.setMaxRetryTimes(req.getTaskRetryNum());
        context.setCurrentRetryTimes(0);
        context.setUserContext(workerRuntime.getWorkerConfig().getUserContext());
        return context;
    }

    private String suit(String result) {
        if (StringUtils.isEmpty((CharSequence)result)) {
            return "";
        }
        int maxLength = this.workerRuntime.getWorkerConfig().getMaxResultLength();
        if (result.length() <= maxLength) {
            return result;
        }
        log.warn("[TaskTracker-{}] task's result is too large({}>{}), a part will be discarded.", new Object[]{this.instanceId, result.length(), maxLength});
        return result.substring(0, maxLength).concat("...");
    }

    private boolean tryForceStopThread(Thread thread) {
        String threadName = thread.getName();
        String allowStopThread = System.getProperty("powerjob.worker.allowed-force-stop-thread");
        if (!StringUtils.equalsIgnoreCase((CharSequence)allowStopThread, (CharSequence)Boolean.TRUE.toString())) {
            log.warn("[TaskTracker-{}] PowerJob not allowed to force stop a thread by config", (Object)this.instanceId);
            return false;
        }
        log.warn("[TaskTracker-{}] fail to interrupt the thread[{}], try to force stop.", (Object)this.instanceId, (Object)threadName);
        try {
            thread.stop();
            return true;
        }
        catch (Throwable t) {
            log.warn("[TaskTracker-{}] stop thread[{}] failed, msg: {}", new Object[]{this.instanceId, threadName, t.getMessage()});
            return false;
        }
    }
}

