/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.tracker.task.heavy;

import akka.actor.ActorSelection;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import tech.powerjob.common.enums.ExecuteType;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.AlarmConfig;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.request.ServerScheduleJobReq;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.constants.TaskStatus;
import tech.powerjob.worker.common.utils.AkkaUtils;
import tech.powerjob.worker.common.utils.LRUCache;
import tech.powerjob.worker.core.tracker.task.heavy.HeavyTaskTracker;
import tech.powerjob.worker.persistence.TaskDO;

public class FrequentTaskTracker
extends HeavyTaskTracker {
    private static final Logger log = LoggerFactory.getLogger(FrequentTaskTracker.class);
    private TimeExpressionType timeExpressionType;
    private long timeParams;
    private int maxInstanceNum;
    private AtomicLong triggerTimes;
    private AtomicLong succeedTimes;
    private AtomicLong failedTimes;
    private Launcher launcher;
    private LRUCache<Long, SubInstanceInfo> recentSubInstanceInfo;
    private Map<Long, SubInstanceTimeHolder> subInstanceId2TimeHolder;
    private AlertManager alertManager;
    private static final int HISTORY_SIZE = 10;
    private static final String LAST_TASK_ID_PREFIX = "L";
    private static final int MIN_INTERVAL = 50;

    protected FrequentTaskTracker(ServerScheduleJobReq req, WorkerRuntime workerRuntime) {
        super(req, workerRuntime);
    }

    @Override
    protected void initTaskTracker(ServerScheduleJobReq req) {
        this.timeExpressionType = TimeExpressionType.valueOf((String)req.getTimeExpressionType());
        this.timeParams = Long.parseLong(req.getTimeExpression());
        this.maxInstanceNum = req.getMaxInstanceNum();
        this.triggerTimes = new AtomicLong(0L);
        this.succeedTimes = new AtomicLong(0L);
        this.failedTimes = new AtomicLong(0L);
        this.recentSubInstanceInfo = new LRUCache(10);
        this.subInstanceId2TimeHolder = Maps.newConcurrentMap();
        String poolName = String.format("ftttp-%d", req.getInstanceId()) + "-%d";
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat(poolName).build();
        this.scheduledPool = Executors.newScheduledThreadPool(4, factory);
        this.alertManager = this.constructAlertManager(req);
        this.launcher = new Launcher();
        if (this.timeExpressionType == TimeExpressionType.FIXED_RATE) {
            if (this.timeParams < 50L) {
                throw new PowerJobException("time interval too small, please set the timeExpressionInfo >= 1000");
            }
            this.scheduledPool.scheduleAtFixedRate(this.launcher, 1L, this.timeParams, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledPool.schedule(this.launcher, 0L, TimeUnit.MILLISECONDS);
        }
        this.scheduledPool.scheduleWithFixedDelay(new HeavyTaskTracker.Dispatcher(this), 1L, 2L, TimeUnit.SECONDS);
        this.scheduledPool.scheduleWithFixedDelay(new Checker(), 5000L, Math.min(Math.max(this.timeParams, 5000L), 15000L), TimeUnit.MILLISECONDS);
        this.scheduledPool.scheduleAtFixedRate(new HeavyTaskTracker.WorkerDetector(this), 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public InstanceDetail fetchRunningStatus() {
        InstanceDetail detail = new InstanceDetail();
        detail.setActualTriggerTime(Long.valueOf(this.createTime));
        detail.setStatus(Integer.valueOf(InstanceStatus.RUNNING.getV()));
        detail.setTaskTrackerAddress(this.workerRuntime.getWorkerAddress());
        LinkedList history = Lists.newLinkedList();
        this.recentSubInstanceInfo.forEach((subId, subInstanceInfo) -> {
            InstanceDetail.SubInstanceDetail subDetail = new InstanceDetail.SubInstanceDetail();
            BeanUtils.copyProperties((Object)subInstanceInfo, (Object)subDetail);
            InstanceStatus status = InstanceStatus.of((int)((SubInstanceInfo)subInstanceInfo).status);
            subDetail.setStatus(status.getV());
            subDetail.setSubInstanceId(subId.longValue());
            history.add(subDetail);
        });
        history.sort((o1, o2) -> (int)(o2.getSubInstanceId() - o1.getSubInstanceId()));
        detail.setSubInstanceDetails((List)history);
        return detail;
    }

    private void processFinishedSubInstance(long subInstanceId, boolean success, String result) {
        long currentTime = System.currentTimeMillis();
        if (success) {
            this.succeedTimes.incrementAndGet();
        } else {
            this.failedTimes.incrementAndGet();
            this.alertManager.update(currentTime, result);
        }
        this.subInstanceId2TimeHolder.remove(subInstanceId);
        SubInstanceInfo subInstanceInfo = this.recentSubInstanceInfo.get(subInstanceId);
        if (subInstanceInfo != null) {
            subInstanceInfo.status = success ? InstanceStatus.SUCCEED.getV() : InstanceStatus.FAILED.getV();
            subInstanceInfo.result = result;
            subInstanceInfo.finishedTime = currentTime;
        }
        this.taskPersistenceService.deleteAllSubInstanceTasks(this.instanceId, subInstanceId);
        if (this.timeExpressionType == TimeExpressionType.FIXED_DELAY) {
            this.scheduledPool.schedule(this.launcher, this.timeParams, TimeUnit.MILLISECONDS);
        }
    }

    private AlertManager constructAlertManager(ServerScheduleJobReq req) {
        long rate = Long.parseLong(req.getTimeExpression());
        if (!StringUtils.isEmpty((CharSequence)req.getAlarmConfig())) {
            try {
                log.debug("[FQTaskTracker-{}] alert config:{}", (Object)this.instanceId, (Object)req.getAlarmConfig());
                AlarmConfig alarmConfig = (AlarmConfig)JsonUtils.parseObject((String)req.getAlarmConfig(), AlarmConfig.class);
                return new AlertManager(alarmConfig);
            }
            catch (JsonProcessingException alarmConfig) {
                // empty catch block
            }
        }
        int statisticWindowLen = Math.max((int)(2L * rate / 1000L), 1);
        return new AlertManager(new AlarmConfig(Integer.valueOf(1), Integer.valueOf(statisticWindowLen), Integer.valueOf(300)));
    }

    private static class SubInstanceTimeHolder {
        private long startTime;

        private SubInstanceTimeHolder() {
        }
    }

    private static class SubInstanceInfo {
        private int status;
        private long startTime;
        private long finishedTime;
        private String result;

        public int getStatus() {
            return this.status;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinishedTime() {
            return this.finishedTime;
        }

        public String getResult() {
            return this.result;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setFinishedTime(long finishedTime) {
            this.finishedTime = finishedTime;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubInstanceInfo)) {
                return false;
            }
            SubInstanceInfo other = (SubInstanceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            if (this.getFinishedTime() != other.getFinishedTime()) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubInstanceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            long $finishedTime = this.getFinishedTime();
            result = result * 59 + (int)($finishedTime >>> 32 ^ $finishedTime);
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "FrequentTaskTracker.SubInstanceInfo(status=" + this.getStatus() + ", startTime=" + this.getStartTime() + ", finishedTime=" + this.getFinishedTime() + ", result=" + this.getResult() + ")";
        }
    }

    private class AlertManager {
        private final LinkedList<Long> failedRecordList = new LinkedList();
        private final AlarmConfig config;
        private long alarmActiveTime = 0L;
        private String content;
        private boolean active;

        public AlertManager(AlarmConfig config) {
            log.info("[FQTaskTracker-{}] create alert manager,alertThreshold:{},statisticWindowLen:{} s,silenceWindowLen:{} s", new Object[]{FrequentTaskTracker.this.instanceId, config.getAlertThreshold(), config.getStatisticWindowLen(), config.getSilenceWindowLen()});
            this.config = config;
        }

        public synchronized void update(long currentTime, String result) {
            log.debug("[FQTaskTracker-{}] update alert statistic info,currentTime:{}", (Object)FrequentTaskTracker.this.instanceId, (Object)currentTime);
            if (currentTime < this.alarmActiveTime + (long)(this.config.getSilenceWindowLen() * 1000)) {
                return;
            }
            long minTime = currentTime - (long)(this.config.getStatisticWindowLen() * 1000);
            while (!this.failedRecordList.isEmpty() && this.failedRecordList.peekFirst() < minTime) {
                this.failedRecordList.removeFirst();
            }
            this.failedRecordList.add(currentTime);
            if (this.failedRecordList.size() >= this.config.getAlertThreshold()) {
                this.active = true;
                this.alarmActiveTime = currentTime;
                this.content = result;
            }
        }

        public synchronized boolean alert() {
            if (this.active) {
                this.active = false;
                return true;
            }
            return false;
        }

        public String getAlertContent() {
            return this.content;
        }
    }

    private class Checker
    implements Runnable {
        private Checker() {
        }

        @Override
        public void run() {
            if (FrequentTaskTracker.this.finished.get()) {
                return;
            }
            try {
                this.checkStatus();
                this.reportStatus();
            }
            catch (Exception e) {
                log.warn("[FQTaskTracker-{}] check and report status failed.", (Object)FrequentTaskTracker.this.instanceId, (Object)e);
            }
        }

        private void checkStatus() {
            Stopwatch stopwatch = Stopwatch.createStarted();
            List<String> disconnectedPTs = FrequentTaskTracker.this.ptStatusHolder.getAllDisconnectedProcessorTrackers();
            if (!disconnectedPTs.isEmpty()) {
                log.warn("[FQTaskTracker-{}] some ProcessorTracker disconnected from TaskTracker,their address is {}.", (Object)FrequentTaskTracker.this.instanceId, disconnectedPTs);
                if (FrequentTaskTracker.this.taskPersistenceService.updateLostTasks(FrequentTaskTracker.this.instanceId, disconnectedPTs, false)) {
                    FrequentTaskTracker.this.ptStatusHolder.remove(disconnectedPTs);
                    log.warn("[FQTaskTracker-{}] removed these ProcessorTracker from StatusHolder: {}", (Object)FrequentTaskTracker.this.instanceId, disconnectedPTs);
                }
            }
            ExecuteType executeType = ExecuteType.valueOf((String)FrequentTaskTracker.this.instanceInfo.getExecuteType());
            long instanceTimeoutMS = FrequentTaskTracker.this.instanceInfo.getInstanceTimeoutMS();
            long nowTS = System.currentTimeMillis();
            Iterator iterator = FrequentTaskTracker.this.subInstanceId2TimeHolder.entrySet().iterator();
            block4: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Long subInstanceId = (Long)entry.getKey();
                SubInstanceTimeHolder timeHolder = (SubInstanceTimeHolder)entry.getValue();
                long executeTimeout = nowTS - timeHolder.startTime;
                if (executeTimeout > instanceTimeoutMS) {
                    this.onFinished(subInstanceId, false, "RUNNING_TIMEOUT", iterator);
                    continue;
                }
                HeavyTaskTracker.InstanceStatisticsHolder holder = FrequentTaskTracker.this.getInstanceStatisticsHolder(subInstanceId);
                long finishedNum = holder.succeedNum + holder.failedNum;
                long unfinishedNum = holder.waitingDispatchNum + holder.workerUnreceivedNum + holder.receivedNum + holder.runningNum;
                if (unfinishedNum != 0L) continue;
                if (finishedNum == 0L) {
                    this.onFinished(subInstanceId, false, "LAUNCH_FAILED", iterator);
                    continue;
                }
                switch (executeType) {
                    case STANDALONE: {
                        TaskDO resultTask = FrequentTaskTracker.this.taskPersistenceService.getAllTask(FrequentTaskTracker.this.instanceId, subInstanceId).get(0);
                        boolean success = resultTask.getStatus().intValue() == TaskStatus.WORKER_PROCESS_SUCCESS.getValue();
                        this.onFinished(subInstanceId, success, resultTask.getResult(), iterator);
                        continue block4;
                    }
                    case MAP: {
                        String result = String.format("total:%d,succeed:%d,failed:%d", holder.getTotalTaskNum(), holder.succeedNum, holder.failedNum);
                        this.onFinished(subInstanceId, holder.failedNum == 0L, result, iterator);
                        continue block4;
                    }
                }
                Optional<TaskDO> lastTaskOptional = FrequentTaskTracker.this.taskPersistenceService.getLastTask(FrequentTaskTracker.this.instanceId, subInstanceId);
                if (lastTaskOptional.isPresent()) {
                    TaskStatus lastTaskStatus = TaskStatus.of(lastTaskOptional.get().getStatus());
                    if (lastTaskStatus != TaskStatus.WORKER_PROCESS_SUCCESS && lastTaskStatus != TaskStatus.WORKER_PROCESS_FAILED) continue;
                    this.onFinished(subInstanceId, lastTaskStatus == TaskStatus.WORKER_PROCESS_SUCCESS, lastTaskOptional.get().getResult(), iterator);
                    continue;
                }
                TaskDO newLastTask = new TaskDO();
                newLastTask.setTaskName("OMS_LAST_TASK");
                newLastTask.setTaskId(FrequentTaskTracker.LAST_TASK_ID_PREFIX + subInstanceId);
                newLastTask.setSubInstanceId(subInstanceId);
                newLastTask.setAddress(FrequentTaskTracker.this.workerRuntime.getWorkerAddress());
                FrequentTaskTracker.this.submitTask(Lists.newArrayList((Object[])new TaskDO[]{newLastTask}));
            }
            log.debug("[FQTaskTracker-{}] check status using {}.", (Object)FrequentTaskTracker.this.instanceId, (Object)stopwatch);
        }

        private void reportStatus() {
            String serverPath;
            String currentServerAddress = FrequentTaskTracker.this.workerRuntime.getServerDiscoveryService().getCurrentServerAddress();
            if (StringUtils.isEmpty((CharSequence)currentServerAddress)) {
                return;
            }
            TaskTrackerReportInstanceStatusReq req = new TaskTrackerReportInstanceStatusReq();
            req.setAppId(FrequentTaskTracker.this.workerRuntime.getAppId());
            req.setJobId(FrequentTaskTracker.this.instanceInfo.getJobId());
            req.setInstanceId(Long.valueOf(FrequentTaskTracker.this.instanceId));
            req.setReportTime(System.currentTimeMillis());
            req.setStartTime(FrequentTaskTracker.this.createTime);
            req.setInstanceStatus(InstanceStatus.RUNNING.getV());
            req.setTotalTaskNum(FrequentTaskTracker.this.triggerTimes.get());
            req.setSucceedTaskNum(FrequentTaskTracker.this.succeedTimes.get());
            req.setFailedTaskNum(FrequentTaskTracker.this.failedTimes.get());
            req.setSourceAddress(FrequentTaskTracker.this.workerRuntime.getWorkerAddress());
            if (FrequentTaskTracker.this.alertManager.alert()) {
                req.setNeedAlert(true);
                req.setAlertContent(FrequentTaskTracker.this.alertManager.getAlertContent());
                log.warn("[FQTaskTracker-{}] report alert req,time:{}", (Object)FrequentTaskTracker.this.instanceId, (Object)req.getReportTime());
            }
            if (StringUtils.isEmpty((CharSequence)(serverPath = AkkaUtils.getServerActorPath(currentServerAddress)))) {
                return;
            }
            ActorSelection serverActor = FrequentTaskTracker.this.workerRuntime.getActorSystem().actorSelection(serverPath);
            serverActor.tell((Object)req, null);
        }

        private void onFinished(Long subInstanceId, boolean success, String result, Iterator<?> iterator) {
            iterator.remove();
            FrequentTaskTracker.this.processFinishedSubInstance(subInstanceId, success, result);
        }
    }

    private class Launcher
    implements Runnable {
        private Launcher() {
        }

        public void innerRun() {
            if (FrequentTaskTracker.this.finished.get()) {
                return;
            }
            Long subInstanceId = FrequentTaskTracker.this.triggerTimes.incrementAndGet();
            SubInstanceInfo subInstanceInfo = new SubInstanceInfo();
            subInstanceInfo.status = TaskStatus.DISPATCH_SUCCESS_WORKER_UNCHECK.getValue();
            subInstanceInfo.startTime = System.currentTimeMillis();
            FrequentTaskTracker.this.recentSubInstanceInfo.put(subInstanceId, subInstanceInfo);
            String myAddress = FrequentTaskTracker.this.workerRuntime.getWorkerAddress();
            String taskId = String.valueOf(subInstanceId);
            TaskDO newRootTask = new TaskDO();
            newRootTask.setInstanceId(FrequentTaskTracker.this.instanceId);
            newRootTask.setSubInstanceId(subInstanceId);
            newRootTask.setTaskId(taskId);
            newRootTask.setStatus(TaskStatus.DISPATCH_SUCCESS_WORKER_UNCHECK.getValue());
            newRootTask.setFailedCnt(0);
            newRootTask.setAddress(myAddress);
            newRootTask.setTaskName("OMS_ROOT_TASK");
            newRootTask.setCreatedTime(System.currentTimeMillis());
            newRootTask.setLastModifiedTime(System.currentTimeMillis());
            newRootTask.setLastReportTime(-1L);
            if (FrequentTaskTracker.this.maxInstanceNum > 0 && FrequentTaskTracker.this.timeExpressionType == TimeExpressionType.FIXED_RATE && FrequentTaskTracker.this.subInstanceId2TimeHolder.size() >= FrequentTaskTracker.this.maxInstanceNum) {
                log.warn("[FQTaskTracker-{}] cancel to launch the subInstance({}) due to too much subInstance is running.", (Object)FrequentTaskTracker.this.instanceId, (Object)subInstanceId);
                FrequentTaskTracker.this.processFinishedSubInstance(subInstanceId, false, "TOO_MUCH_INSTANCE");
                return;
            }
            if (!FrequentTaskTracker.this.taskPersistenceService.save(newRootTask)) {
                log.error("[FQTaskTracker-{}] Launcher create new root task failed.", (Object)FrequentTaskTracker.this.instanceId);
                FrequentTaskTracker.this.processFinishedSubInstance(subInstanceId, false, "LAUNCH_FAILED");
                return;
            }
            SubInstanceTimeHolder timeHolder = new SubInstanceTimeHolder();
            timeHolder.startTime = System.currentTimeMillis();
            FrequentTaskTracker.this.subInstanceId2TimeHolder.put(subInstanceId, timeHolder);
            FrequentTaskTracker.this.dispatchTask(newRootTask, myAddress);
        }

        @Override
        public void run() {
            try {
                this.innerRun();
            }
            catch (Exception e) {
                log.error("[FQTaskTracker-{}] launch task failed.", (Object)FrequentTaskTracker.this.instanceId, (Object)e);
            }
        }
    }
}

