/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.tracker.task;

import akka.actor.ActorSelection;
import akka.pattern.Patterns;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.request.ServerScheduleJobReq;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.utils.AkkaUtils;
import tech.powerjob.worker.pojo.model.InstanceInfo;

public abstract class TaskTracker {
    private static final Logger log = LoggerFactory.getLogger(TaskTracker.class);
    protected final long createTime = System.currentTimeMillis();
    protected final long instanceId;
    protected final InstanceInfo instanceInfo;
    protected final Map<String, String> appendedWfContext;
    protected final WorkerRuntime workerRuntime;
    protected final AtomicBoolean finished;
    protected int reportFailedCnt = 0;
    protected static final int MAX_REPORT_FAILED_THRESHOLD = 5;

    protected TaskTracker(ServerScheduleJobReq req, WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
        this.instanceId = req.getInstanceId();
        this.instanceInfo = new InstanceInfo();
        BeanUtils.copyProperties((Object)req, (Object)this.instanceInfo);
        if (this.instanceInfo.getInstanceTimeoutMS() <= 0L) {
            this.instanceInfo.setInstanceTimeoutMS(Integer.MAX_VALUE);
        }
        this.appendedWfContext = req.getWfInstanceId() == null ? Collections.emptyMap() : Maps.newConcurrentMap();
        this.finished = new AtomicBoolean(false);
    }

    public abstract void destroy();

    public abstract void stopTask();

    public abstract InstanceDetail fetchRunningStatus();

    public static void reportCreateErrorToServer(ServerScheduleJobReq req, WorkerRuntime workerRuntime, Exception e) {
        log.warn("[TaskTracker-{}] create TaskTracker from request({}) failed.", new Object[]{req.getInstanceId(), req, e});
        TaskTrackerReportInstanceStatusReq response = new TaskTrackerReportInstanceStatusReq();
        BeanUtils.copyProperties((Object)req, (Object)response);
        response.setInstanceStatus(InstanceStatus.FAILED.getV());
        response.setResult(String.format("init TaskTracker failed, reason: %s", e.toString()));
        response.setReportTime(System.currentTimeMillis());
        response.setStartTime(System.currentTimeMillis());
        response.setSourceAddress(workerRuntime.getWorkerAddress());
        String serverPath = AkkaUtils.getServerActorPath(workerRuntime.getServerDiscoveryService().getCurrentServerAddress());
        ActorSelection serverActor = workerRuntime.getActorSystem().actorSelection(serverPath);
        serverActor.tell((Object)response, null);
    }

    protected void reportFinalStatusThenDestroy(ActorSelection serverActor, TaskTrackerReportInstanceStatusReq reportInstanceStatusReq) {
        CompletionStage ask = Patterns.ask((ActorSelection)serverActor, (Object)reportInstanceStatusReq, (Duration)Duration.ofSeconds(15L));
        boolean serverAccepted = false;
        try {
            AskResponse askResponse = (AskResponse)ask.toCompletableFuture().get(15L, TimeUnit.SECONDS);
            serverAccepted = askResponse.isSuccess();
        }
        catch (Exception e) {
            log.warn("[TaskTracker-{}] report finished status failed, req={}.", new Object[]{this.instanceId, reportInstanceStatusReq, e});
        }
        if (!serverAccepted) {
            if (++this.reportFailedCnt > 5) {
                log.error("[TaskTracker-{}] try to report finished status(detail={}) lots of times but all failed, it's time to give up, so the process result will be dropped", (Object)this.instanceId, (Object)reportInstanceStatusReq);
                this.destroy();
            }
            return;
        }
        log.info("[TaskTracker-{}] report finished status(detail={}) success", (Object)this.instanceId, (Object)reportInstanceStatusReq);
        this.destroy();
    }
}

