/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.processor;

import akka.actor.ActorSelection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.utils.AkkaUtils;
import tech.powerjob.worker.common.utils.SpringUtils;
import tech.powerjob.worker.container.OmsContainer;
import tech.powerjob.worker.container.OmsContainerFactory;
import tech.powerjob.worker.core.ProcessorBeanFactory;
import tech.powerjob.worker.core.processor.ProcessorInfo;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;

public class ProcessorLoader {
    private static final Logger log = LoggerFactory.getLogger(ProcessorLoader.class);
    private static final Map<String, ProcessorInfo> CACHE = new ConcurrentHashMap<String, ProcessorInfo>(128);

    public static ProcessorInfo loadProcessor(WorkerRuntime workerRuntime, String processorType, String processorInfo) {
        ProcessorInfo processorInfoHolder = null;
        ProcessorType type = ProcessorType.valueOf((String)processorType);
        switch (type) {
            case BUILT_IN: {
                processorInfoHolder = CACHE.computeIfAbsent(processorInfo, ignore -> {
                    if (SpringUtils.supportSpringBean()) {
                        try {
                            return ProcessorInfo.of((BasicProcessor)SpringUtils.getBean(processorInfo), workerRuntime.getClass().getClassLoader());
                        }
                        catch (Exception e) {
                            log.warn("[ProcessorLoader] no spring bean of processor(className={}), reason is {}.", (Object)processorInfo, (Object)ExceptionUtils.getMessage((Throwable)e));
                        }
                    }
                    return ProcessorInfo.of(ProcessorBeanFactory.getInstance().getLocalProcessor(processorInfo), workerRuntime.getClass().getClassLoader());
                });
                break;
            }
            case EXTERNAL: {
                String[] split = processorInfo.split("#");
                log.info("[ProcessorLoader] try to load processor({}) in container({})", (Object)split[1], (Object)split[0]);
                String serverPath = AkkaUtils.getServerActorPath(workerRuntime.getServerDiscoveryService().getCurrentServerAddress());
                ActorSelection actorSelection = workerRuntime.getActorSystem().actorSelection(serverPath);
                OmsContainer omsContainer = OmsContainerFactory.fetchContainer(Long.valueOf(split[0]), actorSelection);
                if (omsContainer != null) {
                    processorInfoHolder = ProcessorInfo.of(omsContainer.getProcessor(split[1]), omsContainer.getContainerClassLoader());
                    break;
                }
                log.warn("[ProcessorLoader] load container failed. processor info : {}", (Object)processorInfo);
                break;
            }
            default: {
                log.warn("[ProcessorLoader] unknown processor type: {}.", (Object)processorType);
                throw new PowerJobException("unknown processor type of " + processorType);
            }
        }
        if (processorInfoHolder == null) {
            log.warn("[ProcessorLoader] fetch Processor(type={},info={}) failed.", (Object)processorType, (Object)processorInfo);
            throw new PowerJobException("fetch Processor failed, please check your processorType and processorInfo config");
        }
        return processorInfoHolder;
    }
}

