/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.background;

import akka.actor.ActorSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.model.SystemMetrics;
import tech.powerjob.common.request.WorkerHeartbeat;
import tech.powerjob.worker.common.PowerJobWorkerVersion;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.utils.AkkaUtils;
import tech.powerjob.worker.common.utils.SystemInfoUtils;
import tech.powerjob.worker.container.OmsContainerFactory;
import tech.powerjob.worker.core.tracker.manager.HeavyTaskTrackerManager;
import tech.powerjob.worker.core.tracker.manager.LightTaskTrackerManager;

public class WorkerHealthReporter
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkerHealthReporter.class);
    private final WorkerRuntime workerRuntime;

    @Override
    public void run() {
        String currentServer = this.workerRuntime.getServerDiscoveryService().getCurrentServerAddress();
        if (StringUtils.isEmpty((Object)currentServer)) {
            log.warn("[WorkerHealthReporter] no available server,fail to report health info!");
            return;
        }
        SystemMetrics systemMetrics = this.workerRuntime.getWorkerConfig().getSystemMetricsCollector() == null ? SystemInfoUtils.getSystemMetrics() : this.workerRuntime.getWorkerConfig().getSystemMetricsCollector().collect();
        WorkerHeartbeat heartbeat = new WorkerHeartbeat();
        heartbeat.setSystemMetrics(systemMetrics);
        heartbeat.setWorkerAddress(this.workerRuntime.getWorkerAddress());
        heartbeat.setAppName(this.workerRuntime.getWorkerConfig().getAppName());
        heartbeat.setAppId(this.workerRuntime.getAppId());
        heartbeat.setHeartbeatTime(System.currentTimeMillis());
        heartbeat.setVersion(PowerJobWorkerVersion.getVersion());
        heartbeat.setProtocol(Protocol.AKKA.name());
        heartbeat.setClient("Atlantis");
        heartbeat.setTag(this.workerRuntime.getWorkerConfig().getTag());
        heartbeat.setLightTaskTrackerNum(LightTaskTrackerManager.currentTaskTrackerSize());
        heartbeat.setHeavyTaskTrackerNum(HeavyTaskTrackerManager.currentTaskTrackerSize());
        if (this.workerRuntime.getWorkerConfig().getMaxLightweightTaskNum() <= LightTaskTrackerManager.currentTaskTrackerSize() || this.workerRuntime.getWorkerConfig().getMaxHeavyweightTaskNum() <= HeavyTaskTrackerManager.currentTaskTrackerSize()) {
            heartbeat.setOverload(true);
        }
        heartbeat.setContainerInfos(OmsContainerFactory.getDeployedContainerInfos());
        String serverPath = AkkaUtils.getServerActorPath(currentServer);
        if (StringUtils.isEmpty((Object)serverPath)) {
            return;
        }
        log.info("[WorkerHealthReporter] report health status,appId:{},appName:{},isOverload:{},maxLightweightTaskNum:{},currentLightweightTaskNum:{},maxHeavyweightTaskNum:{},currentHeavyweightTaskNum:{}", new Object[]{heartbeat.getAppId(), heartbeat.getAppName(), heartbeat.isOverload(), this.workerRuntime.getWorkerConfig().getMaxLightweightTaskNum(), heartbeat.getLightTaskTrackerNum(), this.workerRuntime.getWorkerConfig().getMaxHeavyweightTaskNum(), heartbeat.getHeavyTaskTrackerNum()});
        ActorSelection actorSelection = this.workerRuntime.getActorSystem().actorSelection(serverPath);
        actorSelection.tell((Object)heartbeat, null);
    }

    public WorkerHealthReporter(WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
    }
}

