/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.background;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.HttpUtils;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.core.tracker.manager.HeavyTaskTrackerManager;
import tech.powerjob.worker.core.tracker.task.heavy.HeavyTaskTracker;

public class ServerDiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(ServerDiscoveryService.class);
    private final Long appId;
    private final PowerJobWorkerConfig config;
    private String currentServerAddress;
    private final Map<String, String> ip2Address = Maps.newHashMap();
    private static final String DISCOVERY_URL = "http://%s/server/acquire?appId=%d&currentServer=%s&protocol=AKKA";
    private static int FAILED_COUNT = 0;
    private static final int MAX_FAILED_COUNT = 3;

    public ServerDiscoveryService(Long appId, PowerJobWorkerConfig config) {
        this.appId = appId;
        this.config = config;
    }

    public void start(ScheduledExecutorService timingPool) {
        this.currentServerAddress = this.discovery();
        if (StringUtils.isEmpty((Object)this.currentServerAddress) && !this.config.isEnableTestMode()) {
            throw new PowerJobException("can't find any available server, this worker has been quarantined.");
        }
        timingPool.scheduleAtFixedRate(() -> {
            try {
                this.currentServerAddress = this.discovery();
            }
            catch (Exception e) {
                log.error("[PowerDiscovery] fail to discovery server!", (Throwable)e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public String getCurrentServerAddress() {
        return this.currentServerAddress;
    }

    private String discovery() {
        Object ip;
        String firstServerAddress;
        if (this.ip2Address.isEmpty()) {
            this.config.getServerAddress().forEach(x -> this.ip2Address.put(x.split(":")[0], (String)x));
        }
        String result = null;
        String currentServer = this.currentServerAddress;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)currentServer) && (firstServerAddress = this.ip2Address.get(ip = currentServer.split(":")[0])) != null) {
            result = this.acquire(firstServerAddress);
        }
        for (String httpServerAddress : this.config.getServerAddress()) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty(result)) break;
            result = this.acquire(httpServerAddress);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(result)) {
            log.warn("[PowerDiscovery] can't find any available server, this worker has been quarantined.");
            if (FAILED_COUNT++ > 3) {
                log.warn("[PowerDiscovery] can't find any available server for 3 consecutive times, It's time to kill all frequent job in this worker.");
                List<Long> frequentInstanceIds = HeavyTaskTrackerManager.getAllFrequentTaskTrackerKeys();
                if (!CollectionUtils.isEmpty(frequentInstanceIds)) {
                    frequentInstanceIds.forEach(instanceId -> {
                        HeavyTaskTracker taskTracker = HeavyTaskTrackerManager.removeTaskTracker(instanceId);
                        taskTracker.destroy();
                        log.warn("[PowerDiscovery] kill frequent instance(instanceId={}) due to can't find any available server.", instanceId);
                    });
                }
                FAILED_COUNT = 0;
            }
            return null;
        }
        FAILED_COUNT = 0;
        log.debug("[PowerDiscovery] current server is {}.", result);
        return result;
    }

    private String acquire(String httpServerAddress) {
        String result = null;
        String url = String.format(DISCOVERY_URL, httpServerAddress, this.appId, this.currentServerAddress);
        try {
            result = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)url));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(result)) {
            try {
                ResultDTO resultDTO = (ResultDTO)JsonUtils.parseObject((String)result, ResultDTO.class);
                if (resultDTO.isSuccess()) {
                    return resultDTO.getData().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

