/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.actors;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.Creator;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.ExecuteType;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.request.ServerQueryInstanceStatusReq;
import tech.powerjob.common.request.ServerScheduleJobReq;
import tech.powerjob.common.request.ServerStopInstanceReq;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.constants.TaskStatus;
import tech.powerjob.worker.core.tracker.manager.HeavyTaskTrackerManager;
import tech.powerjob.worker.core.tracker.manager.LightTaskTrackerManager;
import tech.powerjob.worker.core.tracker.task.TaskTracker;
import tech.powerjob.worker.core.tracker.task.heavy.HeavyTaskTracker;
import tech.powerjob.worker.core.tracker.task.light.LightTaskTracker;
import tech.powerjob.worker.persistence.TaskDO;
import tech.powerjob.worker.pojo.request.ProcessorMapTaskRequest;
import tech.powerjob.worker.pojo.request.ProcessorReportTaskStatusReq;
import tech.powerjob.worker.pojo.request.ProcessorTrackerStatusReportReq;

public class TaskTrackerActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(TaskTrackerActor.class);
    private final WorkerRuntime workerRuntime;

    public static Props props(WorkerRuntime workerRuntime) {
        return Props.create(TaskTrackerActor.class, (Creator & Serializable)() -> new TaskTrackerActor(workerRuntime));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ProcessorReportTaskStatusReq.class, this::onReceiveProcessorReportTaskStatusReq).match(ServerScheduleJobReq.class, this::onReceiveServerScheduleJobReq).match(ProcessorMapTaskRequest.class, this::onReceiveProcessorMapTaskRequest).match(ProcessorTrackerStatusReportReq.class, this::onReceiveProcessorTrackerStatusReportReq).match(ServerStopInstanceReq.class, this::onReceiveServerStopInstanceReq).match(ServerQueryInstanceStatusReq.class, this::onReceiveServerQueryInstanceStatusReq).matchAny(obj -> log.warn("[ServerRequestActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceiveProcessorReportTaskStatusReq(ProcessorReportTaskStatusReq req) {
        int taskStatus = req.getStatus();
        HeavyTaskTracker taskTracker = HeavyTaskTrackerManager.getTaskTracker(req.getInstanceId());
        if (TaskStatus.FINISHED_STATUS.contains(taskStatus)) {
            AskResponse askResponse = AskResponse.succeed(null);
            this.getSender().tell((Object)askResponse, this.getSelf());
        }
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ProcessorReportTaskStatusReq({}) but system can't find TaskTracker.", (Object)req);
            return;
        }
        if (ProcessorReportTaskStatusReq.BROADCAST.equals(req.getCmd())) {
            taskTracker.broadcast(taskStatus == TaskStatus.WORKER_PROCESS_SUCCESS.getValue(), req.getSubInstanceId(), req.getTaskId(), req.getResult());
        }
        taskTracker.updateTaskStatus(req.getSubInstanceId(), req.getTaskId(), taskStatus, req.getReportTime(), req.getResult());
        taskTracker.updateAppendedWfContext(req.getAppendedWfContext());
    }

    private void onReceiveProcessorMapTaskRequest(ProcessorMapTaskRequest req) {
        HeavyTaskTracker taskTracker = HeavyTaskTrackerManager.getTaskTracker(req.getInstanceId());
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ProcessorMapTaskRequest({}) but system can't find TaskTracker.", (Object)req);
            return;
        }
        boolean success = false;
        LinkedList subTaskList = Lists.newLinkedList();
        try {
            req.getSubTasks().forEach(originSubTask -> {
                TaskDO subTask = new TaskDO();
                subTask.setTaskName(req.getTaskName());
                subTask.setSubInstanceId(req.getSubInstanceId());
                subTask.setTaskId(originSubTask.getTaskId());
                subTask.setTaskContent(originSubTask.getTaskContent());
                subTaskList.add(subTask);
            });
            success = taskTracker.submitTask(subTaskList);
        }
        catch (Exception e) {
            log.warn("[TaskTrackerActor] process map task(instanceId={}) failed.", (Object)req.getInstanceId(), (Object)e);
        }
        AskResponse response = new AskResponse();
        response.setSuccess(success);
        this.getSender().tell((Object)response, this.getSelf());
    }

    private void onReceiveServerScheduleJobReq(ServerScheduleJobReq req) {
        log.debug("[TaskTrackerActor] server schedule job by request: {}.", (Object)req);
        Long instanceId = req.getInstanceId();
        if (this.isLightweightTask(req)) {
            LightTaskTracker taskTracker = LightTaskTrackerManager.getTaskTracker(instanceId);
            if (taskTracker != null) {
                log.warn("[TaskTrackerActor] LightTaskTracker({}) for instance(id={}) already exists.", (Object)taskTracker, (Object)instanceId);
                return;
            }
            if ((double)LightTaskTrackerManager.currentTaskTrackerSize() >= (double)this.workerRuntime.getWorkerConfig().getMaxLightweightTaskNum().intValue() * 1.3) {
                log.warn("[TaskTrackerActor] this worker is overload,ignore this request(instanceId={}),current size = {}!", (Object)instanceId, (Object)LightTaskTrackerManager.currentTaskTrackerSize());
                return;
            }
            if (LightTaskTrackerManager.currentTaskTrackerSize() >= this.workerRuntime.getWorkerConfig().getMaxLightweightTaskNum()) {
                log.warn("[TaskTrackerActor] this worker will be overload soon,current size = {}!", (Object)LightTaskTrackerManager.currentTaskTrackerSize());
            }
            LightTaskTrackerManager.atomicCreateTaskTracker(instanceId, ignore -> LightTaskTracker.create(req, this.workerRuntime));
        } else {
            HeavyTaskTracker taskTracker = HeavyTaskTrackerManager.getTaskTracker(instanceId);
            if (taskTracker != null) {
                log.warn("[TaskTrackerActor] HeavyTaskTracker({}) for instance(id={}) already exists.", (Object)taskTracker, (Object)instanceId);
                return;
            }
            if (HeavyTaskTrackerManager.currentTaskTrackerSize() >= this.workerRuntime.getWorkerConfig().getMaxHeavyweightTaskNum()) {
                log.warn("[TaskTrackerActor] this worker is overload,ignore this request(instanceId={})! current size = {},", (Object)instanceId, (Object)HeavyTaskTrackerManager.currentTaskTrackerSize());
                return;
            }
            HeavyTaskTrackerManager.atomicCreateTaskTracker(instanceId, ignore -> HeavyTaskTracker.create(req, this.workerRuntime));
        }
    }

    private void onReceiveProcessorTrackerStatusReportReq(ProcessorTrackerStatusReportReq req) {
        HeavyTaskTracker taskTracker = HeavyTaskTrackerManager.getTaskTracker(req.getInstanceId());
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ProcessorTrackerStatusReportReq({}) but system can't find TaskTracker.", (Object)req);
            return;
        }
        taskTracker.receiveProcessorTrackerHeartbeat(req);
    }

    private void onReceiveServerStopInstanceReq(ServerStopInstanceReq req) {
        log.info("[TaskTrackerActor] receive ServerStopInstanceReq({}).", (Object)req);
        HeavyTaskTracker heavyTaskTracker = HeavyTaskTrackerManager.getTaskTracker(req.getInstanceId());
        if (heavyTaskTracker != null) {
            heavyTaskTracker.stopTask();
            return;
        }
        LightTaskTracker lightTaskTracker = LightTaskTrackerManager.getTaskTracker(req.getInstanceId());
        if (lightTaskTracker != null) {
            lightTaskTracker.stopTask();
            return;
        }
        log.warn("[TaskTrackerActor] receive ServerStopInstanceReq({}) but system can't find TaskTracker.", (Object)req);
    }

    private void onReceiveServerQueryInstanceStatusReq(ServerQueryInstanceStatusReq req) {
        AskResponse askResponse;
        TaskTracker taskTracker = HeavyTaskTrackerManager.getTaskTracker(req.getInstanceId());
        if (taskTracker == null && (taskTracker = LightTaskTrackerManager.getTaskTracker(req.getInstanceId())) == null) {
            log.warn("[TaskTrackerActor] receive ServerQueryInstanceStatusReq({}) but system can't find TaskTracker.", (Object)req);
            askResponse = AskResponse.failed((String)"can't find TaskTracker");
        } else {
            InstanceDetail instanceDetail = taskTracker.fetchRunningStatus();
            askResponse = AskResponse.succeed((Object)instanceDetail);
        }
        this.getSender().tell((Object)askResponse, this.getSelf());
    }

    private boolean isLightweightTask(ServerScheduleJobReq serverScheduleJobReq) {
        ExecuteType executeType = ExecuteType.valueOf((String)serverScheduleJobReq.getExecuteType());
        if (executeType != ExecuteType.STANDALONE) {
            return false;
        }
        TimeExpressionType timeExpressionType = TimeExpressionType.valueOf((String)serverScheduleJobReq.getTimeExpressionType());
        return timeExpressionType != TimeExpressionType.FIXED_DELAY && timeExpressionType != TimeExpressionType.FIXED_RATE;
    }

    public TaskTrackerActor(WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
    }
}

