/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.samples.tester;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;
import tech.powerjob.worker.log.OmsLogger;

@Component
public class JobRepetitiveExecutionTester
implements BasicProcessor {
    private static final Logger log = LoggerFactory.getLogger(JobRepetitiveExecutionTester.class);
    private final AtomicLong repetitions = new AtomicLong();
    private final Set<String> repetitionsInfo = Sets.newHashSet();
    private final Cache<String, Integer> instanceId2Num = CacheBuilder.newBuilder().maximumSize(1024L).build();

    public ProcessResult process(TaskContext context) throws Exception {
        log.info("[SimpleJobRepetitiveExecutionTester] repetitions:{}, repetitionsInfo: {}", (Object)this.repetitions.get(), (Object)this.repetitionsInfo);
        OmsLogger omsLogger = context.getOmsLogger();
        Long instanceId = context.getInstanceId();
        omsLogger.info("[SimpleJobRepetitiveExecutionTester] jobId: {}, instanceId: {}, subInstanceId: {}", new Object[]{context.getJobParams(), instanceId, context.getSubInstanceId()});
        this.check(context);
        return new ProcessResult(true, "success: " + System.currentTimeMillis());
    }

    private synchronized void check(TaskContext context) {
        String uid = context.getInstanceId() + "_" + Optional.ofNullable(context.getSubInstanceId()).orElse(context.getInstanceId());
        Integer numIfPresent = (Integer)this.instanceId2Num.getIfPresent((Object)uid);
        if (numIfPresent == null) {
            this.instanceId2Num.put((Object)uid, (Object)1);
            return;
        }
        context.getOmsLogger().error("[Repetitions] instance[id={}] already execute {} nums!", new Object[]{uid, numIfPresent});
        this.instanceId2Num.put((Object)uid, (Object)(numIfPresent + 1));
        this.repetitionsInfo.add(String.format("%d_%s", context.getJobId(), uid));
        context.getOmsLogger().error("[Repetitions] current repetitions num: {}", new Object[]{this.repetitions.incrementAndGet()});
        context.getOmsLogger().error("[Repetitions] current repetitionsInfo: {}", new Object[]{this.repetitionsInfo.toString()});
    }
}

