/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.samples.processors;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.samples.processors.MapReduceProcessorDemo;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.TaskResult;
import tech.powerjob.worker.core.processor.sdk.MapReduceProcessor;
import tech.powerjob.worker.log.OmsLogger;

@Component
public class MapReduceProcessorDemo
implements MapReduceProcessor {
    private static final Logger log = LoggerFactory.getLogger(MapReduceProcessorDemo.class);

    public ProcessResult process(TaskContext context) throws Exception {
        OmsLogger omsLogger = context.getOmsLogger();
        log.info("============== TestMapReduceProcessor#process ==============");
        log.info("isRootTask:{}", (Object)this.isRootTask());
        log.info("taskContext:{}", (Object)JsonUtils.toJSONString((Object)context));
        JSONObject jobParams = JSONObject.parseObject((String)context.getJobParams());
        Integer batchSize = (Integer)jobParams.getOrDefault((Object)"batchSize", (Object)100);
        Integer batchNum = (Integer)jobParams.getOrDefault((Object)"batchNum", (Object)10);
        if (this.isRootTask()) {
            log.info("==== MAP ====");
            omsLogger.info("[DemoMRProcessor] start root task~", new Object[0]);
            LinkedList subTasks = Lists.newLinkedList();
            for (int j = 0; j < batchNum; ++j) {
                for (int i = 0; i < batchSize; ++i) {
                    int x = j * batchSize + i;
                    subTasks.add(new TestSubTask("name" + x, x));
                }
                this.map((List)subTasks, "MAP_TEST_TASK");
                subTasks.clear();
            }
            omsLogger.info("[DemoMRProcessor] map success~", new Object[0]);
            return new ProcessResult(true, "MAP_SUCCESS");
        }
        log.info("==== NORMAL_PROCESS ====");
        omsLogger.info("[DemoMRProcessor] process subTask: {}.", new Object[]{JSON.toJSONString((Object)context.getSubTask())});
        log.info("subTask: {}", (Object)JsonUtils.toJSONString((Object)context.getSubTask()));
        Thread.sleep(1000L);
        if (context.getCurrentRetryTimes() == 0) {
            return new ProcessResult(false, "FIRST_FAILED");
        }
        return new ProcessResult(true, "PROCESS_SUCCESS");
    }

    public ProcessResult reduce(TaskContext context, List<TaskResult> taskResults) {
        log.info("================ MapReduceProcessorDemo#reduce ================");
        log.info("TaskContext: {}", (Object)JSONObject.toJSONString((Object)context));
        log.info("List<TaskResult>: {}", (Object)JSONObject.toJSONString(taskResults));
        context.getOmsLogger().info("MapReduce job finished, result is {}.", new Object[]{taskResults});
        boolean success = ThreadLocalRandom.current().nextBoolean();
        return new ProcessResult(success, context + ": " + success);
    }
}

