/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.workflow;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.LifeCycle;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.common.request.http.SaveWorkflowNodeRequest;
import tech.powerjob.common.request.http.SaveWorkflowRequest;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.common.timewheel.holder.InstanceTimeWheelService;
import tech.powerjob.server.core.scheduler.TimingStrategyService;
import tech.powerjob.server.core.service.NodeValidateService;
import tech.powerjob.server.core.workflow.WorkflowInstanceManager;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAG;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAGUtils;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowNodeInfoRepository;
import tech.powerjob.server.remote.server.redirector.DesignateServer;

@Service
public class WorkflowService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowService.class);
    @Resource
    private WorkflowInstanceManager workflowInstanceManager;
    @Resource
    private WorkflowInfoRepository workflowInfoRepository;
    @Resource
    private WorkflowNodeInfoRepository workflowNodeInfoRepository;
    @Resource
    private NodeValidateService nodeValidateService;
    @Resource
    private TimingStrategyService timingStrategyService;

    @Transactional(rollbackOn={Exception.class})
    public Long saveWorkflow(SaveWorkflowRequest req) {
        WorkflowInfoDO wf;
        req.valid();
        Long wfId = req.getId();
        if (wfId == null) {
            wf = new WorkflowInfoDO();
            wf.setGmtCreate(new Date());
        } else {
            Long finalWfId = wfId;
            wf = (WorkflowInfoDO)this.workflowInfoRepository.findById((Object)wfId).orElseThrow(() -> new IllegalArgumentException("can't find workflow by id:" + finalWfId));
        }
        BeanUtils.copyProperties((Object)req, (Object)wf);
        wf.setGmtModified(new Date());
        wf.setStatus(Integer.valueOf(req.isEnable() ? SwitchableStatus.ENABLE.getV() : SwitchableStatus.DISABLE.getV()));
        wf.setTimeExpressionType(Integer.valueOf(req.getTimeExpressionType().getV()));
        if (req.getNotifyUserIds() != null) {
            wf.setNotifyUserIds(SJ.COMMA_JOINER.join((Iterable)req.getNotifyUserIds()));
        }
        if (req.getLifeCycle() != null) {
            wf.setLifecycle(JSON.toJSONString((Object)req.getLifeCycle()));
        }
        if (TimeExpressionType.FREQUENT_TYPES.contains(req.getTimeExpressionType().getV())) {
            wf.setTimeExpression(null);
        } else {
            LifeCycle lifeCycle = Optional.ofNullable(req.getLifeCycle()).orElse(LifeCycle.EMPTY_LIFE_CYCLE);
            Long nextValidTime = this.timingStrategyService.calculateNextTriggerTimeWithInspection(TimeExpressionType.of((int)wf.getTimeExpressionType()), wf.getTimeExpression(), lifeCycle.getStart(), lifeCycle.getEnd());
            wf.setNextTriggerTime(nextValidTime);
        }
        if (wfId == null) {
            wf = (WorkflowInfoDO)this.workflowInfoRepository.saveAndFlush((Object)wf);
            wfId = wf.getId();
        }
        wf.setPeDAG(this.validateAndConvert2String(wfId, req.getDag()));
        this.workflowInfoRepository.saveAndFlush((Object)wf);
        return wfId;
    }

    private String validateAndConvert2String(Long wfId, PEWorkflowDAG dag) {
        if (dag == null || !WorkflowDAGUtils.valid(dag)) {
            throw new PowerJobException("illegal DAG");
        }
        ArrayList nodeIdList = Lists.newArrayList();
        ArrayList newNodes = Lists.newArrayList();
        WorkflowDAG complexDag = WorkflowDAGUtils.convert(dag);
        for (PEWorkflowDAG.Node node : dag.getNodes()) {
            WorkflowNodeInfoDO nodeInfo = (WorkflowNodeInfoDO)this.workflowNodeInfoRepository.findById((Object)node.getNodeId()).orElseThrow(() -> new PowerJobException("can't find node info by id :" + node.getNodeId()));
            if (nodeInfo.getWorkflowId() == null) {
                nodeInfo.setWorkflowId(wfId);
                nodeInfo.setGmtModified(new Date());
                this.workflowNodeInfoRepository.saveAndFlush((Object)nodeInfo);
            }
            if (!wfId.equals(nodeInfo.getWorkflowId())) {
                throw new PowerJobException("can't use another workflow's node");
            }
            this.nodeValidateService.complexValidate(nodeInfo, complexDag);
            newNodes.add(new PEWorkflowDAG.Node(node.getNodeId()));
            nodeIdList.add(node.getNodeId());
        }
        dag.setNodes((List)newNodes);
        int deleteCount = this.workflowNodeInfoRepository.deleteByWorkflowIdAndIdNotIn(wfId, (List)nodeIdList);
        log.warn("[WorkflowService-{}] delete {} dissociative nodes of workflow", (Object)wfId, (Object)deleteCount);
        return JSON.toJSONString((Object)dag);
    }

    @Transactional(rollbackOn={Exception.class})
    public long copyWorkflow(Long wfId, Long appId) {
        WorkflowInfoDO originWorkflow = this.permissionCheck(wfId, appId);
        if (originWorkflow.getStatus().intValue() == SwitchableStatus.DELETED.getV()) {
            throw new IllegalStateException("can't copy the workflow which has been deleted!");
        }
        WorkflowInfoDO copyWorkflow = new WorkflowInfoDO();
        BeanUtils.copyProperties((Object)originWorkflow, (Object)copyWorkflow);
        copyWorkflow.setId(null);
        copyWorkflow.setGmtCreate(new Date());
        copyWorkflow.setGmtModified(new Date());
        copyWorkflow.setWfName(copyWorkflow.getWfName() + "_COPY");
        copyWorkflow = (WorkflowInfoDO)this.workflowInfoRepository.saveAndFlush((Object)copyWorkflow);
        if (StringUtils.isEmpty((CharSequence)copyWorkflow.getPeDAG())) {
            return copyWorkflow.getId();
        }
        PEWorkflowDAG dag = (PEWorkflowDAG)JSON.parseObject((String)copyWorkflow.getPeDAG(), PEWorkflowDAG.class);
        if (!CollectionUtils.isEmpty((Collection)dag.getNodes())) {
            HashMap<Long, Long> nodeIdMap = new HashMap<Long, Long>(dag.getNodes().size(), 1.0f);
            for (PEWorkflowDAG.Node node : dag.getNodes()) {
                WorkflowNodeInfoDO originNode = (WorkflowNodeInfoDO)this.workflowNodeInfoRepository.findById((Object)node.getNodeId()).orElseThrow(() -> new IllegalArgumentException("can't find workflow Node by id: " + node.getNodeId()));
                WorkflowNodeInfoDO copyNode = new WorkflowNodeInfoDO();
                BeanUtils.copyProperties((Object)originNode, (Object)copyNode);
                copyNode.setId(null);
                copyNode.setWorkflowId(copyWorkflow.getId());
                copyNode.setGmtCreate(new Date());
                copyNode.setGmtModified(new Date());
                copyNode = (WorkflowNodeInfoDO)this.workflowNodeInfoRepository.saveAndFlush((Object)copyNode);
                nodeIdMap.put(originNode.getId(), copyNode.getId());
                node.setNodeId(copyNode.getId());
            }
            for (PEWorkflowDAG.Edge edge : dag.getEdges()) {
                edge.setFrom((Long)nodeIdMap.get(edge.getFrom()));
                edge.setTo((Long)nodeIdMap.get(edge.getTo()));
            }
        }
        copyWorkflow.setPeDAG(JSON.toJSONString((Object)dag));
        this.workflowInfoRepository.saveAndFlush((Object)copyWorkflow);
        return copyWorkflow.getId();
    }

    public WorkflowInfoDO fetchWorkflow(Long wfId, Long appId) {
        WorkflowInfoDO wfInfo = this.permissionCheck(wfId, appId);
        this.fillWorkflow(wfInfo);
        return wfInfo;
    }

    public void deleteWorkflow(Long wfId, Long appId) {
        WorkflowInfoDO wfInfo = this.permissionCheck(wfId, appId);
        wfInfo.setStatus(Integer.valueOf(SwitchableStatus.DELETED.getV()));
        wfInfo.setGmtModified(new Date());
        this.workflowInfoRepository.saveAndFlush((Object)wfInfo);
    }

    public void disableWorkflow(Long wfId, Long appId) {
        WorkflowInfoDO wfInfo = this.permissionCheck(wfId, appId);
        wfInfo.setStatus(Integer.valueOf(SwitchableStatus.DISABLE.getV()));
        wfInfo.setGmtModified(new Date());
        this.workflowInfoRepository.saveAndFlush((Object)wfInfo);
    }

    public void enableWorkflow(Long wfId, Long appId) {
        WorkflowInfoDO wfInfo = this.permissionCheck(wfId, appId);
        wfInfo.setStatus(Integer.valueOf(SwitchableStatus.ENABLE.getV()));
        wfInfo.setGmtModified(new Date());
        this.workflowInfoRepository.saveAndFlush((Object)wfInfo);
    }

    @DesignateServer
    public Long runWorkflow(Long wfId, Long appId, String initParams, Long delay) {
        delay = delay == null ? 0L : delay;
        WorkflowInfoDO wfInfo = this.permissionCheck(wfId, appId);
        log.info("[WorkflowService-{}] try to run workflow, initParams={},delay={} ms.", new Object[]{wfInfo.getId(), initParams, delay});
        Long wfInstanceId = this.workflowInstanceManager.create(wfInfo, initParams, System.currentTimeMillis() + delay, null);
        if (delay <= 0L) {
            this.workflowInstanceManager.start(wfInfo, wfInstanceId);
        } else {
            InstanceTimeWheelService.schedule((Long)wfInstanceId, (Long)delay, () -> this.workflowInstanceManager.start(wfInfo, wfInstanceId));
        }
        return wfInstanceId;
    }

    @Transactional(rollbackOn={Exception.class})
    public List<WorkflowNodeInfoDO> saveWorkflowNode(List<SaveWorkflowNodeRequest> workflowNodeRequestList) {
        if (CollectionUtils.isEmpty(workflowNodeRequestList)) {
            return Collections.emptyList();
        }
        Long appId = workflowNodeRequestList.get(0).getAppId();
        ArrayList<WorkflowNodeInfoDO> res = new ArrayList<WorkflowNodeInfoDO>(workflowNodeRequestList.size());
        for (SaveWorkflowNodeRequest req : workflowNodeRequestList) {
            WorkflowNodeInfoDO workflowNodeInfo;
            req.valid();
            if (!appId.equals(req.getAppId())) {
                throw new PowerJobException("node list must are in the same app");
            }
            if (req.getId() != null) {
                workflowNodeInfo = (WorkflowNodeInfoDO)this.workflowNodeInfoRepository.findById((Object)req.getId()).orElseThrow(() -> new IllegalArgumentException("can't find workflow Node by id: " + req.getId()));
            } else {
                workflowNodeInfo = new WorkflowNodeInfoDO();
                workflowNodeInfo.setGmtCreate(new Date());
            }
            BeanUtils.copyProperties((Object)req, (Object)workflowNodeInfo);
            workflowNodeInfo.setType(req.getType());
            this.nodeValidateService.simpleValidate(workflowNodeInfo);
            workflowNodeInfo.setGmtModified(new Date());
            workflowNodeInfo = (WorkflowNodeInfoDO)this.workflowNodeInfoRepository.saveAndFlush((Object)workflowNodeInfo);
            res.add(workflowNodeInfo);
        }
        return res;
    }

    private void fillWorkflow(WorkflowInfoDO wfInfo) {
        PEWorkflowDAG dagInfo = null;
        try {
            dagInfo = (PEWorkflowDAG)JSON.parseObject((String)wfInfo.getPeDAG(), PEWorkflowDAG.class);
        }
        catch (Exception e2) {
            log.warn("[WorkflowService-{}]illegal DAG : {}", (Object)wfInfo.getId(), (Object)wfInfo.getPeDAG());
        }
        if (dagInfo == null) {
            return;
        }
        HashMap nodeIdNodInfoMap = Maps.newHashMap();
        this.workflowNodeInfoRepository.findByWorkflowId(wfInfo.getId()).forEach(e -> nodeIdNodInfoMap.put(e.getId(), e));
        if (!CollectionUtils.isEmpty((Collection)dagInfo.getNodes())) {
            for (PEWorkflowDAG.Node node : dagInfo.getNodes()) {
                WorkflowNodeInfoDO nodeInfo = (WorkflowNodeInfoDO)nodeIdNodInfoMap.get(node.getNodeId());
                if (nodeInfo == null) continue;
                node.setNodeType(nodeInfo.getType()).setJobId(nodeInfo.getJobId()).setEnable(nodeInfo.getEnable()).setSkipWhenFailed(nodeInfo.getSkipWhenFailed()).setNodeName(nodeInfo.getNodeName()).setNodeParams(nodeInfo.getNodeParams());
            }
        }
        wfInfo.setPeDAG(JSON.toJSONString((Object)dagInfo));
    }

    private WorkflowInfoDO permissionCheck(Long wfId, Long appId) {
        WorkflowInfoDO wfInfo = (WorkflowInfoDO)this.workflowInfoRepository.findById((Object)wfId).orElseThrow(() -> new IllegalArgumentException("can't find workflow by id: " + wfId));
        if (!wfInfo.getAppId().equals(appId)) {
            throw new PowerJobException("Permission Denied! can't operate other app's workflow!");
        }
        return wfInfo;
    }
}

