/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.workflow.hanlder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.core.evaluator.GroovyEvaluator;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAG;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAGUtils;
import tech.powerjob.server.core.workflow.hanlder.ControlNodeHandler;
import tech.powerjob.server.persistence.remote.model.WorkflowInstanceInfoDO;

@Component
public class DecisionNodeHandler
implements ControlNodeHandler {
    private static final Logger log = LoggerFactory.getLogger(DecisionNodeHandler.class);
    private final GroovyEvaluator groovyEvaluator = new GroovyEvaluator();

    @Override
    public void handle(PEWorkflowDAG.Node node, PEWorkflowDAG dag, WorkflowInstanceInfoDO wfInstanceInfo) {
        boolean finalRes;
        Object result;
        String script = node.getNodeParams();
        if (StringUtils.isBlank((CharSequence)script)) {
            log.error("[Workflow-{}|{}]decision node's param is blank! nodeId:{}", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId()});
            throw new PowerJobException("decision node's param is blank!");
        }
        HashMap wfContext = (HashMap)JSON.parseObject((String)wfInstanceInfo.getWfContext(), (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
        try {
            result = this.groovyEvaluator.evaluate(script, wfContext);
        }
        catch (Exception e) {
            log.error("[Workflow-{}|{}]failed to evaluate decision node,nodeId:{}", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId(), e});
            throw new PowerJobException("can't evaluate decision node!");
        }
        if (result instanceof Boolean) {
            finalRes = (Boolean)result;
        } else if (result instanceof Number) {
            finalRes = ((Number)result).doubleValue() > 0.0;
        } else {
            log.error("[Workflow-{}|{}]decision node's return value is illegal,nodeId:{},result:{}", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId(), JsonUtils.toJSONString((Object)result)});
            throw new PowerJobException("decision node's return value is illegal!");
        }
        this.handleDag(finalRes, node, dag);
    }

    private void handleDag(boolean res, PEWorkflowDAG.Node node, PEWorkflowDAG peDag) {
        node.setResult(String.valueOf(res));
        node.setStatus(Integer.valueOf(InstanceStatus.SUCCEED.getV()));
        WorkflowDAG dag = WorkflowDAGUtils.convert(peDag);
        WorkflowDAG.Node targetNode = dag.getNode(node.getNodeId());
        Collection<PEWorkflowDAG.Edge> edges = targetNode.getSuccessorEdgeMap().values();
        if (edges.isEmpty()) {
            return;
        }
        ArrayList<PEWorkflowDAG.Edge> disableEdges = new ArrayList<PEWorkflowDAG.Edge>(edges.size());
        for (PEWorkflowDAG.Edge edge : edges) {
            boolean property = Boolean.parseBoolean(edge.getProperty());
            if (res == property) continue;
            edge.setEnable(Boolean.valueOf(false));
            disableEdges.add(edge);
        }
        WorkflowDAGUtils.handleDisableEdges(disableEdges, dag);
    }

    @Override
    public WorkflowNodeType matchingType() {
        return WorkflowNodeType.DECISION;
    }
}

