/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.handler;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.common.request.WorkerHeartbeat;
import tech.powerjob.common.request.WorkerLogReportReq;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.remote.framework.actor.Actor;
import tech.powerjob.server.core.handler.AbWorkerRequestHandler;
import tech.powerjob.server.core.instance.InstanceLogService;
import tech.powerjob.server.core.instance.InstanceManager;
import tech.powerjob.server.core.workflow.WorkflowInstanceManager;
import tech.powerjob.server.monitor.MonitorService;
import tech.powerjob.server.monitor.events.w2s.TtReportInstanceStatusEvent;
import tech.powerjob.server.monitor.events.w2s.WorkerHeartbeatEvent;
import tech.powerjob.server.monitor.events.w2s.WorkerLogReportEvent;
import tech.powerjob.server.persistence.remote.repository.ContainerInfoRepository;
import tech.powerjob.server.remote.worker.WorkerClusterManagerService;
import tech.powerjob.server.remote.worker.WorkerClusterQueryService;

@Component
@Actor(path="server")
public class WorkerRequestHandlerImpl
extends AbWorkerRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(WorkerRequestHandlerImpl.class);
    private final InstanceManager instanceManager;
    private final WorkflowInstanceManager workflowInstanceManager;
    private final InstanceLogService instanceLogService;

    public WorkerRequestHandlerImpl(InstanceManager instanceManager, WorkflowInstanceManager workflowInstanceManager, InstanceLogService instanceLogService, MonitorService monitorService, Environment environment, ContainerInfoRepository containerInfoRepository, WorkerClusterQueryService workerClusterQueryService) {
        super(monitorService, environment, containerInfoRepository, workerClusterQueryService);
        this.instanceManager = instanceManager;
        this.workflowInstanceManager = workflowInstanceManager;
        this.instanceLogService = instanceLogService;
    }

    @Override
    protected void processWorkerHeartbeat0(WorkerHeartbeat heartbeat, WorkerHeartbeatEvent event) {
        WorkerClusterManagerService.updateStatus((WorkerHeartbeat)heartbeat);
    }

    @Override
    protected AskResponse processTaskTrackerReportInstanceStatus0(TaskTrackerReportInstanceStatusReq req, TtReportInstanceStatusEvent event) throws Exception {
        if (req.getWfInstanceId() != null && !CollectionUtils.isEmpty((Map)req.getAppendedWfContext())) {
            this.workflowInstanceManager.updateWorkflowContext(req.getWfInstanceId(), req.getAppendedWfContext());
        }
        this.instanceManager.updateStatus(req);
        if (InstanceStatus.FINISHED_STATUS.contains(req.getInstanceStatus())) {
            return AskResponse.succeed(null);
        }
        return null;
    }

    @Override
    protected void processWorkerLogReport0(WorkerLogReportReq req, WorkerLogReportEvent event) {
        this.instanceLogService.submitLogs(req.getWorkerAddress(), req.getInstanceLogContents());
    }
}

