/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.workflow.algorithm;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAG;

public class WorkflowDAGUtils {
    private WorkflowDAGUtils() {
    }

    public static void resetRetryableNode(PEWorkflowDAG dag) {
        for (PEWorkflowDAG.Node node : dag.getNodes()) {
            boolean realFailed;
            boolean bl = realFailed = node.getStatus().intValue() == InstanceStatus.FAILED.getV() && WorkflowDAGUtils.isNotAllowSkipWhenFailed(node);
            if (!realFailed && node.getStatus().intValue() != InstanceStatus.STOPPED.getV()) continue;
            node.setStatus(Integer.valueOf(InstanceStatus.WAITING_DISPATCH.getV()));
            if (node.getNodeType() != null && node.getNodeType().intValue() != WorkflowNodeType.JOB.getCode()) continue;
            node.setInstanceId(null);
        }
    }

    public static List<PEWorkflowDAG.Node> listRoots(PEWorkflowDAG peWorkflowDAG) {
        HashMap nodeId2Node = Maps.newHashMap();
        peWorkflowDAG.getNodes().forEach(node -> nodeId2Node.put(node.getNodeId(), node));
        peWorkflowDAG.getEdges().forEach(edge -> {
            PEWorkflowDAG.Node cfr_ignored_0 = (PEWorkflowDAG.Node)nodeId2Node.remove(edge.getTo());
        });
        return Lists.newLinkedList(nodeId2Node.values());
    }

    public static boolean valid(PEWorkflowDAG peWorkflowDAG) {
        HashSet nodeIds = Sets.newHashSet();
        if (peWorkflowDAG.getNodes() == null || peWorkflowDAG.getNodes().isEmpty()) {
            return false;
        }
        for (PEWorkflowDAG.Node n : peWorkflowDAG.getNodes()) {
            if (nodeIds.contains(n.getNodeId())) {
                return false;
            }
            nodeIds.add(n.getNodeId());
        }
        try {
            HashSet traversalNodeIds = Sets.newHashSet();
            WorkflowDAG dag = WorkflowDAGUtils.convert(peWorkflowDAG);
            for (WorkflowDAG.Node root : dag.getRoots()) {
                if (!WorkflowDAGUtils.invalidPath(root, Sets.newHashSet(), traversalNodeIds)) continue;
                return false;
            }
            return traversalNodeIds.size() == nodeIds.size();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<PEWorkflowDAG.Node> listReadyNodes(PEWorkflowDAG dag) {
        HashMap nodeId2Node = Maps.newHashMap();
        List dagNodes = dag.getNodes();
        for (PEWorkflowDAG.Node node : dagNodes) {
            nodeId2Node.put(node.getNodeId(), node);
        }
        LinkedListMultimap relyMap = LinkedListMultimap.create();
        LinkedListMultimap successorMap = LinkedListMultimap.create();
        dag.getEdges().forEach(arg_0 -> WorkflowDAGUtils.lambda$listReadyNodes$2((Multimap)relyMap, (Multimap)successorMap, arg_0));
        ArrayList readyNodes = Lists.newArrayList();
        ArrayList skipNodes = Lists.newArrayList();
        for (PEWorkflowDAG.Node currentNode : dagNodes) {
            if (!WorkflowDAGUtils.isReadyNode(currentNode.getNodeId(), nodeId2Node, (Multimap<Long, Long>)relyMap)) continue;
            if (currentNode.getEnable() != null && !currentNode.getEnable().booleanValue()) {
                skipNodes.add(currentNode);
                continue;
            }
            readyNodes.add(currentNode);
        }
        if (!skipNodes.isEmpty()) {
            for (PEWorkflowDAG.Node skipNode : skipNodes) {
                readyNodes.addAll(WorkflowDAGUtils.moveAndObtainReadySuccessor(skipNode, nodeId2Node, (Multimap<Long, Long>)relyMap, (Multimap<Long, Long>)successorMap));
            }
        }
        return readyNodes;
    }

    private static List<PEWorkflowDAG.Node> moveAndObtainReadySuccessor(PEWorkflowDAG.Node skippedNode, Map<Long, PEWorkflowDAG.Node> nodeId2Node, Multimap<Long, Long> relyMap, Multimap<Long, Long> successorMap) {
        skippedNode.setStatus(Integer.valueOf(InstanceStatus.SUCCEED.getV()));
        skippedNode.setResult("disable node");
        ArrayList readyNodes = Lists.newArrayList();
        ArrayList skipNodes = Lists.newArrayList();
        Collection successors = successorMap.get((Object)skippedNode.getNodeId());
        for (Long successor : successors) {
            if (!WorkflowDAGUtils.isReadyNode(successor, nodeId2Node, relyMap)) continue;
            PEWorkflowDAG.Node node = nodeId2Node.get(successor);
            if (node.getEnable() != null && !node.getEnable().booleanValue()) {
                skipNodes.add(node);
                continue;
            }
            readyNodes.add(node);
        }
        if (!skipNodes.isEmpty()) {
            for (PEWorkflowDAG.Node node : skipNodes) {
                readyNodes.addAll(WorkflowDAGUtils.moveAndObtainReadySuccessor(node, nodeId2Node, relyMap, successorMap));
            }
        }
        return readyNodes;
    }

    private static boolean isReadyNode(long nodeId, Map<Long, PEWorkflowDAG.Node> nodeId2Node, Multimap<Long, Long> relyMap) {
        int currentNodeStatus;
        PEWorkflowDAG.Node currentNode = nodeId2Node.get(nodeId);
        int n = currentNodeStatus = currentNode.getStatus() == null ? InstanceStatus.WAITING_DISPATCH.getV() : currentNode.getStatus().intValue();
        if (InstanceStatus.FINISHED_STATUS.contains(currentNodeStatus) || currentNodeStatus == InstanceStatus.RUNNING.getV()) {
            return false;
        }
        Collection relyNodeIds = relyMap.get((Object)nodeId);
        for (Long relyNodeId : relyNodeIds) {
            PEWorkflowDAG.Node relyNode = nodeId2Node.get(relyNodeId);
            int relyNodeStatus = relyNode.getStatus() == null ? InstanceStatus.WAITING_DISPATCH.getV() : relyNode.getStatus().intValue();
            if (!InstanceStatus.GENERALIZED_RUNNING_STATUS.contains(relyNodeStatus)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotAllowSkipWhenFailed(PEWorkflowDAG.Node node) {
        return node.getSkipWhenFailed() == null || node.getSkipWhenFailed() == false;
    }

    public static void handleDisableEdges(List<PEWorkflowDAG.Edge> disableEdges, WorkflowDAG dag) {
        if (disableEdges.isEmpty()) {
            return;
        }
        ArrayList disableNodes = Lists.newArrayList();
        for (PEWorkflowDAG.Edge disableEdge : disableEdges) {
            WorkflowDAG.Node toNode = dag.getNode(disableEdge.getTo());
            Collection<PEWorkflowDAG.Edge> dependenceEdges = toNode.getDependenceEdgeMap().values();
            boolean shouldBeDisable = true;
            for (PEWorkflowDAG.Edge dependenceEdge : dependenceEdges) {
                if (dependenceEdge.getEnable() != null && !dependenceEdge.getEnable().booleanValue()) continue;
                shouldBeDisable = false;
                break;
            }
            if (!shouldBeDisable) continue;
            PEWorkflowDAG.Node node = toNode.getHolder();
            node.setEnable(Boolean.valueOf(false)).setDisableByControlNode(Boolean.valueOf(true)).setStatus(Integer.valueOf(InstanceStatus.CANCELED.getV()));
            disableNodes.add(node);
        }
        if (!disableNodes.isEmpty()) {
            ArrayList targetEdges = Lists.newArrayList();
            for (PEWorkflowDAG.Node disableNode : disableNodes) {
                WorkflowDAG.Node node = dag.getNode(disableNode.getNodeId());
                Collection<PEWorkflowDAG.Edge> edges = node.getSuccessorEdgeMap().values();
                for (PEWorkflowDAG.Edge edge : edges) {
                    edge.setEnable(Boolean.valueOf(false));
                    targetEdges.add(edge);
                }
            }
            WorkflowDAGUtils.handleDisableEdges(targetEdges, dag);
        }
    }

    public static WorkflowDAG convert(PEWorkflowDAG peWorkflowDAG) {
        HashSet rootIds = Sets.newHashSet();
        HashMap id2Node = Maps.newHashMap();
        if (peWorkflowDAG.getNodes() == null || peWorkflowDAG.getNodes().isEmpty()) {
            throw new PowerJobException("empty graph");
        }
        peWorkflowDAG.getNodes().forEach(node -> {
            Long nodeId = node.getNodeId();
            WorkflowDAG.Node n = new WorkflowDAG.Node((PEWorkflowDAG.Node)node);
            id2Node.put(nodeId, n);
            rootIds.add(nodeId);
        });
        peWorkflowDAG.getEdges().forEach(edge -> {
            WorkflowDAG.Node from = (WorkflowDAG.Node)id2Node.get(edge.getFrom());
            WorkflowDAG.Node to = (WorkflowDAG.Node)id2Node.get(edge.getTo());
            if (from == null || to == null) {
                throw new PowerJobException("Illegal Edge: " + JsonUtils.toJSONString((Object)edge));
            }
            from.getSuccessors().add(to);
            from.getSuccessorEdgeMap().put(to, (PEWorkflowDAG.Edge)edge);
            to.getDependencies().add(from);
            to.getDependenceEdgeMap().put(from, (PEWorkflowDAG.Edge)edge);
            rootIds.remove(to.getNodeId());
        });
        if (rootIds.isEmpty()) {
            throw new PowerJobException("Illegal DAG: " + JsonUtils.toJSONString((Object)peWorkflowDAG));
        }
        LinkedList roots = Lists.newLinkedList();
        rootIds.forEach(id -> roots.add(id2Node.get(id)));
        return new WorkflowDAG(roots, id2Node);
    }

    private static boolean invalidPath(WorkflowDAG.Node root, Set<Long> ids, Set<Long> nodeIdContainer) {
        if (ids.contains(root.getNodeId())) {
            return true;
        }
        nodeIdContainer.add(root.getNodeId());
        if (root.getSuccessors().isEmpty()) {
            return false;
        }
        ids.add(root.getNodeId());
        for (WorkflowDAG.Node node : root.getSuccessors()) {
            if (!WorkflowDAGUtils.invalidPath(node, Sets.newHashSet(ids), nodeIdContainer)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$listReadyNodes$2(Multimap relyMap, Multimap successorMap, PEWorkflowDAG.Edge edge) {
        relyMap.put((Object)edge.getTo(), (Object)edge.getFrom());
        successorMap.put((Object)edge.getFrom(), (Object)edge.getTo());
    }
}

