/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.scheduler.auxiliary.impl;

import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.server.core.scheduler.auxiliary.AbstractTimingStrategyHandler;

@Component
public class FixedRateTimingStrategyHandler
extends AbstractTimingStrategyHandler {
    @Override
    public void validate(String timeExpression) {
        long delay;
        try {
            delay = Long.parseLong(timeExpression);
        }
        catch (Exception e) {
            throw new PowerJobException("invalid timeExpression!");
        }
        int maxInterval = Integer.parseInt(System.getProperty("powerjob.server.frequency-job.max-interval", "120000"));
        if (delay > (long)maxInterval) {
            throw new PowerJobException("the rate must be less than " + maxInterval + "ms");
        }
        if (delay <= 0L) {
            throw new PowerJobException("the rate must be greater than 0 ms");
        }
    }

    @Override
    public Long calculateNextTriggerTime(Long preTriggerTime, String timeExpression, Long startTime, Long endTime) {
        long r = startTime != null && startTime > preTriggerTime ? startTime : preTriggerTime + Long.parseLong(timeExpression);
        return endTime != null && endTime < r ? null : Long.valueOf(r);
    }

    @Override
    public TimeExpressionType supportType() {
        return TimeExpressionType.FIXED_RATE;
    }
}

