/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.scheduler.auxiliary.impl;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.common.utils.TimeUtils;
import tech.powerjob.server.core.scheduler.auxiliary.TimeOfDay;
import tech.powerjob.server.core.scheduler.auxiliary.TimingStrategyHandler;

@Component
public class DailyTimeIntervalStrategyHandler
implements TimingStrategyHandler {
    private static final Set<Integer> ALL_DAY = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});

    @Override
    public TimeExpressionType supportType() {
        return TimeExpressionType.DAILY_TIME_INTERVAL;
    }

    @Override
    public void validate(String timeExpression) {
        DailyTimeIntervalExpress ep = (DailyTimeIntervalExpress)JsonUtils.parseObject((String)timeExpression, DailyTimeIntervalExpress.class);
        CommonUtils.requireNonNull((Object)ep.interval, (String)"interval can't be null or empty in DailyTimeIntervalExpress");
        CommonUtils.requireNonNull((Object)ep.startTimeOfDay, (String)"startTimeOfDay can't be null or empty in DailyTimeIntervalExpress");
        CommonUtils.requireNonNull((Object)ep.endTimeOfDay, (String)"endTimeOfDay can't be null or empty in DailyTimeIntervalExpress");
        TimeOfDay startTime = TimeOfDay.from(ep.startTimeOfDay);
        TimeOfDay endTime = TimeOfDay.from(ep.endTimeOfDay);
        if (endTime.before(startTime)) {
            throw new IllegalArgumentException("endTime should after startTime!");
        }
        if (StringUtils.isNotEmpty((CharSequence)ep.intervalUnit)) {
            TimeUnit.valueOf(ep.intervalUnit);
        }
    }

    @Override
    public Long calculateNextTriggerTime(Long preTriggerTime, String timeExpression, Long startTime, Long endTime) {
        DailyTimeIntervalExpress ep = (DailyTimeIntervalExpress)JsonUtils.parseObject((String)timeExpression, DailyTimeIntervalExpress.class);
        if (startTime != null && startTime > System.currentTimeMillis() && preTriggerTime < startTime) {
            return DailyTimeIntervalStrategyHandler.calculateInRangeTime(startTime, ep);
        }
        TimeUnit timeUnit = Optional.ofNullable(ep.intervalUnit).map(TimeUnit::valueOf).orElse(TimeUnit.SECONDS);
        long interval = timeUnit.toMillis(ep.interval);
        Long ret = DailyTimeIntervalStrategyHandler.calculateInRangeTime(preTriggerTime + interval, ep);
        if (ret == null || ret <= Optional.ofNullable(endTime).orElse(Long.MAX_VALUE)) {
            return ret;
        }
        return null;
    }

    static Long calculateInRangeTime(Long time, DailyTimeIntervalExpress ep) {
        Set targetDays;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(time));
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int week = TimeUtils.calculateWeek((int)year, (int)month, (int)day);
        Set set = targetDays = CollectionUtils.isEmpty((Collection)ep.daysOfWeek) ? ALL_DAY : ep.daysOfWeek;
        if (!targetDays.contains(week)) {
            DailyTimeIntervalStrategyHandler.simpleSetCalendar(calendar, 0, 0, 0);
            Date tomorrowZero = DateUtils.addDays((Date)calendar.getTime(), (int)1);
            return DailyTimeIntervalStrategyHandler.calculateInRangeTime(tomorrowZero.getTime(), ep);
        }
        TimeOfDay rangeStartTime = TimeOfDay.from(ep.startTimeOfDay);
        DailyTimeIntervalStrategyHandler.simpleSetCalendar(calendar, rangeStartTime.getHour(), rangeStartTime.getMinute(), rangeStartTime.getSecond());
        long todayStartTs = calendar.getTimeInMillis();
        if (time < todayStartTs) {
            return todayStartTs;
        }
        TimeOfDay rangeEndTime = TimeOfDay.from(ep.endTimeOfDay);
        DailyTimeIntervalStrategyHandler.simpleSetCalendar(calendar, rangeEndTime.getHour(), rangeEndTime.getMinute(), rangeEndTime.getSecond());
        long todayEndTs = calendar.getTimeInMillis();
        if (time <= todayEndTs) {
            return time;
        }
        DailyTimeIntervalStrategyHandler.simpleSetCalendar(calendar, 0, 0, 0);
        return DailyTimeIntervalStrategyHandler.calculateInRangeTime(DateUtils.addDays((Date)calendar.getTime(), (int)1).getTime(), ep);
    }

    private static void simpleSetCalendar(Calendar calendar, int h, int m, int s) {
        calendar.set(13, s);
        calendar.set(12, m);
        calendar.set(11, h);
        calendar.set(14, 0);
    }

    static class DailyTimeIntervalExpress
    implements Serializable {
        private Long interval;
        private String startTimeOfDay;
        private String endTimeOfDay;
        private String intervalUnit;
        private Set<Integer> daysOfWeek;

        public Long getInterval() {
            return this.interval;
        }

        public String getStartTimeOfDay() {
            return this.startTimeOfDay;
        }

        public String getEndTimeOfDay() {
            return this.endTimeOfDay;
        }

        public String getIntervalUnit() {
            return this.intervalUnit;
        }

        public Set<Integer> getDaysOfWeek() {
            return this.daysOfWeek;
        }

        public void setInterval(Long interval) {
            this.interval = interval;
        }

        public void setStartTimeOfDay(String startTimeOfDay) {
            this.startTimeOfDay = startTimeOfDay;
        }

        public void setEndTimeOfDay(String endTimeOfDay) {
            this.endTimeOfDay = endTimeOfDay;
        }

        public void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        public void setDaysOfWeek(Set<Integer> daysOfWeek) {
            this.daysOfWeek = daysOfWeek;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DailyTimeIntervalExpress)) {
                return false;
            }
            DailyTimeIntervalExpress other = (DailyTimeIntervalExpress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$interval = this.getInterval();
            Long other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
                return false;
            }
            String this$startTimeOfDay = this.getStartTimeOfDay();
            String other$startTimeOfDay = other.getStartTimeOfDay();
            if (this$startTimeOfDay == null ? other$startTimeOfDay != null : !this$startTimeOfDay.equals(other$startTimeOfDay)) {
                return false;
            }
            String this$endTimeOfDay = this.getEndTimeOfDay();
            String other$endTimeOfDay = other.getEndTimeOfDay();
            if (this$endTimeOfDay == null ? other$endTimeOfDay != null : !this$endTimeOfDay.equals(other$endTimeOfDay)) {
                return false;
            }
            String this$intervalUnit = this.getIntervalUnit();
            String other$intervalUnit = other.getIntervalUnit();
            if (this$intervalUnit == null ? other$intervalUnit != null : !this$intervalUnit.equals(other$intervalUnit)) {
                return false;
            }
            Set<Integer> this$daysOfWeek = this.getDaysOfWeek();
            Set<Integer> other$daysOfWeek = other.getDaysOfWeek();
            return !(this$daysOfWeek == null ? other$daysOfWeek != null : !((Object)this$daysOfWeek).equals(other$daysOfWeek));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DailyTimeIntervalExpress;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
            String $startTimeOfDay = this.getStartTimeOfDay();
            result = result * 59 + ($startTimeOfDay == null ? 43 : $startTimeOfDay.hashCode());
            String $endTimeOfDay = this.getEndTimeOfDay();
            result = result * 59 + ($endTimeOfDay == null ? 43 : $endTimeOfDay.hashCode());
            String $intervalUnit = this.getIntervalUnit();
            result = result * 59 + ($intervalUnit == null ? 43 : $intervalUnit.hashCode());
            Set<Integer> $daysOfWeek = this.getDaysOfWeek();
            result = result * 59 + ($daysOfWeek == null ? 43 : ((Object)$daysOfWeek).hashCode());
            return result;
        }

        public String toString() {
            return "DailyTimeIntervalStrategyHandler.DailyTimeIntervalExpress(interval=" + this.getInterval() + ", startTimeOfDay=" + this.getStartTimeOfDay() + ", endTimeOfDay=" + this.getEndTimeOfDay() + ", intervalUnit=" + this.getIntervalUnit() + ", daysOfWeek=" + this.getDaysOfWeek() + ")";
        }
    }
}

