/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.scheduler.auxiliary.impl;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.server.core.scheduler.auxiliary.TimingStrategyHandler;

@Component
public class CronTimingStrategyHandler
implements TimingStrategyHandler {
    private final CronParser cronParser;

    public CronTimingStrategyHandler() {
        CronDefinition cronDefinition = CronDefinitionBuilder.defineCron().withSeconds().withValidRange(0, 59).and().withMinutes().withValidRange(0, 59).and().withHours().withValidRange(0, 23).and().withDayOfMonth().withValidRange(1, 31).supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().withValidRange(1, 12).and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsHash().supportsL().supportsQuestionMark().and().withYear().withValidRange(1970, 2099).withStrictRange().optional().and().instance();
        this.cronParser = new CronParser(cronDefinition);
    }

    @Override
    public void validate(String timeExpression) {
        this.cronParser.parse(timeExpression);
    }

    @Override
    public Long calculateNextTriggerTime(Long preTriggerTime, String timeExpression, Long startTime, Long endTime) {
        Instant instant;
        ZonedDateTime preZonedDateTime;
        Optional opt;
        Cron cron = this.cronParser.parse(timeExpression);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        if (startTime != null && startTime > System.currentTimeMillis() && preTriggerTime < startTime) {
            Optional zonedDateTime = executionTime.lastExecution(ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneId.systemDefault()));
            preTriggerTime = zonedDateTime.map(dateTime -> dateTime.toEpochSecond() * 1000L).orElse(startTime);
        }
        if ((opt = executionTime.nextExecution(preZonedDateTime = ZonedDateTime.ofInstant(instant = Instant.ofEpochMilli(preTriggerTime), ZoneId.systemDefault()))).isPresent()) {
            long nextTriggerTime = ((ZonedDateTime)opt.get()).toEpochSecond() * 1000L;
            if (endTime != null && endTime < nextTriggerTime) {
                return null;
            }
            return nextTriggerTime;
        }
        return null;
    }

    @Override
    public TimeExpressionType supportType() {
        return TimeExpressionType.CRON;
    }
}

