/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.scheduler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.model.LifeCycle;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.common.timewheel.holder.InstanceTimeWheelService;
import tech.powerjob.server.core.DispatchService;
import tech.powerjob.server.core.instance.InstanceService;
import tech.powerjob.server.core.scheduler.TimingStrategyService;
import tech.powerjob.server.core.service.JobService;
import tech.powerjob.server.core.workflow.WorkflowInstanceManager;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;
import tech.powerjob.server.remote.transporter.TransportService;
import tech.powerjob.server.remote.worker.WorkerClusterManagerService;

@Service
public class PowerScheduleService {
    private static final Logger log = LoggerFactory.getLogger(PowerScheduleService.class);
    private static final int MAX_APP_NUM = 10;
    private final TransportService transportService;
    private final DispatchService dispatchService;
    private final InstanceService instanceService;
    private final WorkflowInstanceManager workflowInstanceManager;
    private final AppInfoRepository appInfoRepository;
    private final JobInfoRepository jobInfoRepository;
    private final WorkflowInfoRepository workflowInfoRepository;
    private final InstanceInfoRepository instanceInfoRepository;
    private final JobService jobService;
    private final TimingStrategyService timingStrategyService;
    public static final long SCHEDULE_RATE = 15000L;

    public void scheduleNormalJob(TimeExpressionType timeExpressionType) {
        long start = System.currentTimeMillis();
        try {
            List allAppIds = this.appInfoRepository.listAppIdByCurrentServer(this.transportService.defaultProtocol().getAddress());
            if (CollectionUtils.isEmpty((Collection)allAppIds)) {
                log.info("[NormalScheduler] current server has no app's job to schedule.");
                return;
            }
            this.scheduleNormalJob0(timeExpressionType, allAppIds);
        }
        catch (Exception e) {
            log.error("[NormalScheduler] schedule cron job failed.", (Throwable)e);
        }
        long cost = System.currentTimeMillis() - start;
        log.info("[NormalScheduler] {} job schedule use {} ms.", (Object)timeExpressionType, (Object)cost);
        if (cost > 15000L) {
            log.warn("[NormalScheduler] The database query is using too much time({}ms), please check if the database load is too high!", (Object)cost);
        }
    }

    public void scheduleCronWorkflow() {
        long start = System.currentTimeMillis();
        try {
            List allAppIds = this.appInfoRepository.listAppIdByCurrentServer(this.transportService.defaultProtocol().getAddress());
            if (CollectionUtils.isEmpty((Collection)allAppIds)) {
                log.info("[CronWorkflowSchedule] current server has no app's workflow to schedule.");
                return;
            }
            this.scheduleWorkflowCore(allAppIds);
        }
        catch (Exception e) {
            log.error("[CronWorkflowSchedule] schedule cron workflow failed.", (Throwable)e);
        }
        long cost = System.currentTimeMillis() - start;
        log.info("[CronWorkflowSchedule] cron workflow schedule use {} ms.", (Object)cost);
        if (cost > 15000L) {
            log.warn("[CronWorkflowSchedule] The database query is using too much time({}ms), please check if the database load is too high!", (Object)cost);
        }
    }

    public void scheduleFrequentJob() {
        long start = System.currentTimeMillis();
        try {
            List allAppIds = this.appInfoRepository.listAppIdByCurrentServer(this.transportService.defaultProtocol().getAddress());
            if (CollectionUtils.isEmpty((Collection)allAppIds)) {
                log.info("[FrequentJobSchedule] current server has no app's job to schedule.");
                return;
            }
            this.scheduleFrequentJobCore(allAppIds);
        }
        catch (Exception e) {
            log.error("[FrequentJobSchedule] schedule frequent job failed.", (Throwable)e);
        }
        long cost = System.currentTimeMillis() - start;
        log.info("[FrequentJobSchedule] frequent job schedule use {} ms.", (Object)cost);
        if (cost > 15000L) {
            log.warn("[FrequentJobSchedule] The database query is using too much time({}ms), please check if the database load is too high!", (Object)cost);
        }
    }

    public void cleanData() {
        try {
            List allAppIds = this.appInfoRepository.listAppIdByCurrentServer(this.transportService.defaultProtocol().getAddress());
            if (allAppIds.isEmpty()) {
                return;
            }
            WorkerClusterManagerService.clean((List)allAppIds);
        }
        catch (Exception e) {
            log.error("[CleanData] clean data failed.", (Throwable)e);
        }
    }

    private void scheduleNormalJob0(TimeExpressionType timeExpressionType, List<Long> appIds) {
        long nowTime = System.currentTimeMillis();
        long timeThreshold = nowTime + 30000L;
        Lists.partition(appIds, (int)10).forEach(partAppIds -> {
            try {
                List jobInfos = this.jobInfoRepository.findByAppIdInAndStatusAndTimeExpressionTypeAndNextTriggerTimeLessThanEqual(partAppIds, SwitchableStatus.ENABLE.getV(), timeExpressionType.getV(), timeThreshold);
                if (CollectionUtils.isEmpty((Collection)jobInfos)) {
                    return;
                }
                HashMap jobId2InstanceId = Maps.newHashMap();
                log.info("[NormalScheduler] These {} jobs will be scheduled: {}.", (Object)timeExpressionType.name(), (Object)jobInfos);
                jobInfos.forEach(jobInfo -> {
                    Long instanceId = this.instanceService.create(jobInfo.getId(), jobInfo.getAppId(), jobInfo.getJobParams(), null, null, jobInfo.getNextTriggerTime()).getInstanceId();
                    jobId2InstanceId.put(jobInfo.getId(), instanceId);
                });
                this.instanceInfoRepository.flush();
                jobInfos.forEach(jobInfoDO -> {
                    Long instanceId = (Long)jobId2InstanceId.get(jobInfoDO.getId());
                    long targetTriggerTime = jobInfoDO.getNextTriggerTime();
                    long delay = 0L;
                    if (targetTriggerTime < nowTime) {
                        log.warn("[Job-{}] schedule delay, expect: {}, current: {}", new Object[]{jobInfoDO.getId(), targetTriggerTime, System.currentTimeMillis()});
                    } else {
                        delay = targetTriggerTime - nowTime;
                    }
                    InstanceTimeWheelService.schedule((Long)instanceId, (Long)delay, () -> this.dispatchService.dispatch((JobInfoDO)jobInfoDO, instanceId, Optional.empty(), Optional.empty()));
                });
                jobInfos.forEach(jobInfoDO -> {
                    try {
                        this.refreshJob(timeExpressionType, (JobInfoDO)jobInfoDO);
                    }
                    catch (Exception e) {
                        log.error("[Job-{}] refresh job failed.", (Object)jobInfoDO.getId(), (Object)e);
                    }
                });
                this.jobInfoRepository.flush();
            }
            catch (Exception e) {
                log.error("[NormalScheduler] schedule {} job failed.", (Object)timeExpressionType.name(), (Object)e);
            }
        });
    }

    private void scheduleWorkflowCore(List<Long> appIds) {
        long nowTime = System.currentTimeMillis();
        long timeThreshold = nowTime + 30000L;
        Lists.partition(appIds, (int)10).forEach(partAppIds -> {
            List wfInfos = this.workflowInfoRepository.findByAppIdInAndStatusAndTimeExpressionTypeAndNextTriggerTimeLessThanEqual(partAppIds, SwitchableStatus.ENABLE.getV(), TimeExpressionType.CRON.getV(), timeThreshold);
            if (CollectionUtils.isEmpty((Collection)wfInfos)) {
                return;
            }
            wfInfos.forEach(wfInfo -> {
                Long wfInstanceId = this.workflowInstanceManager.create((WorkflowInfoDO)wfInfo, null, wfInfo.getNextTriggerTime(), null);
                long delay = wfInfo.getNextTriggerTime() - System.currentTimeMillis();
                if (delay < 0L) {
                    log.warn("[Workflow-{}] workflow schedule delay, expect:{}, actual: {}", new Object[]{wfInfo.getId(), wfInfo.getNextTriggerTime(), System.currentTimeMillis()});
                    delay = 0L;
                }
                InstanceTimeWheelService.schedule((Long)wfInstanceId, (Long)delay, () -> this.workflowInstanceManager.start((WorkflowInfoDO)wfInfo, wfInstanceId));
                try {
                    this.refreshWorkflow((WorkflowInfoDO)wfInfo);
                }
                catch (Exception e) {
                    log.error("[Workflow-{}] refresh workflow failed.", (Object)wfInfo.getId(), (Object)e);
                }
            });
            this.workflowInfoRepository.flush();
        });
    }

    private void scheduleFrequentJobCore(List<Long> appIds) {
        Lists.partition(appIds, (int)10).forEach(partAppIds -> {
            try {
                List jobIds = this.jobInfoRepository.findByAppIdInAndStatusAndTimeExpressionTypeIn(partAppIds, SwitchableStatus.ENABLE.getV(), TimeExpressionType.FREQUENT_TYPES);
                if (CollectionUtils.isEmpty((Collection)jobIds)) {
                    return;
                }
                List runningJobIdList = this.instanceInfoRepository.findByJobIdInAndStatusIn(jobIds, InstanceStatus.GENERALIZED_RUNNING_STATUS);
                HashSet runningJobIdSet = Sets.newHashSet((Iterable)runningJobIdList);
                LinkedList notRunningJobIds = Lists.newLinkedList();
                jobIds.forEach(jobId -> {
                    if (!runningJobIdSet.contains(jobId)) {
                        notRunningJobIds.add(jobId);
                    }
                });
                if (CollectionUtils.isEmpty((Collection)notRunningJobIds)) {
                    return;
                }
                notRunningJobIds.forEach(jobId -> {
                    Optional jobInfoOpt = this.jobInfoRepository.findById(jobId);
                    jobInfoOpt.ifPresent(jobInfoDO -> {
                        LifeCycle lifeCycle = LifeCycle.parse((String)jobInfoDO.getLifecycle());
                        if (lifeCycle.getEnd() != null && lifeCycle.getEnd() < System.currentTimeMillis()) {
                            jobInfoDO.setStatus(Integer.valueOf(SwitchableStatus.DISABLE.getV()));
                            jobInfoDO.setGmtModified(new Date());
                            this.jobInfoRepository.saveAndFlush(jobInfoDO);
                            log.info("[FrequentScheduler] disable frequent job,id:{}.", (Object)jobInfoDO.getId());
                        } else if (lifeCycle.getStart() == null || lifeCycle.getStart() < System.currentTimeMillis() + 30000L) {
                            log.info("[FrequentScheduler] schedule frequent job,id:{}.", (Object)jobInfoDO.getId());
                            this.jobService.runJob(jobInfoDO.getAppId(), (Long)jobId, null, Optional.ofNullable(lifeCycle.getStart()).orElse(0L) - System.currentTimeMillis());
                        }
                    });
                });
            }
            catch (Exception e) {
                log.error("[FrequentScheduler] schedule frequent job failed.", (Throwable)e);
            }
        });
    }

    private void refreshJob(TimeExpressionType timeExpressionType, JobInfoDO jobInfo) {
        LifeCycle lifeCycle = LifeCycle.parse((String)jobInfo.getLifecycle());
        Long nextTriggerTime = this.timingStrategyService.calculateNextTriggerTime(jobInfo.getNextTriggerTime(), timeExpressionType, jobInfo.getTimeExpression(), lifeCycle.getStart(), lifeCycle.getEnd());
        JobInfoDO updatedJobInfo = new JobInfoDO();
        BeanUtils.copyProperties((Object)jobInfo, (Object)updatedJobInfo);
        if (nextTriggerTime == null) {
            log.warn("[Job-{}] this job won't be scheduled anymore, system will set the status to DISABLE!", (Object)jobInfo.getId());
            updatedJobInfo.setStatus(Integer.valueOf(SwitchableStatus.DISABLE.getV()));
        } else {
            updatedJobInfo.setNextTriggerTime(nextTriggerTime);
        }
        updatedJobInfo.setGmtModified(new Date());
        this.jobInfoRepository.save((Object)updatedJobInfo);
    }

    private void refreshWorkflow(WorkflowInfoDO wfInfo) {
        LifeCycle lifeCycle = LifeCycle.parse((String)wfInfo.getLifecycle());
        Long nextTriggerTime = this.timingStrategyService.calculateNextTriggerTime(wfInfo.getNextTriggerTime(), TimeExpressionType.CRON, wfInfo.getTimeExpression(), lifeCycle.getStart(), lifeCycle.getEnd());
        WorkflowInfoDO updateEntity = new WorkflowInfoDO();
        BeanUtils.copyProperties((Object)wfInfo, (Object)updateEntity);
        if (nextTriggerTime == null) {
            log.warn("[Workflow-{}] this workflow won't be scheduled anymore, system will set the status to DISABLE!", (Object)wfInfo.getId());
            updateEntity.setStatus(Integer.valueOf(SwitchableStatus.DISABLE.getV()));
        } else {
            updateEntity.setNextTriggerTime(nextTriggerTime);
        }
        updateEntity.setGmtModified(new Date());
        this.workflowInfoRepository.save((Object)updateEntity);
    }

    public PowerScheduleService(TransportService transportService, DispatchService dispatchService, InstanceService instanceService, WorkflowInstanceManager workflowInstanceManager, AppInfoRepository appInfoRepository, JobInfoRepository jobInfoRepository, WorkflowInfoRepository workflowInfoRepository, InstanceInfoRepository instanceInfoRepository, JobService jobService, TimingStrategyService timingStrategyService) {
        this.transportService = transportService;
        this.dispatchService = dispatchService;
        this.instanceService = instanceService;
        this.workflowInstanceManager = workflowInstanceManager;
        this.appInfoRepository = appInfoRepository;
        this.jobInfoRepository = jobInfoRepository;
        this.workflowInfoRepository = workflowInfoRepository;
        this.instanceInfoRepository = instanceInfoRepository;
        this.jobService = jobService;
        this.timingStrategyService = timingStrategyService;
    }
}

