/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.WorkflowInstanceStatus;
import tech.powerjob.server.common.utils.OmsFileUtils;
import tech.powerjob.server.extension.LockService;
import tech.powerjob.server.persistence.mongodb.GridFsManager;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowInstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowNodeInfoRepository;
import tech.powerjob.server.remote.worker.WorkerClusterManagerService;

@Service
public class CleanService {
    private static final Logger log = LoggerFactory.getLogger(CleanService.class);
    private final GridFsManager gridFsManager;
    private final InstanceInfoRepository instanceInfoRepository;
    private final WorkflowInstanceInfoRepository workflowInstanceInfoRepository;
    private final WorkflowNodeInfoRepository workflowNodeInfoRepository;
    private final LockService lockService;
    private final int instanceInfoRetentionDay;
    private final int localContainerRetentionDay;
    private final int remoteContainerRetentionDay;
    private static final int TEMPORARY_RETENTION_DAY = 3;
    private static final String CLEAN_TIME_EXPRESSION = "0 0 3 * * ?";
    private static final String HISTORY_DELETE_LOCK = "history_delete_lock";

    public CleanService(GridFsManager gridFsManager, InstanceInfoRepository instanceInfoRepository, WorkflowInstanceInfoRepository workflowInstanceInfoRepository, WorkflowNodeInfoRepository workflowNodeInfoRepository, LockService lockService, @Value(value="${oms.instanceinfo.retention}") int instanceInfoRetentionDay, @Value(value="${oms.container.retention.local}") int localContainerRetentionDay, @Value(value="${oms.container.retention.remote}") int remoteContainerRetentionDay) {
        this.gridFsManager = gridFsManager;
        this.instanceInfoRepository = instanceInfoRepository;
        this.workflowInstanceInfoRepository = workflowInstanceInfoRepository;
        this.workflowNodeInfoRepository = workflowNodeInfoRepository;
        this.lockService = lockService;
        this.instanceInfoRetentionDay = instanceInfoRetentionDay;
        this.localContainerRetentionDay = localContainerRetentionDay;
        this.remoteContainerRetentionDay = remoteContainerRetentionDay;
    }

    @Async(value="PowerJobTimingPool")
    @Scheduled(cron="0 0 3 * * ?")
    public void timingClean() {
        WorkerClusterManagerService.cleanUp();
        this.cleanLocal(OmsFileUtils.genLogDirPath(), this.instanceInfoRetentionDay);
        this.cleanLocal(OmsFileUtils.genContainerJarPath(), this.localContainerRetentionDay);
        this.cleanLocal(OmsFileUtils.genTemporaryPath(), 3);
        this.cleanByOneServer();
    }

    private void cleanByOneServer() {
        boolean lock = this.lockService.tryLock(HISTORY_DELETE_LOCK, 600000L);
        if (!lock) {
            log.info("[CleanService] clean job is already running, just return.");
            return;
        }
        try {
            this.cleanInstanceLog();
            this.cleanWorkflowInstanceLog();
            this.cleanWorkflowNodeInfo();
            this.cleanRemote("log", this.instanceInfoRetentionDay);
            this.cleanRemote("container", this.remoteContainerRetentionDay);
        }
        finally {
            this.lockService.unlock(HISTORY_DELETE_LOCK);
        }
    }

    @VisibleForTesting
    public void cleanLocal(String path, int day) {
        if (day < 0) {
            log.info("[CleanService] won't clean up {} because of offset day <= 0.", (Object)path);
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        File[] logFiles = dir.listFiles();
        if (logFiles == null || logFiles.length == 0) {
            return;
        }
        long maxOffset = (long)(day * 24 * 60 * 60) * 1000L;
        for (File f : logFiles) {
            long offset = System.currentTimeMillis() - f.lastModified();
            if (offset < maxOffset) continue;
            if (!f.delete()) {
                log.warn("[CleanService] delete file({}) failed.", (Object)f.getName());
                continue;
            }
            log.info("[CleanService] delete file({}) successfully.", (Object)f.getName());
        }
        log.info("[CleanService] clean {} successfully, using {}.", (Object)path, (Object)stopwatch.stop());
    }

    @VisibleForTesting
    public void cleanRemote(String bucketName, int day) {
        if (day < 0) {
            log.info("[CleanService] won't clean up bucket({}) because of offset day <= 0.", (Object)bucketName);
            return;
        }
        if (this.gridFsManager.available()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                this.gridFsManager.deleteBefore(bucketName, day);
            }
            catch (Exception e) {
                log.warn("[CleanService] clean remote bucket({}) failed.", (Object)bucketName, (Object)e);
            }
            log.info("[CleanService] clean remote bucket({}) successfully, using {}.", (Object)bucketName, (Object)stopwatch.stop());
        }
    }

    @VisibleForTesting
    public void cleanInstanceLog() {
        if (this.instanceInfoRetentionDay < 0) {
            return;
        }
        try {
            Date t = DateUtils.addDays((Date)new Date(), (int)(-this.instanceInfoRetentionDay));
            int num = this.instanceInfoRepository.deleteAllByGmtModifiedBeforeAndStatusIn(t, InstanceStatus.FINISHED_STATUS);
            log.info("[CleanService] deleted {} instanceInfo records whose modify time before {}.", (Object)num, (Object)t);
        }
        catch (Exception e) {
            log.warn("[CleanService] clean instanceInfo failed.", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void cleanWorkflowInstanceLog() {
        if (this.instanceInfoRetentionDay < 0) {
            return;
        }
        try {
            Date t = DateUtils.addDays((Date)new Date(), (int)(-this.instanceInfoRetentionDay));
            int num = this.workflowInstanceInfoRepository.deleteAllByGmtModifiedBeforeAndStatusIn(t, WorkflowInstanceStatus.FINISHED_STATUS);
            log.info("[CleanService] deleted {} workflow instanceInfo records whose modify time before {}.", (Object)num, (Object)t);
        }
        catch (Exception e) {
            log.warn("[CleanService] clean workflow instanceInfo failed.", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void cleanWorkflowNodeInfo() {
        try {
            Date t = DateUtils.addDays((Date)new Date(), (int)-1);
            int num = this.workflowNodeInfoRepository.deleteAllByWorkflowIdIsNullAndGmtCreateBefore(t);
            log.info("[CleanService] deleted {} node records whose create time before {} and workflowId is null.", (Object)num, (Object)t);
        }
        catch (Exception e) {
            log.warn("[CleanService] clean workflow node info failed.", (Throwable)e);
        }
    }
}

