/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.instance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;

@Service
public class InstanceMetadataService
implements InitializingBean {
    private final JobInfoRepository jobInfoRepository;
    private final InstanceInfoRepository instanceInfoRepository;
    private Cache<Long, JobInfoDO> instanceId2JobInfoCache;
    @Value(value="${oms.instance.metadata.cache.size}")
    private int instanceMetadataCacheSize;
    private static final int CACHE_CONCURRENCY_LEVEL = 16;

    public void afterPropertiesSet() throws Exception {
        this.instanceId2JobInfoCache = CacheBuilder.newBuilder().concurrencyLevel(16).maximumSize((long)this.instanceMetadataCacheSize).softValues().build();
    }

    public JobInfoDO fetchJobInfoByInstanceId(Long instanceId) throws ExecutionException {
        return (JobInfoDO)this.instanceId2JobInfoCache.get((Object)instanceId, () -> {
            InstanceInfoDO instanceInfo = this.instanceInfoRepository.findByInstanceId(instanceId.longValue());
            if (instanceInfo != null) {
                Optional jobInfoOpt = this.jobInfoRepository.findById((Object)instanceInfo.getJobId());
                return (JobInfoDO)jobInfoOpt.orElseThrow(() -> new IllegalArgumentException("can't find JobInfo by jobId: " + instanceInfo.getJobId()));
            }
            throw new IllegalArgumentException("can't find Instance by instanceId: " + instanceId);
        });
    }

    public void loadJobInfo(Long instanceId, JobInfoDO jobInfoDO) {
        this.instanceId2JobInfoCache.put((Object)instanceId, (Object)jobInfoDO);
    }

    public void invalidateJobInfo(Long instanceId) {
        this.instanceId2JobInfoCache.invalidate((Object)instanceId);
    }

    public InstanceMetadataService(JobInfoRepository jobInfoRepository, InstanceInfoRepository instanceInfoRepository) {
        this.jobInfoRepository = jobInfoRepository;
        this.instanceInfoRepository = instanceInfoRepository;
    }
}

