/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.instance;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.model.LifeCycle;
import tech.powerjob.common.request.ServerStopInstanceReq;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.common.timewheel.holder.HashedWheelTimerHolder;
import tech.powerjob.server.common.utils.SpringUtils;
import tech.powerjob.server.core.instance.InstanceLogService;
import tech.powerjob.server.core.instance.InstanceMetadataService;
import tech.powerjob.server.core.service.UserService;
import tech.powerjob.server.core.workflow.WorkflowInstanceManager;
import tech.powerjob.server.extension.defaultimpl.alarm.AlarmCenter;
import tech.powerjob.server.extension.defaultimpl.alarm.module.Alarm;
import tech.powerjob.server.extension.defaultimpl.alarm.module.JobInstanceAlarm;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.model.UserInfoDO;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.remote.aware.TransportServiceAware;
import tech.powerjob.server.remote.transporter.TransportService;
import tech.powerjob.server.remote.transporter.impl.ServerURLFactory;
import tech.powerjob.server.remote.worker.WorkerClusterQueryService;

@Service
public class InstanceManager
implements TransportServiceAware {
    private static final Logger log = LoggerFactory.getLogger(InstanceManager.class);
    private final AlarmCenter alarmCenter;
    private final InstanceLogService instanceLogService;
    private final InstanceMetadataService instanceMetadataService;
    private final InstanceInfoRepository instanceInfoRepository;
    private final WorkflowInstanceManager workflowInstanceManager;
    private final WorkerClusterQueryService workerClusterQueryService;
    private TransportService transportService;

    public void updateStatus(TaskTrackerReportInstanceStatusReq req) throws ExecutionException {
        Long instanceId = req.getInstanceId();
        JobInfoDO jobInfo = this.instanceMetadataService.fetchJobInfoByInstanceId(req.getInstanceId());
        InstanceInfoDO instanceInfo = this.instanceInfoRepository.findByInstanceId(instanceId.longValue());
        if (instanceInfo == null) {
            log.warn("[InstanceManager-{}] can't find InstanceInfo from database", (Object)instanceId);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)instanceInfo.getTaskTrackerAddress())) {
            log.warn("[InstanceManager-{}] TaskTrackerAddress is empty, server will wait then acquire again!", (Object)instanceId);
            CommonUtils.easySleep((long)277L);
            instanceInfo = this.instanceInfoRepository.findByInstanceId(instanceId.longValue());
        }
        int originStatus = instanceInfo.getStatus();
        if (req.getReportTime() <= instanceInfo.getLastReportTime()) {
            log.warn("[InstanceManager-{}] receive the expired status report request: {}, this report will be dropped.", (Object)instanceId, (Object)req);
            return;
        }
        if (!req.getSourceAddress().equals(instanceInfo.getTaskTrackerAddress())) {
            log.warn("[InstanceManager-{}] receive the other TaskTracker's report: {}, but current TaskTracker is {}, this report will be dropped.", new Object[]{instanceId, req, instanceInfo.getTaskTrackerAddress()});
            return;
        }
        InstanceStatus receivedInstanceStatus = InstanceStatus.of((int)req.getInstanceStatus());
        Integer timeExpressionType = jobInfo.getTimeExpressionType();
        instanceInfo.setLastReportTime(Long.valueOf(req.getReportTime()));
        instanceInfo.setGmtModified(new Date());
        if (TimeExpressionType.FREQUENT_TYPES.contains(timeExpressionType)) {
            if (instanceInfo.getStatus().intValue() == InstanceStatus.FAILED.getV()) {
                log.warn("[InstanceManager-{}] receive TaskTracker's report: {}, but current instance is already failed, this instance should be killed.", (Object)instanceId, (Object)req);
                this.stopInstance(instanceId, instanceInfo);
                return;
            }
            LifeCycle lifeCycle = LifeCycle.parse((String)jobInfo.getLifecycle());
            if (lifeCycle.getEnd() != null && lifeCycle.getEnd() <= System.currentTimeMillis()) {
                this.stopInstance(instanceId, instanceInfo);
                instanceInfo.setStatus(Integer.valueOf(InstanceStatus.SUCCEED.getV()));
            } else {
                instanceInfo.setStatus(Integer.valueOf(receivedInstanceStatus.getV()));
            }
            instanceInfo.setResult(req.getResult());
            instanceInfo.setRunningTimes(Long.valueOf(req.getTotalTaskNum()));
            this.instanceInfoRepository.saveAndFlush((Object)instanceInfo);
            if (req.isNeedAlert()) {
                log.info("[InstanceManager-{}] receive frequent task alert req,time:{},content:{}", new Object[]{instanceId, req.getReportTime(), req.getAlertContent()});
                this.alert(instanceId, req.getAlertContent());
            }
            return;
        }
        if (instanceInfo.getStatus().intValue() == InstanceStatus.WAITING_WORKER_RECEIVE.getV()) {
            instanceInfo.setRunningTimes(Long.valueOf(instanceInfo.getRunningTimes() + 1L));
        }
        instanceInfo.setStatus(Integer.valueOf(receivedInstanceStatus.getV()));
        boolean finished = false;
        if (receivedInstanceStatus == InstanceStatus.SUCCEED) {
            instanceInfo.setResult(req.getResult());
            instanceInfo.setFinishedTime(Long.valueOf(req.getEndTime() == null ? System.currentTimeMillis() : req.getEndTime()));
            finished = true;
        } else if (receivedInstanceStatus == InstanceStatus.FAILED) {
            if (instanceInfo.getRunningTimes() <= (long)jobInfo.getInstanceRetryNum().intValue()) {
                log.info("[InstanceManager-{}] instance execute failed but will take the {}th retry.", (Object)instanceId, (Object)instanceInfo.getRunningTimes());
                instanceInfo.setExpectedTriggerTime(Long.valueOf(System.currentTimeMillis() + 10000L));
                instanceInfo.setStatus(Integer.valueOf(InstanceStatus.WAITING_DISPATCH.getV()));
            } else {
                instanceInfo.setResult(req.getResult());
                instanceInfo.setFinishedTime(Long.valueOf(req.getEndTime() == null ? System.currentTimeMillis() : req.getEndTime()));
                finished = true;
                log.info("[InstanceManager-{}] instance execute failed and have no chance to retry.", (Object)instanceId);
            }
        }
        if (finished) {
            this.instanceInfoRepository.saveAndFlush((Object)instanceInfo);
            this.processFinishedInstance(instanceId, req.getWfInstanceId(), receivedInstanceStatus, req.getResult());
            return;
        }
        int i = this.instanceInfoRepository.updateStatusChangeInfoByInstanceIdAndStatus(instanceInfo.getLastReportTime().longValue(), instanceInfo.getGmtModified(), instanceInfo.getRunningTimes().longValue(), instanceInfo.getStatus().intValue(), instanceInfo.getInstanceId().longValue(), originStatus);
        if (i == 0) {
            log.warn("[InstanceManager-{}] update instance status failed, maybe the instance status has been changed by other thread. discard this status change,{}", (Object)instanceId, (Object)instanceInfo);
        }
    }

    private void stopInstance(Long instanceId, InstanceInfoDO instanceInfo) {
        Optional workerInfoOpt = this.workerClusterQueryService.getWorkerInfoByAddress(instanceInfo.getAppId(), instanceInfo.getTaskTrackerAddress());
        if (workerInfoOpt.isPresent()) {
            ServerStopInstanceReq stopInstanceReq = new ServerStopInstanceReq(instanceId);
            WorkerInfo workerInfo = (WorkerInfo)workerInfoOpt.get();
            URL url = ServerURLFactory.stopInstance2Worker((String)workerInfo.getAddress());
            this.transportService.tell(workerInfo.getProtocol(), url, (PowerSerializable)stopInstanceReq);
        }
    }

    public void processFinishedInstance(Long instanceId, Long wfInstanceId, InstanceStatus status, String result) {
        log.info("[Instance-{}] process finished, final status is {}.", (Object)instanceId, (Object)status.name());
        HashedWheelTimerHolder.INACCURATE_TIMER.schedule(() -> this.instanceLogService.sync(instanceId), 60L, TimeUnit.SECONDS);
        if (wfInstanceId != null) {
            this.workflowInstanceManager.move(wfInstanceId, instanceId, status, result);
        }
        if (status == InstanceStatus.FAILED) {
            this.alert(instanceId, result);
        }
        this.instanceMetadataService.invalidateJobInfo(instanceId);
    }

    private void alert(Long instanceId, String alertContent) {
        JobInfoDO jobInfo;
        InstanceInfoDO instanceInfo = this.instanceInfoRepository.findByInstanceId(instanceId.longValue());
        try {
            jobInfo = this.instanceMetadataService.fetchJobInfoByInstanceId(instanceId);
        }
        catch (Exception e) {
            log.warn("[InstanceManager-{}] can't find jobInfo, alarm failed.", (Object)instanceId);
            return;
        }
        JobInstanceAlarm content = new JobInstanceAlarm();
        BeanUtils.copyProperties((Object)jobInfo, (Object)content);
        BeanUtils.copyProperties((Object)instanceInfo, (Object)content);
        List<UserInfoDO> userList = ((UserService)SpringUtils.getBean(UserService.class)).fetchNotifyUserList(jobInfo.getNotifyUserIds());
        if (!StringUtils.isEmpty((CharSequence)alertContent)) {
            content.setResult(alertContent);
        }
        this.alarmCenter.alarmFailed((Alarm)content, userList);
    }

    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public InstanceManager(AlarmCenter alarmCenter, InstanceLogService instanceLogService, InstanceMetadataService instanceMetadataService, InstanceInfoRepository instanceInfoRepository, WorkflowInstanceManager workflowInstanceManager, WorkerClusterQueryService workerClusterQueryService) {
        this.alarmCenter = alarmCenter;
        this.instanceLogService = instanceLogService;
        this.instanceMetadataService = instanceMetadataService;
        this.instanceInfoRepository = instanceInfoRepository;
        this.workflowInstanceManager = workflowInstanceManager;
        this.workerClusterQueryService = workerClusterQueryService;
    }
}

