/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.handler;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.request.ServerDeployContainerRequest;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.common.request.WorkerHeartbeat;
import tech.powerjob.common.request.WorkerLogReportReq;
import tech.powerjob.common.request.WorkerNeedDeployContainerRequest;
import tech.powerjob.common.request.WorkerQueryExecutorClusterReq;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.remote.framework.actor.Handler;
import tech.powerjob.remote.framework.actor.ProcessType;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.common.utils.SpringUtils;
import tech.powerjob.server.core.handler.IWorkerRequestHandler;
import tech.powerjob.server.monitor.Event;
import tech.powerjob.server.monitor.MonitorService;
import tech.powerjob.server.monitor.events.w2s.TtReportInstanceStatusEvent;
import tech.powerjob.server.monitor.events.w2s.WorkerHeartbeatEvent;
import tech.powerjob.server.monitor.events.w2s.WorkerLogReportEvent;
import tech.powerjob.server.persistence.remote.model.ContainerInfoDO;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.repository.ContainerInfoRepository;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.remote.worker.WorkerClusterQueryService;

public abstract class AbWorkerRequestHandler
implements IWorkerRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(AbWorkerRequestHandler.class);
    protected final MonitorService monitorService;
    protected final Environment environment;
    protected final ContainerInfoRepository containerInfoRepository;
    private final WorkerClusterQueryService workerClusterQueryService;

    protected abstract void processWorkerHeartbeat0(WorkerHeartbeat var1, WorkerHeartbeatEvent var2);

    protected abstract AskResponse processTaskTrackerReportInstanceStatus0(TaskTrackerReportInstanceStatusReq var1, TtReportInstanceStatusEvent var2) throws Exception;

    protected abstract void processWorkerLogReport0(WorkerLogReportReq var1, WorkerLogReportEvent var2);

    @Override
    @Handler(path="workerHeartbeat", processType=ProcessType.NO_BLOCKING)
    public void processWorkerHeartbeat(WorkerHeartbeat heartbeat) {
        long startMs = System.currentTimeMillis();
        WorkerHeartbeatEvent event = new WorkerHeartbeatEvent().setAppName(heartbeat.getAppName()).setAppId(heartbeat.getAppId()).setVersion(heartbeat.getVersion()).setProtocol(heartbeat.getProtocol()).setTag(heartbeat.getTag()).setWorkerAddress(heartbeat.getWorkerAddress()).setDelayMs(startMs - heartbeat.getHeartbeatTime()).setScore(Integer.valueOf(heartbeat.getSystemMetrics().getScore()));
        this.processWorkerHeartbeat0(heartbeat, event);
        this.monitorService.monitor((Event)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Handler(path="reportInstanceStatus", processType=ProcessType.BLOCKING)
    public AskResponse processTaskTrackerReportInstanceStatus(TaskTrackerReportInstanceStatusReq req) {
        long startMs = System.currentTimeMillis();
        TtReportInstanceStatusEvent event = new TtReportInstanceStatusEvent().setAppId(req.getAppId()).setJobId(req.getJobId()).setInstanceId(req.getInstanceId()).setWfInstanceId(req.getWfInstanceId()).setInstanceStatus(InstanceStatus.of((int)req.getInstanceStatus())).setDelayMs(Long.valueOf(startMs - req.getReportTime())).setServerProcessStatus(TtReportInstanceStatusEvent.Status.SUCCESS);
        try {
            AskResponse askResponse = this.processTaskTrackerReportInstanceStatus0(req, event);
            return askResponse;
        }
        catch (Exception e) {
            event.setServerProcessStatus(TtReportInstanceStatusEvent.Status.FAILED);
            log.error("[WorkerRequestHandler] processTaskTrackerReportInstanceStatus failed for request: {}", (Object)req, (Object)e);
            AskResponse askResponse = AskResponse.failed((String)ExceptionUtils.getMessage((Throwable)e));
            return askResponse;
        }
        finally {
            event.setServerProcessCost(Long.valueOf(System.currentTimeMillis() - startMs));
            this.monitorService.monitor((Event)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Handler(path="reportLog", processType=ProcessType.NO_BLOCKING)
    public void processWorkerLogReport(WorkerLogReportReq req) {
        WorkerLogReportEvent event = new WorkerLogReportEvent().setWorkerAddress(req.getWorkerAddress()).setLogNum((long)req.getInstanceLogContents().size());
        try {
            this.processWorkerLogReport0(req, event);
            event.setStatus(WorkerLogReportEvent.Status.SUCCESS);
        }
        catch (RejectedExecutionException re) {
            event.setStatus(WorkerLogReportEvent.Status.REJECTED);
        }
        catch (Throwable t) {
            event.setStatus(WorkerLogReportEvent.Status.EXCEPTION);
            log.warn("[WorkerRequestHandler] process worker report failed!", t);
        }
        finally {
            this.monitorService.monitor((Event)event);
        }
    }

    @Override
    @Handler(path="queryJobCluster", processType=ProcessType.BLOCKING)
    public AskResponse processWorkerQueryExecutorCluster(WorkerQueryExecutorClusterReq req) {
        AskResponse askResponse;
        Long jobId = req.getJobId();
        Long appId = req.getAppId();
        JobInfoRepository jobInfoRepository = (JobInfoRepository)SpringUtils.getBean(JobInfoRepository.class);
        Optional jobInfoOpt = jobInfoRepository.findById((Object)jobId);
        if (jobInfoOpt.isPresent()) {
            JobInfoDO jobInfo = (JobInfoDO)jobInfoOpt.get();
            if (!jobInfo.getAppId().equals(appId)) {
                askResponse = AskResponse.failed((String)"Permission Denied!");
            } else {
                List sortedAvailableWorker = this.workerClusterQueryService.getSuitableWorkers(jobInfo).stream().map(WorkerInfo::getAddress).collect(Collectors.toList());
                askResponse = AskResponse.succeed(sortedAvailableWorker);
            }
        } else {
            askResponse = AskResponse.failed((String)("can't find jobInfo by jobId: " + jobId));
        }
        return askResponse;
    }

    @Override
    @Handler(path="queryContainer", processType=ProcessType.BLOCKING)
    public AskResponse processWorkerNeedDeployContainer(WorkerNeedDeployContainerRequest req) {
        String port = this.environment.getProperty("local.server.port");
        Optional containerInfoOpt = this.containerInfoRepository.findById((Object)req.getContainerId());
        AskResponse askResponse = new AskResponse();
        if (!containerInfoOpt.isPresent() || ((ContainerInfoDO)containerInfoOpt.get()).getStatus().intValue() != SwitchableStatus.ENABLE.getV()) {
            askResponse.setSuccess(false);
            askResponse.setMessage("can't find container by id: " + req.getContainerId());
        } else {
            ContainerInfoDO containerInfo = (ContainerInfoDO)containerInfoOpt.get();
            askResponse.setSuccess(true);
            ServerDeployContainerRequest dpReq = new ServerDeployContainerRequest();
            BeanUtils.copyProperties((Object)containerInfo, (Object)dpReq);
            dpReq.setContainerId(containerInfo.getId());
            String downloadURL = String.format("http://%s:%s/container/downloadJar?version=%s", NetUtils.getLocalHost(), port, containerInfo.getVersion());
            dpReq.setDownloadURL(downloadURL);
            askResponse.setData(JsonUtils.toBytes((Object)dpReq));
        }
        return askResponse;
    }

    public AbWorkerRequestHandler(MonitorService monitorService, Environment environment, ContainerInfoRepository containerInfoRepository, WorkerClusterQueryService workerClusterQueryService) {
        this.monitorService = monitorService;
        this.environment = environment;
        this.containerInfoRepository = containerInfoRepository;
        this.workerClusterQueryService = workerClusterQueryService;
    }
}

